// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** An object representing a form field with distinct field label (key) and field value (may be empty). */
@Fluent
public final class DocumentKeyValuePair {
    /*
     * Field label of the key-value pair.
     */
    @JsonProperty(value = "key", required = true)
    private DocumentKeyValueElement key;

    /*
     * Field value of the key-value pair.
     */
    @JsonProperty(value = "value")
    private DocumentKeyValueElement value;

    /*
     * Confidence of correctly extracting the key-value pair.
     */
    @JsonProperty(value = "confidence", required = true)
    private float confidence;

    /** Creates an instance of DocumentKeyValuePair class. */
    public DocumentKeyValuePair() {}

    /**
     * Get the key property: Field label of the key-value pair.
     *
     * @return the key value.
     */
    public DocumentKeyValueElement getKey() {
        return this.key;
    }

    /**
     * Set the key property: Field label of the key-value pair.
     *
     * @param key the key value to set.
     * @return the DocumentKeyValuePair object itself.
     */
    public DocumentKeyValuePair setKey(DocumentKeyValueElement key) {
        this.key = key;
        return this;
    }

    /**
     * Get the value property: Field value of the key-value pair.
     *
     * @return the value value.
     */
    public DocumentKeyValueElement getValue() {
        return this.value;
    }

    /**
     * Set the value property: Field value of the key-value pair.
     *
     * @param value the value value to set.
     * @return the DocumentKeyValuePair object itself.
     */
    public DocumentKeyValuePair setValue(DocumentKeyValueElement value) {
        this.value = value;
        return this;
    }

    /**
     * Get the confidence property: Confidence of correctly extracting the key-value pair.
     *
     * @return the confidence value.
     */
    public float getConfidence() {
        return this.confidence;
    }

    /**
     * Set the confidence property: Confidence of correctly extracting the key-value pair.
     *
     * @param confidence the confidence value to set.
     * @return the DocumentKeyValuePair object itself.
     */
    public DocumentKeyValuePair setConfidence(float confidence) {
        this.confidence = confidence;
        return this;
    }
}
