// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Status and result of the analyze operation. */
@Fluent
public final class AnalyzeResultOperation {
    /*
     * Operation status.
     */
    @JsonProperty(value = "status", required = true)
    private AnalyzeResultOperationStatus status;

    /*
     * Date and time (UTC) when the analyze operation was submitted.
     */
    @JsonProperty(value = "createdDateTime", required = true)
    private OffsetDateTime createdDateTime;

    /*
     * Date and time (UTC) when the status was last updated.
     */
    @JsonProperty(value = "lastUpdatedDateTime", required = true)
    private OffsetDateTime lastUpdatedDateTime;

    /*
     * Encountered error during document analysis.
     */
    @JsonProperty(value = "error")
    private Error error;

    /*
     * Document analysis result.
     */
    @JsonProperty(value = "analyzeResult")
    private AnalyzeResult analyzeResult;

    /** Creates an instance of AnalyzeResultOperation class. */
    public AnalyzeResultOperation() {}

    /**
     * Get the status property: Operation status.
     *
     * @return the status value.
     */
    public AnalyzeResultOperationStatus getStatus() {
        return this.status;
    }

    /**
     * Set the status property: Operation status.
     *
     * @param status the status value to set.
     * @return the AnalyzeResultOperation object itself.
     */
    public AnalyzeResultOperation setStatus(AnalyzeResultOperationStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the createdDateTime property: Date and time (UTC) when the analyze operation was submitted.
     *
     * @return the createdDateTime value.
     */
    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    /**
     * Set the createdDateTime property: Date and time (UTC) when the analyze operation was submitted.
     *
     * @param createdDateTime the createdDateTime value to set.
     * @return the AnalyzeResultOperation object itself.
     */
    public AnalyzeResultOperation setCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    /**
     * Get the lastUpdatedDateTime property: Date and time (UTC) when the status was last updated.
     *
     * @return the lastUpdatedDateTime value.
     */
    public OffsetDateTime getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    /**
     * Set the lastUpdatedDateTime property: Date and time (UTC) when the status was last updated.
     *
     * @param lastUpdatedDateTime the lastUpdatedDateTime value to set.
     * @return the AnalyzeResultOperation object itself.
     */
    public AnalyzeResultOperation setLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        this.lastUpdatedDateTime = lastUpdatedDateTime;
        return this;
    }

    /**
     * Get the error property: Encountered error during document analysis.
     *
     * @return the error value.
     */
    public Error getError() {
        return this.error;
    }

    /**
     * Set the error property: Encountered error during document analysis.
     *
     * @param error the error value to set.
     * @return the AnalyzeResultOperation object itself.
     */
    public AnalyzeResultOperation setError(Error error) {
        this.error = error;
        return this;
    }

    /**
     * Get the analyzeResult property: Document analysis result.
     *
     * @return the analyzeResult value.
     */
    public AnalyzeResult getAnalyzeResult() {
        return this.analyzeResult;
    }

    /**
     * Set the analyzeResult property: Document analysis result.
     *
     * @param analyzeResult the analyzeResult value to set.
     * @return the AnalyzeResultOperation object itself.
     */
    public AnalyzeResultOperation setAnalyzeResult(AnalyzeResult analyzeResult) {
        this.analyzeResult = analyzeResult;
        return this;
    }
}
