// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.formrecognizer.documentanalysis.implementation;

import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeDocumentHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeDocumentRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AnalyzeResultOperation;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.AuthorizeCopyRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BuildDocumentModelHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.BuildDocumentModelRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ComposeDocumentModelHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ComposeDocumentModelRequest;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ContentType;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.CopyAuthorization;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.CopyDocumentModelToHeaders;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.DocumentModelSummary;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ErrorResponseException;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.GetDocumentModelsResponse;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.GetOperationsResponse;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.OperationSummary;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.ResourceDetails;
import com.azure.ai.formrecognizer.documentanalysis.implementation.models.StringIndexType;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.DefaultPollingStrategy;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncDefaultPollingStrategy;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.TypeReference;
import java.nio.ByteBuffer;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** Initializes a new instance of the FormRecognizerClient type. */
public final class FormRecognizerClientImpl {
    /** The proxy service used to perform REST calls. */
    private final FormRecognizerClientService service;

    /**
     * Supported Cognitive Services endpoints (protocol and hostname, for example:
     * https://westus2.api.cognitive.microsoft.com).
     */
    private final String endpoint;

    /**
     * Gets Supported Cognitive Services endpoints (protocol and hostname, for example:
     * https://westus2.api.cognitive.microsoft.com).
     *
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /** Api Version. */
    private final String apiVersion;

    /**
     * Gets Api Version.
     *
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /** The HTTP pipeline to send requests through. */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /** The serializer to serialize an object into a string. */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     *
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * Initializes an instance of FormRecognizerClient client.
     *
     * @param endpoint Supported Cognitive Services endpoints (protocol and hostname, for example:
     *     https://westus2.api.cognitive.microsoft.com).
     * @param apiVersion Api Version.
     */
    FormRecognizerClientImpl(String endpoint, String apiVersion) {
        this(
                new HttpPipelineBuilder()
                        .policies(new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy())
                        .build(),
                JacksonAdapter.createDefaultSerializerAdapter(),
                endpoint,
                apiVersion);
    }

    /**
     * Initializes an instance of FormRecognizerClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param endpoint Supported Cognitive Services endpoints (protocol and hostname, for example:
     *     https://westus2.api.cognitive.microsoft.com).
     * @param apiVersion Api Version.
     */
    FormRecognizerClientImpl(HttpPipeline httpPipeline, String endpoint, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    /**
     * Initializes an instance of FormRecognizerClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param endpoint Supported Cognitive Services endpoints (protocol and hostname, for example:
     *     https://westus2.api.cognitive.microsoft.com).
     * @param apiVersion Api Version.
     */
    FormRecognizerClientImpl(
            HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.apiVersion = apiVersion;
        this.service =
                RestProxy.create(FormRecognizerClientService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    /**
     * The interface defining all the services for FormRecognizerClient to be used by the proxy service to perform REST
     * calls.
     */
    @Host("{endpoint}/formrecognizer")
    @ServiceInterface(name = "FormRecognizerClient")
    public interface FormRecognizerClientService {
        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<AnalyzeDocumentHeaders, Void>> analyzeDocument(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("pages") String pages,
                @QueryParam("locale") String locale,
                @QueryParam("stringIndexType") StringIndexType stringIndexType,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") AnalyzeDocumentRequest analyzeRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<AnalyzeDocumentHeaders, Void> analyzeDocumentSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("pages") String pages,
                @QueryParam("locale") String locale,
                @QueryParam("stringIndexType") StringIndexType stringIndexType,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") AnalyzeDocumentRequest analyzeRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<AnalyzeDocumentHeaders, Void>> analyzeDocument(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("pages") String pages,
                @QueryParam("locale") String locale,
                @QueryParam("stringIndexType") StringIndexType stringIndexType,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Content-Type") ContentType contentType,
                @BodyParam("application/octet-stream") Flux<ByteBuffer> analyzeRequest,
                @HeaderParam("Content-Length") Long contentLength,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<AnalyzeDocumentHeaders, Void>> analyzeDocument(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("pages") String pages,
                @QueryParam("locale") String locale,
                @QueryParam("stringIndexType") StringIndexType stringIndexType,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Content-Type") ContentType contentType,
                @BodyParam("application/octet-stream") BinaryData analyzeRequest,
                @HeaderParam("Content-Length") Long contentLength,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<AnalyzeDocumentHeaders, Void> analyzeDocumentSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("pages") String pages,
                @QueryParam("locale") String locale,
                @QueryParam("stringIndexType") StringIndexType stringIndexType,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Content-Type") ContentType contentType,
                @BodyParam("application/octet-stream") BinaryData analyzeRequest,
                @HeaderParam("Content-Length") Long contentLength,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/documentModels/{modelId}/analyzeResults/{resultId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<AnalyzeResultOperation>> getAnalyzeDocumentResult(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @PathParam("resultId") String resultId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/documentModels/{modelId}/analyzeResults/{resultId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<AnalyzeResultOperation> getAnalyzeDocumentResultSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @PathParam("resultId") String resultId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels:build")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<BuildDocumentModelHeaders, Void>> buildDocumentModel(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") BuildDocumentModelRequest buildRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels:build")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<BuildDocumentModelHeaders, Void> buildDocumentModelSync(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") BuildDocumentModelRequest buildRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels:compose")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<ComposeDocumentModelHeaders, Void>> composeDocumentModel(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") ComposeDocumentModelRequest composeRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels:compose")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<ComposeDocumentModelHeaders, Void> composeDocumentModelSync(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") ComposeDocumentModelRequest composeRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels:authorizeCopy")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<CopyAuthorization>> authorizeCopyDocumentModel(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") AuthorizeCopyRequest authorizeCopyRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels:authorizeCopy")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<CopyAuthorization> authorizeCopyDocumentModelSync(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") AuthorizeCopyRequest authorizeCopyRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels/{modelId}:copyTo")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<ResponseBase<CopyDocumentModelToHeaders, Void>> copyDocumentModelTo(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") CopyAuthorization copyToRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/documentModels/{modelId}:copyTo")
        @ExpectedResponses({202})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        ResponseBase<CopyDocumentModelToHeaders, Void> copyDocumentModelToSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("api-version") String apiVersion,
                @BodyParam("application/json") CopyAuthorization copyToRequest,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/operations")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<GetOperationsResponse>> getOperations(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/operations")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<GetOperationsResponse> getOperationsSync(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/operations/{operationId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<OperationDetails>> getOperation(
                @HostParam("endpoint") String endpoint,
                @PathParam("operationId") String operationId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/operations/{operationId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<OperationDetails> getOperationSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("operationId") String operationId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/documentModels")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<GetDocumentModelsResponse>> getDocumentModels(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/documentModels")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<GetDocumentModelsResponse> getDocumentModelsSync(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/documentModels/{modelId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<DocumentModelDetails>> getDocumentModel(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/documentModels/{modelId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<DocumentModelDetails> getDocumentModelSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/documentModels/{modelId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<Void>> deleteDocumentModel(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/documentModels/{modelId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<Void> deleteDocumentModelSync(
                @HostParam("endpoint") String endpoint,
                @PathParam("modelId") String modelId,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/info")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<ResourceDetails>> getResourceDetails(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/info")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<ResourceDetails> getResourceDetailsSync(
                @HostParam("endpoint") String endpoint,
                @QueryParam("api-version") String apiVersion,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<GetOperationsResponse>> getOperationsNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<GetOperationsResponse> getOperationsNextSync(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<GetDocumentModelsResponse>> getDocumentModelsNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<GetDocumentModelsResponse> getDocumentModelsNextSync(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                Context context);
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            AnalyzeDocumentRequest analyzeRequest) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.analyzeDocument(
                                this.getEndpoint(),
                                modelId,
                                pages,
                                locale,
                                stringIndexType,
                                this.getApiVersion(),
                                analyzeRequest,
                                accept,
                                context));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            AnalyzeDocumentRequest analyzeRequest,
            Context context) {
        final String accept = "application/json";
        return service.analyzeDocument(
                this.getEndpoint(),
                modelId,
                pages,
                locale,
                stringIndexType,
                this.getApiVersion(),
                analyzeRequest,
                accept,
                context);
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AnalyzeDocumentHeaders, Void> analyzeDocumentWithResponse(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            AnalyzeDocumentRequest analyzeRequest,
            Context context) {
        final String accept = "application/json";
        return service.analyzeDocumentSync(
                this.getEndpoint(),
                modelId,
                pages,
                locale,
                stringIndexType,
                this.getApiVersion(),
                analyzeRequest,
                accept,
                context);
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            AnalyzeDocumentRequest analyzeRequest) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.analyzeDocumentWithResponseAsync(modelId, pages, locale, stringIndexType, analyzeRequest),
                new DefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            AnalyzeDocumentRequest analyzeRequest,
            Context context) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponseAsync(
                                modelId, pages, locale, stringIndexType, analyzeRequest, context),
                new DefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param analyzeRequest Analyze request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            AnalyzeDocumentRequest analyzeRequest) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponse(
                                modelId, pages, locale, stringIndexType, analyzeRequest, Context.NONE),
                new SyncDefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param analyzeRequest Analyze request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(
            String modelId,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            AnalyzeDocumentRequest analyzeRequest,
            Context context) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponse(
                                modelId, pages, locale, stringIndexType, analyzeRequest, context),
                new SyncDefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            Flux<ByteBuffer> analyzeRequest,
            Long contentLength) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.analyzeDocument(
                                this.getEndpoint(),
                                modelId,
                                pages,
                                locale,
                                stringIndexType,
                                this.getApiVersion(),
                                contentType,
                                analyzeRequest,
                                contentLength,
                                accept,
                                context));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            Flux<ByteBuffer> analyzeRequest,
            Long contentLength,
            Context context) {
        final String accept = "application/json";
        return service.analyzeDocument(
                this.getEndpoint(),
                modelId,
                pages,
                locale,
                stringIndexType,
                this.getApiVersion(),
                contentType,
                analyzeRequest,
                contentLength,
                accept,
                context);
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            Flux<ByteBuffer> analyzeRequest,
            Long contentLength) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponseAsync(
                                modelId, contentType, pages, locale, stringIndexType, analyzeRequest, contentLength),
                new DefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            Flux<ByteBuffer> analyzeRequest,
            Long contentLength,
            Context context) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponseAsync(
                                modelId,
                                contentType,
                                pages,
                                locale,
                                stringIndexType,
                                analyzeRequest,
                                contentLength,
                                context),
                new DefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            BinaryData analyzeRequest,
            Long contentLength) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.analyzeDocument(
                                this.getEndpoint(),
                                modelId,
                                pages,
                                locale,
                                stringIndexType,
                                this.getApiVersion(),
                                contentType,
                                analyzeRequest,
                                contentLength,
                                accept,
                                context));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<AnalyzeDocumentHeaders, Void>> analyzeDocumentWithResponseAsync(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            BinaryData analyzeRequest,
            Long contentLength,
            Context context) {
        final String accept = "application/json";
        return service.analyzeDocument(
                this.getEndpoint(),
                modelId,
                pages,
                locale,
                stringIndexType,
                this.getApiVersion(),
                contentType,
                analyzeRequest,
                contentLength,
                accept,
                context);
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<AnalyzeDocumentHeaders, Void> analyzeDocumentWithResponse(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            BinaryData analyzeRequest,
            Long contentLength,
            Context context) {
        final String accept = "application/json";
        return service.analyzeDocumentSync(
                this.getEndpoint(),
                modelId,
                pages,
                locale,
                stringIndexType,
                this.getApiVersion(),
                contentType,
                analyzeRequest,
                contentLength,
                accept,
                context);
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            BinaryData analyzeRequest,
            Long contentLength) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponseAsync(
                                modelId, contentType, pages, locale, stringIndexType, analyzeRequest, contentLength),
                new DefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            BinaryData analyzeRequest,
            Long contentLength,
            Context context) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponseAsync(
                                modelId,
                                contentType,
                                pages,
                                locale,
                                stringIndexType,
                                analyzeRequest,
                                contentLength,
                                context),
                new DefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            BinaryData analyzeRequest,
            Long contentLength) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponse(
                                modelId,
                                contentType,
                                pages,
                                locale,
                                stringIndexType,
                                analyzeRequest,
                                contentLength,
                                Context.NONE),
                new SyncDefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyze document
     *
     * <p>Analyzes document with document model.
     *
     * @param modelId Unique document model name.
     * @param contentType Upload file type.
     * @param pages List of 1-based page numbers to analyze. Ex. "1-3,5,7-9".
     * @param locale Locale hint for text recognition and document analysis. Value may contain only the language code
     *     (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").
     * @param stringIndexType Method used to compute string offset and length.
     * @param analyzeRequest Analyze request parameters.
     * @param contentLength The Content-Length header for the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(
            String modelId,
            ContentType contentType,
            String pages,
            String locale,
            StringIndexType stringIndexType,
            BinaryData analyzeRequest,
            Long contentLength,
            Context context) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () ->
                        this.analyzeDocumentWithResponse(
                                modelId,
                                contentType,
                                pages,
                                locale,
                                stringIndexType,
                                analyzeRequest,
                                contentLength,
                                context),
                new SyncDefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Get analyze result
     *
     * <p>Gets the result of document analysis.
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document analysis along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeResultOperation>> getAnalyzeDocumentResultWithResponseAsync(
            String modelId, String resultId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getAnalyzeDocumentResult(
                                this.getEndpoint(), modelId, resultId, this.getApiVersion(), accept, context));
    }

    /**
     * Get analyze result
     *
     * <p>Gets the result of document analysis.
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document analysis along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnalyzeResultOperation>> getAnalyzeDocumentResultWithResponseAsync(
            String modelId, String resultId, Context context) {
        final String accept = "application/json";
        return service.getAnalyzeDocumentResult(
                this.getEndpoint(), modelId, resultId, this.getApiVersion(), accept, context);
    }

    /**
     * Get analyze result
     *
     * <p>Gets the result of document analysis.
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document analysis on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeResultOperation> getAnalyzeDocumentResultAsync(String modelId, String resultId) {
        return getAnalyzeDocumentResultWithResponseAsync(modelId, resultId)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get analyze result
     *
     * <p>Gets the result of document analysis.
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document analysis on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnalyzeResultOperation> getAnalyzeDocumentResultAsync(
            String modelId, String resultId, Context context) {
        return getAnalyzeDocumentResultWithResponseAsync(modelId, resultId, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get analyze result
     *
     * <p>Gets the result of document analysis.
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document analysis along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnalyzeResultOperation> getAnalyzeDocumentResultWithResponse(
            String modelId, String resultId, Context context) {
        final String accept = "application/json";
        return service.getAnalyzeDocumentResultSync(
                this.getEndpoint(), modelId, resultId, this.getApiVersion(), accept, context);
    }

    /**
     * Get analyze result
     *
     * <p>Gets the result of document analysis.
     *
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result of document analysis.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnalyzeResultOperation getAnalyzeDocumentResult(String modelId, String resultId) {
        return getAnalyzeDocumentResultWithResponse(modelId, resultId, Context.NONE).getValue();
    }

    /**
     * Build document model
     *
     * <p>Builds a custom document analysis model.
     *
     * @param buildRequest Building request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<BuildDocumentModelHeaders, Void>> buildDocumentModelWithResponseAsync(
            BuildDocumentModelRequest buildRequest) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.buildDocumentModel(
                                this.getEndpoint(), this.getApiVersion(), buildRequest, accept, context));
    }

    /**
     * Build document model
     *
     * <p>Builds a custom document analysis model.
     *
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<BuildDocumentModelHeaders, Void>> buildDocumentModelWithResponseAsync(
            BuildDocumentModelRequest buildRequest, Context context) {
        final String accept = "application/json";
        return service.buildDocumentModel(this.getEndpoint(), this.getApiVersion(), buildRequest, accept, context);
    }

    /**
     * Build document model
     *
     * <p>Builds a custom document analysis model.
     *
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<BuildDocumentModelHeaders, Void> buildDocumentModelWithResponse(
            BuildDocumentModelRequest buildRequest, Context context) {
        final String accept = "application/json";
        return service.buildDocumentModelSync(this.getEndpoint(), this.getApiVersion(), buildRequest, accept, context);
    }

    /**
     * Build document model
     *
     * <p>Builds a custom document analysis model.
     *
     * @param buildRequest Building request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildDocumentModelAsync(BuildDocumentModelRequest buildRequest) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.buildDocumentModelWithResponseAsync(buildRequest),
                new DefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Build document model
     *
     * <p>Builds a custom document analysis model.
     *
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildDocumentModelAsync(
            BuildDocumentModelRequest buildRequest, Context context) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.buildDocumentModelWithResponseAsync(buildRequest, context),
                new DefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Build document model
     *
     * <p>Builds a custom document analysis model.
     *
     * @param buildRequest Building request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildDocumentModel(BuildDocumentModelRequest buildRequest) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () -> this.buildDocumentModelWithResponse(buildRequest, Context.NONE),
                new SyncDefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Build document model
     *
     * <p>Builds a custom document analysis model.
     *
     * @param buildRequest Building request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildDocumentModel(
            BuildDocumentModelRequest buildRequest, Context context) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () -> this.buildDocumentModelWithResponse(buildRequest, context),
                new SyncDefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Compose document model
     *
     * <p>Creates a new document model from document types of existing document models.
     *
     * @param composeRequest Compose request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ComposeDocumentModelHeaders, Void>> composeDocumentModelWithResponseAsync(
            ComposeDocumentModelRequest composeRequest) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.composeDocumentModel(
                                this.getEndpoint(), this.getApiVersion(), composeRequest, accept, context));
    }

    /**
     * Compose document model
     *
     * <p>Creates a new document model from document types of existing document models.
     *
     * @param composeRequest Compose request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<ComposeDocumentModelHeaders, Void>> composeDocumentModelWithResponseAsync(
            ComposeDocumentModelRequest composeRequest, Context context) {
        final String accept = "application/json";
        return service.composeDocumentModel(this.getEndpoint(), this.getApiVersion(), composeRequest, accept, context);
    }

    /**
     * Compose document model
     *
     * <p>Creates a new document model from document types of existing document models.
     *
     * @param composeRequest Compose request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<ComposeDocumentModelHeaders, Void> composeDocumentModelWithResponse(
            ComposeDocumentModelRequest composeRequest, Context context) {
        final String accept = "application/json";
        return service.composeDocumentModelSync(
                this.getEndpoint(), this.getApiVersion(), composeRequest, accept, context);
    }

    /**
     * Compose document model
     *
     * <p>Creates a new document model from document types of existing document models.
     *
     * @param composeRequest Compose request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginComposeDocumentModelAsync(
            ComposeDocumentModelRequest composeRequest) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.composeDocumentModelWithResponseAsync(composeRequest),
                new DefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Compose document model
     *
     * <p>Creates a new document model from document types of existing document models.
     *
     * @param composeRequest Compose request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginComposeDocumentModelAsync(
            ComposeDocumentModelRequest composeRequest, Context context) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.composeDocumentModelWithResponseAsync(composeRequest, context),
                new DefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Compose document model
     *
     * <p>Creates a new document model from document types of existing document models.
     *
     * @param composeRequest Compose request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginComposeDocumentModel(ComposeDocumentModelRequest composeRequest) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () -> this.composeDocumentModelWithResponse(composeRequest, Context.NONE),
                new SyncDefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Compose document model
     *
     * <p>Creates a new document model from document types of existing document models.
     *
     * @param composeRequest Compose request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginComposeDocumentModel(
            ComposeDocumentModelRequest composeRequest, Context context) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () -> this.composeDocumentModelWithResponse(composeRequest, context),
                new SyncDefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Generate copy authorization
     *
     * <p>Generates authorization to copy a document model to this location with specified modelId and optional
     * description.
     *
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document model to the specified target resource and modelId along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CopyAuthorization>> authorizeCopyDocumentModelWithResponseAsync(
            AuthorizeCopyRequest authorizeCopyRequest) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.authorizeCopyDocumentModel(
                                this.getEndpoint(), this.getApiVersion(), authorizeCopyRequest, accept, context));
    }

    /**
     * Generate copy authorization
     *
     * <p>Generates authorization to copy a document model to this location with specified modelId and optional
     * description.
     *
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document model to the specified target resource and modelId along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CopyAuthorization>> authorizeCopyDocumentModelWithResponseAsync(
            AuthorizeCopyRequest authorizeCopyRequest, Context context) {
        final String accept = "application/json";
        return service.authorizeCopyDocumentModel(
                this.getEndpoint(), this.getApiVersion(), authorizeCopyRequest, accept, context);
    }

    /**
     * Generate copy authorization
     *
     * <p>Generates authorization to copy a document model to this location with specified modelId and optional
     * description.
     *
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document model to the specified target resource and modelId on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CopyAuthorization> authorizeCopyDocumentModelAsync(AuthorizeCopyRequest authorizeCopyRequest) {
        return authorizeCopyDocumentModelWithResponseAsync(authorizeCopyRequest)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Generate copy authorization
     *
     * <p>Generates authorization to copy a document model to this location with specified modelId and optional
     * description.
     *
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document model to the specified target resource and modelId on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CopyAuthorization> authorizeCopyDocumentModelAsync(
            AuthorizeCopyRequest authorizeCopyRequest, Context context) {
        return authorizeCopyDocumentModelWithResponseAsync(authorizeCopyRequest, context)
                .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Generate copy authorization
     *
     * <p>Generates authorization to copy a document model to this location with specified modelId and optional
     * description.
     *
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document model to the specified target resource and modelId along with {@link
     *     Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CopyAuthorization> authorizeCopyDocumentModelWithResponse(
            AuthorizeCopyRequest authorizeCopyRequest, Context context) {
        final String accept = "application/json";
        return service.authorizeCopyDocumentModelSync(
                this.getEndpoint(), this.getApiVersion(), authorizeCopyRequest, accept, context);
    }

    /**
     * Generate copy authorization
     *
     * <p>Generates authorization to copy a document model to this location with specified modelId and optional
     * description.
     *
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document model to the specified target resource and modelId.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CopyAuthorization authorizeCopyDocumentModel(AuthorizeCopyRequest authorizeCopyRequest) {
        return authorizeCopyDocumentModelWithResponse(authorizeCopyRequest, Context.NONE).getValue();
    }

    /**
     * Copy document model
     *
     * <p>Copies document model to the target resource, region, and modelId.
     *
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CopyDocumentModelToHeaders, Void>> copyDocumentModelToWithResponseAsync(
            String modelId, CopyAuthorization copyToRequest) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.copyDocumentModelTo(
                                this.getEndpoint(), modelId, this.getApiVersion(), copyToRequest, accept, context));
    }

    /**
     * Copy document model
     *
     * <p>Copies document model to the target resource, region, and modelId.
     *
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<CopyDocumentModelToHeaders, Void>> copyDocumentModelToWithResponseAsync(
            String modelId, CopyAuthorization copyToRequest, Context context) {
        final String accept = "application/json";
        return service.copyDocumentModelTo(
                this.getEndpoint(), modelId, this.getApiVersion(), copyToRequest, accept, context);
    }

    /**
     * Copy document model
     *
     * <p>Copies document model to the target resource, region, and modelId.
     *
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<CopyDocumentModelToHeaders, Void> copyDocumentModelToWithResponse(
            String modelId, CopyAuthorization copyToRequest, Context context) {
        final String accept = "application/json";
        return service.copyDocumentModelToSync(
                this.getEndpoint(), modelId, this.getApiVersion(), copyToRequest, accept, context);
    }

    /**
     * Copy document model
     *
     * <p>Copies document model to the target resource, region, and modelId.
     *
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyDocumentModelToAsync(
            String modelId, CopyAuthorization copyToRequest) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.copyDocumentModelToWithResponseAsync(modelId, copyToRequest),
                new DefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Copy document model
     *
     * <p>Copies document model to the target resource, region, and modelId.
     *
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyDocumentModelToAsync(
            String modelId, CopyAuthorization copyToRequest, Context context) {
        return PollerFlux.create(
                Duration.ofSeconds(1),
                () -> this.copyDocumentModelToWithResponseAsync(modelId, copyToRequest, context),
                new DefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Copy document model
     *
     * <p>Copies document model to the target resource, region, and modelId.
     *
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyDocumentModelTo(
            String modelId, CopyAuthorization copyToRequest) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () -> this.copyDocumentModelToWithResponse(modelId, copyToRequest, Context.NONE),
                new SyncDefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        Context.NONE),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Copy document model
     *
     * <p>Copies document model to the target resource, region, and modelId.
     *
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyDocumentModelTo(
            String modelId, CopyAuthorization copyToRequest, Context context) {
        return SyncPoller.createPoller(
                Duration.ofSeconds(1),
                () -> this.copyDocumentModelToWithResponse(modelId, copyToRequest, context),
                new SyncDefaultPollingStrategy<>(
                        this.getHttpPipeline(),
                        "{endpoint}/formrecognizer".replace("{endpoint}", this.getEndpoint()),
                        null,
                        context),
                TypeReference.createInstance(BinaryData.class),
                TypeReference.createInstance(BinaryData.class));
    }

    /**
     * List operations
     *
     * <p>Lists all operations.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list Operations response object along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<OperationSummary>> getOperationsSinglePageAsync() {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context -> service.getOperations(this.getEndpoint(), this.getApiVersion(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List operations
     *
     * <p>Lists all operations.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list Operations response object along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<OperationSummary>> getOperationsSinglePageAsync(Context context) {
        final String accept = "application/json";
        return service.getOperations(this.getEndpoint(), this.getApiVersion(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List operations
     *
     * <p>Lists all operations.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list Operations response object as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<OperationSummary> getOperationsAsync() {
        return new PagedFlux<>(
                () -> getOperationsSinglePageAsync(), nextLink -> getOperationsNextSinglePageAsync(nextLink));
    }

    /**
     * List operations
     *
     * <p>Lists all operations.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list Operations response object as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<OperationSummary> getOperationsAsync(Context context) {
        return new PagedFlux<>(
                () -> getOperationsSinglePageAsync(context),
                nextLink -> getOperationsNextSinglePageAsync(nextLink, context));
    }

    /**
     * List operations
     *
     * <p>Lists all operations.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list Operations response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<OperationSummary> getOperationsSinglePage() {
        final String accept = "application/json";
        Response<GetOperationsResponse> res =
                service.getOperationsSync(this.getEndpoint(), this.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * List operations
     *
     * <p>Lists all operations.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list Operations response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<OperationSummary> getOperationsSinglePage(Context context) {
        final String accept = "application/json";
        Response<GetOperationsResponse> res =
                service.getOperationsSync(this.getEndpoint(), this.getApiVersion(), accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * List operations
     *
     * <p>Lists all operations.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list Operations response object as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<OperationSummary> getOperations() {
        return new PagedIterable<>(
                () -> getOperationsSinglePage(Context.NONE), nextLink -> getOperationsNextSinglePage(nextLink));
    }

    /**
     * List operations
     *
     * <p>Lists all operations.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list Operations response object as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<OperationSummary> getOperations(Context context) {
        return new PagedIterable<>(
                () -> getOperationsSinglePage(context), nextLink -> getOperationsNextSinglePage(nextLink, context));
    }

    /**
     * Get operation
     *
     * <p>Gets operation info.
     *
     * @param operationId Unique operation ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return operation info along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<OperationDetails>> getOperationWithResponseAsync(String operationId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getOperation(this.getEndpoint(), operationId, this.getApiVersion(), accept, context));
    }

    /**
     * Get operation
     *
     * <p>Gets operation info.
     *
     * @param operationId Unique operation ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return operation info along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<OperationDetails>> getOperationWithResponseAsync(String operationId, Context context) {
        final String accept = "application/json";
        return service.getOperation(this.getEndpoint(), operationId, this.getApiVersion(), accept, context);
    }

    /**
     * Get operation
     *
     * <p>Gets operation info.
     *
     * @param operationId Unique operation ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return operation info on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<OperationDetails> getOperationAsync(String operationId) {
        return getOperationWithResponseAsync(operationId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get operation
     *
     * <p>Gets operation info.
     *
     * @param operationId Unique operation ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return operation info on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<OperationDetails> getOperationAsync(String operationId, Context context) {
        return getOperationWithResponseAsync(operationId, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get operation
     *
     * <p>Gets operation info.
     *
     * @param operationId Unique operation ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return operation info along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<OperationDetails> getOperationWithResponse(String operationId, Context context) {
        final String accept = "application/json";
        return service.getOperationSync(this.getEndpoint(), operationId, this.getApiVersion(), accept, context);
    }

    /**
     * Get operation
     *
     * <p>Gets operation info.
     *
     * @param operationId Unique operation ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return operation info.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public OperationDetails getOperation(String operationId) {
        return getOperationWithResponse(operationId, Context.NONE).getValue();
    }

    /**
     * List document models
     *
     * <p>List all document models.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> getDocumentModelsSinglePageAsync() {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context -> service.getDocumentModels(this.getEndpoint(), this.getApiVersion(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List document models
     *
     * <p>List all document models.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> getDocumentModelsSinglePageAsync(Context context) {
        final String accept = "application/json";
        return service.getDocumentModels(this.getEndpoint(), this.getApiVersion(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List document models
     *
     * <p>List all document models.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DocumentModelSummary> getDocumentModelsAsync() {
        return new PagedFlux<>(
                () -> getDocumentModelsSinglePageAsync(), nextLink -> getDocumentModelsNextSinglePageAsync(nextLink));
    }

    /**
     * List document models
     *
     * <p>List all document models.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DocumentModelSummary> getDocumentModelsAsync(Context context) {
        return new PagedFlux<>(
                () -> getDocumentModelsSinglePageAsync(context),
                nextLink -> getDocumentModelsNextSinglePageAsync(nextLink, context));
    }

    /**
     * List document models
     *
     * <p>List all document models.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> getDocumentModelsSinglePage() {
        final String accept = "application/json";
        Response<GetDocumentModelsResponse> res =
                service.getDocumentModelsSync(this.getEndpoint(), this.getApiVersion(), accept, Context.NONE);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * List document models
     *
     * <p>List all document models.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> getDocumentModelsSinglePage(Context context) {
        final String accept = "application/json";
        Response<GetDocumentModelsResponse> res =
                service.getDocumentModelsSync(this.getEndpoint(), this.getApiVersion(), accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * List document models
     *
     * <p>List all document models.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DocumentModelSummary> getDocumentModels() {
        return new PagedIterable<>(
                () -> getDocumentModelsSinglePage(Context.NONE), nextLink -> getDocumentModelsNextSinglePage(nextLink));
    }

    /**
     * List document models
     *
     * <p>List all document models.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DocumentModelSummary> getDocumentModels(Context context) {
        return new PagedIterable<>(
                () -> getDocumentModelsSinglePage(context),
                nextLink -> getDocumentModelsNextSinglePage(nextLink, context));
    }

    /**
     * Get document model
     *
     * <p>Gets detailed document model information.
     *
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document model information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DocumentModelDetails>> getDocumentModelWithResponseAsync(String modelId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getDocumentModel(this.getEndpoint(), modelId, this.getApiVersion(), accept, context));
    }

    /**
     * Get document model
     *
     * <p>Gets detailed document model information.
     *
     * @param modelId Unique document model name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document model information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DocumentModelDetails>> getDocumentModelWithResponseAsync(String modelId, Context context) {
        final String accept = "application/json";
        return service.getDocumentModel(this.getEndpoint(), modelId, this.getApiVersion(), accept, context);
    }

    /**
     * Get document model
     *
     * <p>Gets detailed document model information.
     *
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document model information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DocumentModelDetails> getDocumentModelAsync(String modelId) {
        return getDocumentModelWithResponseAsync(modelId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get document model
     *
     * <p>Gets detailed document model information.
     *
     * @param modelId Unique document model name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document model information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DocumentModelDetails> getDocumentModelAsync(String modelId, Context context) {
        return getDocumentModelWithResponseAsync(modelId, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get document model
     *
     * <p>Gets detailed document model information.
     *
     * @param modelId Unique document model name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document model information along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DocumentModelDetails> getDocumentModelWithResponse(String modelId, Context context) {
        final String accept = "application/json";
        return service.getDocumentModelSync(this.getEndpoint(), modelId, this.getApiVersion(), accept, context);
    }

    /**
     * Get document model
     *
     * <p>Gets detailed document model information.
     *
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document model information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DocumentModelDetails getDocumentModel(String modelId) {
        return getDocumentModelWithResponse(modelId, Context.NONE).getValue();
    }

    /**
     * Delete document model
     *
     * <p>Deletes document model.
     *
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDocumentModelWithResponseAsync(String modelId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.deleteDocumentModel(
                                this.getEndpoint(), modelId, this.getApiVersion(), accept, context));
    }

    /**
     * Delete document model
     *
     * <p>Deletes document model.
     *
     * @param modelId Unique document model name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDocumentModelWithResponseAsync(String modelId, Context context) {
        final String accept = "application/json";
        return service.deleteDocumentModel(this.getEndpoint(), modelId, this.getApiVersion(), accept, context);
    }

    /**
     * Delete document model
     *
     * <p>Deletes document model.
     *
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteDocumentModelAsync(String modelId) {
        return deleteDocumentModelWithResponseAsync(modelId).flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete document model
     *
     * <p>Deletes document model.
     *
     * @param modelId Unique document model name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteDocumentModelAsync(String modelId, Context context) {
        return deleteDocumentModelWithResponseAsync(modelId, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Delete document model
     *
     * <p>Deletes document model.
     *
     * @param modelId Unique document model name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteDocumentModelWithResponse(String modelId, Context context) {
        final String accept = "application/json";
        return service.deleteDocumentModelSync(this.getEndpoint(), modelId, this.getApiVersion(), accept, context);
    }

    /**
     * Delete document model
     *
     * <p>Deletes document model.
     *
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteDocumentModel(String modelId) {
        deleteDocumentModelWithResponse(modelId, Context.NONE);
    }

    /**
     * Get resource info
     *
     * <p>Return information about the current resource.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return general information regarding the current resource along with {@link Response} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ResourceDetails>> getResourceDetailsWithResponseAsync() {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context -> service.getResourceDetails(this.getEndpoint(), this.getApiVersion(), accept, context));
    }

    /**
     * Get resource info
     *
     * <p>Return information about the current resource.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return general information regarding the current resource along with {@link Response} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ResourceDetails>> getResourceDetailsWithResponseAsync(Context context) {
        final String accept = "application/json";
        return service.getResourceDetails(this.getEndpoint(), this.getApiVersion(), accept, context);
    }

    /**
     * Get resource info
     *
     * <p>Return information about the current resource.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return general information regarding the current resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResourceDetails> getResourceDetailsAsync() {
        return getResourceDetailsWithResponseAsync().flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get resource info
     *
     * <p>Return information about the current resource.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return general information regarding the current resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResourceDetails> getResourceDetailsAsync(Context context) {
        return getResourceDetailsWithResponseAsync(context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get resource info
     *
     * <p>Return information about the current resource.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return general information regarding the current resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ResourceDetails> getResourceDetailsWithResponse(Context context) {
        final String accept = "application/json";
        return service.getResourceDetailsSync(this.getEndpoint(), this.getApiVersion(), accept, context);
    }

    /**
     * Get resource info
     *
     * <p>Return information about the current resource.
     *
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return general information regarding the current resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResourceDetails getResourceDetails() {
        return getResourceDetailsWithResponse(Context.NONE).getValue();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list Operations response object along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<OperationSummary>> getOperationsNextSinglePageAsync(String nextLink) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getOperationsNext(nextLink, this.getEndpoint(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list Operations response object along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<OperationSummary>> getOperationsNextSinglePageAsync(String nextLink, Context context) {
        final String accept = "application/json";
        return service.getOperationsNext(nextLink, this.getEndpoint(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list Operations response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<OperationSummary> getOperationsNextSinglePage(String nextLink) {
        final String accept = "application/json";
        Response<GetOperationsResponse> res =
                service.getOperationsNextSync(nextLink, this.getEndpoint(), accept, Context.NONE);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list Operations response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<OperationSummary> getOperationsNextSinglePage(String nextLink, Context context) {
        final String accept = "application/json";
        Response<GetOperationsResponse> res =
                service.getOperationsNextSync(nextLink, this.getEndpoint(), accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> getDocumentModelsNextSinglePageAsync(String nextLink) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context -> service.getDocumentModelsNext(nextLink, this.getEndpoint(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DocumentModelSummary>> getDocumentModelsNextSinglePageAsync(
            String nextLink, Context context) {
        final String accept = "application/json";
        return service.getDocumentModelsNext(nextLink, this.getEndpoint(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> getDocumentModelsNextSinglePage(String nextLink) {
        final String accept = "application/json";
        Response<GetDocumentModelsResponse> res =
                service.getDocumentModelsNextSync(nextLink, this.getEndpoint(), accept, Context.NONE);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The URL to get the next list of items
     *     <p>The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list document models response object along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<DocumentModelSummary> getDocumentModelsNextSinglePage(String nextLink, Context context) {
        final String accept = "application/json";
        Response<GetDocumentModelsResponse> res =
                service.getDocumentModelsNextSync(nextLink, this.getEndpoint(), accept, context);
        return new PagedResponseBase<>(
                res.getRequest(),
                res.getStatusCode(),
                res.getHeaders(),
                res.getValue().getValue(),
                res.getValue().getNextLink(),
                null);
    }
}
