/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer;

import com.azure.ai.formrecognizer.FormRecognizerClientBuilder;
import com.azure.ai.formrecognizer.FormRecognizerServiceVersion;
import com.azure.ai.formrecognizer.Transforms;
import com.azure.ai.formrecognizer.implementation.FormRecognizerClientImpl;
import com.azure.ai.formrecognizer.implementation.Utility;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeBusinessCardAsyncHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeIdDocumentAsyncHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeInvoiceAsyncHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeLayoutAsyncHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeOperationResult;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeReceiptAsyncHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeWithCustomModelHeaders;
import com.azure.ai.formrecognizer.implementation.models.ContentType;
import com.azure.ai.formrecognizer.implementation.models.Language;
import com.azure.ai.formrecognizer.implementation.models.Locale;
import com.azure.ai.formrecognizer.implementation.models.ReadingOrder;
import com.azure.ai.formrecognizer.implementation.models.SourcePath;
import com.azure.ai.formrecognizer.models.FormContentType;
import com.azure.ai.formrecognizer.models.FormPage;
import com.azure.ai.formrecognizer.models.FormRecognizerErrorInformation;
import com.azure.ai.formrecognizer.models.FormRecognizerException;
import com.azure.ai.formrecognizer.models.FormRecognizerLocale;
import com.azure.ai.formrecognizer.models.FormRecognizerOperationResult;
import com.azure.ai.formrecognizer.models.RecognizeBusinessCardsOptions;
import com.azure.ai.formrecognizer.models.RecognizeContentOptions;
import com.azure.ai.formrecognizer.models.RecognizeCustomFormsOptions;
import com.azure.ai.formrecognizer.models.RecognizeIdentityDocumentOptions;
import com.azure.ai.formrecognizer.models.RecognizeInvoicesOptions;
import com.azure.ai.formrecognizer.models.RecognizeReceiptsOptions;
import com.azure.ai.formrecognizer.models.RecognizedForm;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=FormRecognizerClientBuilder.class, isAsync=true)
public final class FormRecognizerAsyncClient {
    private final ClientLogger logger = new ClientLogger(FormRecognizerAsyncClient.class);
    private final FormRecognizerClientImpl service;
    private final FormRecognizerServiceVersion serviceVersion;

    FormRecognizerAsyncClient(FormRecognizerClientImpl service, FormRecognizerServiceVersion serviceVersion) {
        this.service = service;
        this.serviceVersion = serviceVersion;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomFormsFromUrl(String modelId, String formUrl) {
        return this.beginRecognizeCustomFormsFromUrl(modelId, formUrl, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomFormsFromUrl(String modelId, String formUrl, RecognizeCustomFormsOptions recognizeCustomFormsOptions) {
        return this.beginRecognizeCustomFormsFromUrl(formUrl, modelId, recognizeCustomFormsOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomFormsFromUrl(String formUrl, String modelId, RecognizeCustomFormsOptions recognizeCustomFormsOptions, Context context) {
        try {
            Objects.requireNonNull(formUrl, "'formUrl' is required and cannot be null.");
            Objects.requireNonNull(modelId, "'modelId' is required and cannot be null.");
            RecognizeCustomFormsOptions finalRecognizeCustomFormsOptions = FormRecognizerAsyncClient.getRecognizeCustomFormOptions(recognizeCustomFormsOptions);
            boolean isFieldElementsIncluded = finalRecognizeCustomFormsOptions.isFieldElementsIncluded();
            return new PollerFlux(finalRecognizeCustomFormsOptions.getPollInterval(), Utility.urlActivationOperation(() -> this.service.analyzeWithCustomModelWithResponseAsync(UUID.fromString(modelId), isFieldElementsIncluded, finalRecognizeCustomFormsOptions.getPages(), new SourcePath().setSource(formUrl), context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzeWithCustomModelHeaders)response.getDeserializedHeaders()).getOperationLocation()))), this.logger), this.pollingOperation(resultUid -> this.service.getAnalyzeFormResultWithResponseAsync(UUID.fromString(modelId), (UUID)resultUid, context)), (activationResponse, pollingContext) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.service.getAnalyzeFormResultWithResponseAsync(UUID.fromString(modelId), (UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, modelId)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomForms(String modelId, Flux<ByteBuffer> form, long length) {
        return this.beginRecognizeCustomForms(modelId, form, length, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomForms(String modelId, Flux<ByteBuffer> form, long length, RecognizeCustomFormsOptions recognizeCustomFormsOptions) {
        return this.beginRecognizeCustomForms(modelId, form, length, recognizeCustomFormsOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeCustomForms(String modelId, Flux<ByteBuffer> form, long length, RecognizeCustomFormsOptions recognizeCustomFormsOptions, Context context) {
        try {
            Objects.requireNonNull(form, "'form' is required and cannot be null.");
            Objects.requireNonNull(modelId, "'modelId' is required and cannot be null.");
            RecognizeCustomFormsOptions finalRecognizeCustomFormsOptions = FormRecognizerAsyncClient.getRecognizeCustomFormOptions(recognizeCustomFormsOptions);
            boolean isFieldElementsIncluded = finalRecognizeCustomFormsOptions.isFieldElementsIncluded();
            return new PollerFlux(finalRecognizeCustomFormsOptions.getPollInterval(), this.streamActivationOperation(contentType -> this.service.analyzeWithCustomModelWithResponseAsync(UUID.fromString(modelId), ContentType.fromString(contentType.toString()), isFieldElementsIncluded, finalRecognizeCustomFormsOptions.getPages(), form, length, context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzeWithCustomModelHeaders)response.getDeserializedHeaders()).getOperationLocation()))), form, finalRecognizeCustomFormsOptions.getContentType()), this.pollingOperation(resultUuid -> this.service.getAnalyzeFormResultWithResponseAsync(UUID.fromString(modelId), (UUID)resultUuid, context)), (activationResponse, pollingContext) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.service.getAnalyzeFormResultWithResponseAsync(UUID.fromString(modelId), (UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, modelId)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContentFromUrl(String formUrl) {
        return this.beginRecognizeContentFromUrl(formUrl, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContentFromUrl(String formUrl, RecognizeContentOptions recognizeContentOptions) {
        return this.beginRecognizeContentFromUrl(formUrl, recognizeContentOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContentFromUrl(String formUrl, RecognizeContentOptions recognizeContentOptions, Context context) {
        try {
            Objects.requireNonNull(formUrl, "'formUrl' is required and cannot be null.");
            RecognizeContentOptions finalRecognizeContentOptions = FormRecognizerAsyncClient.getRecognizeContentOptions(recognizeContentOptions);
            return new PollerFlux(finalRecognizeContentOptions.getPollInterval(), Utility.urlActivationOperation(() -> this.service.analyzeLayoutAsyncWithResponseAsync(finalRecognizeContentOptions.getPages(), finalRecognizeContentOptions.getLanguage() == null ? null : Language.fromString(finalRecognizeContentOptions.getLanguage().toString()), finalRecognizeContentOptions.getReadingOrder() != null ? ReadingOrder.fromString(finalRecognizeContentOptions.getReadingOrder().toString()) : null, new SourcePath().setSource(formUrl), context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzeLayoutAsyncHeaders)response.getDeserializedHeaders()).getOperationLocation()))), this.logger), this.pollingOperation(resultId -> this.service.getAnalyzeLayoutResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.service.getAnalyzeLayoutResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedLayout(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), true)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContent(Flux<ByteBuffer> form, long length) {
        return this.beginRecognizeContent(form, length, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContent(Flux<ByteBuffer> form, long length, RecognizeContentOptions recognizeContentOptions) {
        return this.beginRecognizeContent(form, length, recognizeContentOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<FormPage>> beginRecognizeContent(Flux<ByteBuffer> form, long length, RecognizeContentOptions recognizeContentOptions, Context context) {
        try {
            Objects.requireNonNull(form, "'form' is required and cannot be null.");
            RecognizeContentOptions finalRecognizeContentOptions = FormRecognizerAsyncClient.getRecognizeContentOptions(recognizeContentOptions);
            return new PollerFlux(finalRecognizeContentOptions.getPollInterval(), this.streamActivationOperation(contentType -> this.service.analyzeLayoutAsyncWithResponseAsync((ContentType)((Object)contentType), finalRecognizeContentOptions.getPages(), finalRecognizeContentOptions.getLanguage() == null ? null : Language.fromString(finalRecognizeContentOptions.getLanguage().toString()), finalRecognizeContentOptions.getReadingOrder() != null ? ReadingOrder.fromString(finalRecognizeContentOptions.getReadingOrder().toString()) : null, form, length, context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzeLayoutAsyncHeaders)response.getDeserializedHeaders()).getOperationLocation()))), form, finalRecognizeContentOptions.getContentType()), this.pollingOperation(resultId -> this.service.getAnalyzeLayoutResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.service.getAnalyzeLayoutResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedLayout(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), true)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceiptsFromUrl(String receiptUrl) {
        return this.beginRecognizeReceiptsFromUrl(receiptUrl, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceiptsFromUrl(String receiptUrl, RecognizeReceiptsOptions recognizeReceiptsOptions) {
        return this.beginRecognizeReceiptsFromUrl(receiptUrl, recognizeReceiptsOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceiptsFromUrl(String receiptUrl, RecognizeReceiptsOptions recognizeReceiptsOptions, Context context) {
        try {
            Objects.requireNonNull(receiptUrl, "'receiptUrl' is required and cannot be null.");
            RecognizeReceiptsOptions finalRecognizeReceiptsOptions = FormRecognizerAsyncClient.getRecognizeReceiptOptions(recognizeReceiptsOptions);
            boolean isFieldElementsIncluded = finalRecognizeReceiptsOptions.isFieldElementsIncluded();
            FormRecognizerLocale localeInfo = finalRecognizeReceiptsOptions.getLocale();
            return new PollerFlux(finalRecognizeReceiptsOptions.getPollInterval(), Utility.urlActivationOperation(() -> this.service.analyzeReceiptAsyncWithResponseAsync(isFieldElementsIncluded, localeInfo == null ? null : Locale.fromString(localeInfo.toString()), finalRecognizeReceiptsOptions.getPages(), new SourcePath().setSource(receiptUrl), context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzeReceiptAsyncHeaders)response.getDeserializedHeaders()).getOperationLocation()))), this.logger), this.pollingOperation(resultId -> this.service.getAnalyzeReceiptResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.service.getAnalyzeReceiptResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, null)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceipts(Flux<ByteBuffer> receipt, long length) {
        return this.beginRecognizeReceipts(receipt, length, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceipts(Flux<ByteBuffer> receipt, long length, RecognizeReceiptsOptions recognizeReceiptsOptions) {
        return this.beginRecognizeReceipts(receipt, length, recognizeReceiptsOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeReceipts(Flux<ByteBuffer> receipt, long length, RecognizeReceiptsOptions recognizeReceiptsOptions, Context context) {
        try {
            Objects.requireNonNull(receipt, "'receipt' is required and cannot be null.");
            RecognizeReceiptsOptions finalRecognizeReceiptsOptions = FormRecognizerAsyncClient.getRecognizeReceiptOptions(recognizeReceiptsOptions);
            boolean isFieldElementsIncluded = finalRecognizeReceiptsOptions.isFieldElementsIncluded();
            FormRecognizerLocale localeInfo = finalRecognizeReceiptsOptions.getLocale();
            return new PollerFlux(finalRecognizeReceiptsOptions.getPollInterval(), this.streamActivationOperation(contentType -> this.service.analyzeReceiptAsyncWithResponseAsync((ContentType)((Object)contentType), isFieldElementsIncluded, localeInfo == null ? null : Locale.fromString(localeInfo.toString()), finalRecognizeReceiptsOptions.getPages(), receipt, length, context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzeReceiptAsyncHeaders)response.getDeserializedHeaders()).getOperationLocation()))), receipt, finalRecognizeReceiptsOptions.getContentType()), this.pollingOperation(resultId -> this.service.getAnalyzeReceiptResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.service.getAnalyzeReceiptResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, null)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCardsFromUrl(String businessCardUrl) {
        return this.beginRecognizeBusinessCardsFromUrl(businessCardUrl, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCardsFromUrl(String businessCardUrl, RecognizeBusinessCardsOptions recognizeBusinessCardsOptions) {
        return this.beginRecognizeBusinessCardsFromUrl(businessCardUrl, recognizeBusinessCardsOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCardsFromUrl(String businessCardUrl, RecognizeBusinessCardsOptions recognizeBusinessCardsOptions, Context context) {
        try {
            Objects.requireNonNull(businessCardUrl, "'businessCardUrl' is required and cannot be null.");
            RecognizeBusinessCardsOptions finalRecognizeBusinessCardsOptions = FormRecognizerAsyncClient.getRecognizeBusinessCardsOptions(recognizeBusinessCardsOptions);
            boolean isFieldElementsIncluded = finalRecognizeBusinessCardsOptions.isFieldElementsIncluded();
            FormRecognizerLocale localeInfo = finalRecognizeBusinessCardsOptions.getLocale();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, Utility.urlActivationOperation(() -> this.service.analyzeBusinessCardAsyncWithResponseAsync(isFieldElementsIncluded, localeInfo == null ? null : Locale.fromString(localeInfo.toString()), finalRecognizeBusinessCardsOptions.getPages(), new SourcePath().setSource(businessCardUrl), context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzeBusinessCardAsyncHeaders)response.getDeserializedHeaders()).getOperationLocation()))), this.logger), this.pollingOperation(resultId -> this.service.getAnalyzeBusinessCardResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.service.getAnalyzeBusinessCardResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, null)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCards(Flux<ByteBuffer> businessCard, long length) {
        return this.beginRecognizeBusinessCards(businessCard, length, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCards(Flux<ByteBuffer> businessCard, long length, RecognizeBusinessCardsOptions recognizeBusinessCardsOptions) {
        return this.beginRecognizeBusinessCards(businessCard, length, recognizeBusinessCardsOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeBusinessCards(Flux<ByteBuffer> businessCard, long length, RecognizeBusinessCardsOptions recognizeBusinessCardsOptions, Context context) {
        try {
            Objects.requireNonNull(businessCard, "'businessCard' is required and cannot be null.");
            RecognizeBusinessCardsOptions finalRecognizeBusinessCardsOptions = FormRecognizerAsyncClient.getRecognizeBusinessCardsOptions(recognizeBusinessCardsOptions);
            boolean isFieldElementsIncluded = finalRecognizeBusinessCardsOptions.isFieldElementsIncluded();
            FormRecognizerLocale localeInfo = finalRecognizeBusinessCardsOptions.getLocale();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.streamActivationOperation(contentType -> this.service.analyzeBusinessCardAsyncWithResponseAsync((ContentType)((Object)contentType), isFieldElementsIncluded, localeInfo == null ? null : Locale.fromString(localeInfo.toString()), finalRecognizeBusinessCardsOptions.getPages(), businessCard, length, context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzeBusinessCardAsyncHeaders)response.getDeserializedHeaders()).getOperationLocation()))), businessCard, finalRecognizeBusinessCardsOptions.getContentType()), this.pollingOperation(resultId -> this.service.getAnalyzeBusinessCardResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.service.getAnalyzeBusinessCardResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, null)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocumentsFromUrl(String identityDocumentUrl) {
        return this.beginRecognizeIdentityDocumentsFromUrl(identityDocumentUrl, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocumentsFromUrl(String identityDocumentUrl, RecognizeIdentityDocumentOptions recognizeIdentityDocumentOptions) {
        return this.beginRecognizeIdentityDocumentsFromUrl(identityDocumentUrl, recognizeIdentityDocumentOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocumentsFromUrl(String identityDocumentUrl, RecognizeIdentityDocumentOptions recognizeIdentityDocumentOptions, Context context) {
        try {
            Objects.requireNonNull(identityDocumentUrl, "'identityDocumentUrl' is required and cannot be null.");
            RecognizeIdentityDocumentOptions finalRecognizeIdentityDocumentOptions = FormRecognizerAsyncClient.getRecognizeIdentityDocumentOptions(recognizeIdentityDocumentOptions);
            boolean isFieldElementsIncluded = finalRecognizeIdentityDocumentOptions.isFieldElementsIncluded();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, Utility.urlActivationOperation(() -> this.service.analyzeIdDocumentAsyncWithResponseAsync(isFieldElementsIncluded, finalRecognizeIdentityDocumentOptions.getPages(), new SourcePath().setSource(identityDocumentUrl), context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzeIdDocumentAsyncHeaders)response.getDeserializedHeaders()).getOperationLocation()))), this.logger), this.pollingOperation(resultId -> this.service.getAnalyzeIdDocumentResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.service.getAnalyzeIdDocumentResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, null)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocuments(Flux<ByteBuffer> identityDocument, long length) {
        return this.beginRecognizeIdentityDocuments(identityDocument, length, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocuments(Flux<ByteBuffer> identityDocument, long length, RecognizeIdentityDocumentOptions recognizeIdentityDocumentOptions) {
        return this.beginRecognizeIdentityDocuments(identityDocument, length, recognizeIdentityDocumentOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeIdentityDocuments(Flux<ByteBuffer> identityDocument, long length, RecognizeIdentityDocumentOptions recognizeIdentityDocumentOptions, Context context) {
        try {
            Objects.requireNonNull(identityDocument, "'identityDocument' is required and cannot be null.");
            RecognizeIdentityDocumentOptions finalRecognizeIdentityDocumentOptions = FormRecognizerAsyncClient.getRecognizeIdentityDocumentOptions(recognizeIdentityDocumentOptions);
            boolean isFieldElementsIncluded = finalRecognizeIdentityDocumentOptions.isFieldElementsIncluded();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.streamActivationOperation(contentType -> this.service.analyzeIdDocumentAsyncWithResponseAsync((ContentType)((Object)contentType), isFieldElementsIncluded, finalRecognizeIdentityDocumentOptions.getPages(), identityDocument, length, context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzeIdDocumentAsyncHeaders)response.getDeserializedHeaders()).getOperationLocation()))), identityDocument, finalRecognizeIdentityDocumentOptions.getContentType()), this.pollingOperation(resultId -> this.service.getAnalyzeIdDocumentResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.service.getAnalyzeIdDocumentResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, null)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    private Function<PollingContext<FormRecognizerOperationResult>, Mono<FormRecognizerOperationResult>> streamActivationOperation(Function<ContentType, Mono<FormRecognizerOperationResult>> activationOperation, Flux<ByteBuffer> form, FormContentType contentType) {
        return pollingContext -> {
            try {
                Objects.requireNonNull(form, "'form' is required and cannot be null.");
                if (contentType != null) {
                    return ((Mono)activationOperation.apply(ContentType.fromString(contentType.toString()))).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
                }
                return Utility.detectContentType(form).flatMap(activationOperation::apply).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<FormRecognizerOperationResult>, Mono<PollResponse<FormRecognizerOperationResult>>> pollingOperation(Function<UUID, Mono<Response<AnalyzeOperationResult>>> pollingFunction) {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                UUID resultUuid = UUID.fromString(((FormRecognizerOperationResult)operationResultPollResponse.getValue()).getResultId());
                return ((Mono)pollingFunction.apply(resultUuid)).flatMap(modelResponse -> this.processAnalyzeModelResponse((Response<AnalyzeOperationResult>)modelResponse, (PollResponse<FormRecognizerOperationResult>)operationResultPollResponse)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<FormRecognizerOperationResult>, Mono<Response<AnalyzeOperationResult>>> fetchingOperation(Function<UUID, Mono<Response<AnalyzeOperationResult>>> fetchingFunction) {
        return pollingContext -> {
            try {
                UUID resultUuid = UUID.fromString(((FormRecognizerOperationResult)pollingContext.getLatestResponse().getValue()).getResultId());
                return (Mono)fetchingFunction.apply(resultUuid);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Mono<PollResponse<FormRecognizerOperationResult>> processAnalyzeModelResponse(Response<AnalyzeOperationResult> analyzeOperationResultResponse, PollResponse<FormRecognizerOperationResult> operationResultPollResponse) {
        LongRunningOperationStatus status;
        switch (((AnalyzeOperationResult)analyzeOperationResultResponse.getValue()).getStatus()) {
            case NOT_STARTED: 
            case RUNNING: {
                status = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case SUCCEEDED: {
                status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case FAILED: {
                throw this.logger.logExceptionAsError((RuntimeException)((Object)new FormRecognizerException("Analyze operation failed", ((AnalyzeOperationResult)analyzeOperationResultResponse.getValue()).getAnalyzeResult().getErrors().stream().map(errorInformation -> new FormRecognizerErrorInformation(errorInformation.getCode(), errorInformation.getMessage())).collect(Collectors.toList()))));
            }
            default: {
                status = LongRunningOperationStatus.fromString((String)((AnalyzeOperationResult)analyzeOperationResultResponse.getValue()).getStatus().toString(), (boolean)true);
            }
        }
        return Mono.just((Object)new PollResponse(status, (Object)((FormRecognizerOperationResult)operationResultPollResponse.getValue())));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoicesFromUrl(String invoiceUrl) {
        return this.beginRecognizeInvoicesFromUrl(invoiceUrl, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoicesFromUrl(String invoiceUrl, RecognizeInvoicesOptions recognizeInvoicesOptions) {
        return this.beginRecognizeInvoicesFromUrl(invoiceUrl, recognizeInvoicesOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoicesFromUrl(String invoiceUrl, RecognizeInvoicesOptions recognizeInvoicesOptions, Context context) {
        try {
            Objects.requireNonNull(invoiceUrl, "'invoiceUrl' is required and cannot be null.");
            RecognizeInvoicesOptions finalRecognizeInvoicesOptions = FormRecognizerAsyncClient.getRecognizeInvoicesOptions(recognizeInvoicesOptions);
            boolean isFieldElementsIncluded = finalRecognizeInvoicesOptions.isFieldElementsIncluded();
            FormRecognizerLocale localeInfo = finalRecognizeInvoicesOptions.getLocale();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, Utility.urlActivationOperation(() -> this.service.analyzeInvoiceAsyncWithResponseAsync(isFieldElementsIncluded, localeInfo == null ? null : Locale.fromString(localeInfo.toString()), finalRecognizeInvoicesOptions.getPages(), new SourcePath().setSource(invoiceUrl), context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzeInvoiceAsyncHeaders)response.getDeserializedHeaders()).getOperationLocation()))), this.logger), this.pollingOperation(resultId -> this.service.getAnalyzeInvoiceResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.service.getAnalyzeInvoiceResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, null)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoices(Flux<ByteBuffer> invoice, long length) {
        return this.beginRecognizeInvoices(invoice, length, null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoices(Flux<ByteBuffer> invoice, long length, RecognizeInvoicesOptions recognizeInvoicesOptions) {
        return this.beginRecognizeInvoices(invoice, length, recognizeInvoicesOptions, Context.NONE);
    }

    PollerFlux<FormRecognizerOperationResult, List<RecognizedForm>> beginRecognizeInvoices(Flux<ByteBuffer> invoice, long length, RecognizeInvoicesOptions recognizeInvoicesOptions, Context context) {
        try {
            Objects.requireNonNull(invoice, "'invoice' is required and cannot be null.");
            RecognizeInvoicesOptions finalRecognizeInvoicesOptions = FormRecognizerAsyncClient.getRecognizeInvoicesOptions(recognizeInvoicesOptions);
            boolean isFieldElementsIncluded = finalRecognizeInvoicesOptions.isFieldElementsIncluded();
            FormRecognizerLocale localeInfo = finalRecognizeInvoicesOptions.getLocale();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.streamActivationOperation(contentType -> this.service.analyzeInvoiceAsyncWithResponseAsync((ContentType)((Object)contentType), isFieldElementsIncluded, localeInfo == null ? null : Locale.fromString(localeInfo.toString()), finalRecognizeInvoicesOptions.getPages(), invoice, length, context).map(response -> new FormRecognizerOperationResult(Utility.parseModelId(((AnalyzeInvoiceAsyncHeaders)response.getDeserializedHeaders()).getOperationLocation()))), invoice, finalRecognizeInvoicesOptions.getContentType()), this.pollingOperation(resultId -> this.service.getAnalyzeInvoiceResultWithResponseAsync((UUID)resultId, context)), (activationResponse, pollingContext) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchingOperation(resultId -> this.service.getAnalyzeInvoiceResultWithResponseAsync((UUID)resultId, context)).andThen(after -> after.map(modelSimpleResponse -> Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), isFieldElementsIncluded, null)).onErrorMap(Utility::mapToHttpResponseExceptionIfExists)));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    private static RecognizeCustomFormsOptions getRecognizeCustomFormOptions(RecognizeCustomFormsOptions userProvidedOptions) {
        return userProvidedOptions == null ? new RecognizeCustomFormsOptions() : userProvidedOptions;
    }

    private static RecognizeContentOptions getRecognizeContentOptions(RecognizeContentOptions userProvidedOptions) {
        return userProvidedOptions == null ? new RecognizeContentOptions() : userProvidedOptions;
    }

    private static RecognizeReceiptsOptions getRecognizeReceiptOptions(RecognizeReceiptsOptions userProvidedOptions) {
        return userProvidedOptions == null ? new RecognizeReceiptsOptions() : userProvidedOptions;
    }

    private static RecognizeBusinessCardsOptions getRecognizeBusinessCardsOptions(RecognizeBusinessCardsOptions userProvidedOptions) {
        return userProvidedOptions == null ? new RecognizeBusinessCardsOptions() : userProvidedOptions;
    }

    private static RecognizeInvoicesOptions getRecognizeInvoicesOptions(RecognizeInvoicesOptions userProvidedOptions) {
        return userProvidedOptions == null ? new RecognizeInvoicesOptions() : userProvidedOptions;
    }

    private static RecognizeIdentityDocumentOptions getRecognizeIdentityDocumentOptions(RecognizeIdentityDocumentOptions userProvidedOptions) {
        return userProvidedOptions == null ? new RecognizeIdentityDocumentOptions() : userProvidedOptions;
    }
}

