// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Document splitting mode.
 */
public final class SplitMode extends ExpandableStringEnum<SplitMode> {

    /**
     * Automatically split file into documents.
     */
    @Generated
    public static final SplitMode AUTO = fromString("auto");

    /**
     * Treat the entire file as a single document.
     */
    @Generated
    public static final SplitMode NONE = fromString("none");

    /**
     * Treat each page in the file as a separate document.
     */
    @Generated
    public static final SplitMode PER_PAGE = fromString("perPage");

    /**
     * Creates a new instance of SplitMode value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public SplitMode() {
    }

    /**
     * Creates or finds a SplitMode from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding SplitMode.
     */
    @Generated
    public static SplitMode fromString(String name) {
        return fromString(name, SplitMode.class);
    }

    /**
     * Gets known SplitMode values.
     *
     * @return known SplitMode values.
     */
    @Generated
    public static Collection<SplitMode> values() {
        return values(SplitMode.class);
    }
}
