// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Type of operation.
 */
public final class OperationKind extends ExpandableStringEnum<OperationKind> {

    /**
     * Build a new custom document model.
     */
    @Generated
    public static final OperationKind DOCUMENT_MODEL_BUILD = fromString("documentModelBuild");

    /**
     * Compose a new custom document model from existing models.
     */
    @Generated
    public static final OperationKind DOCUMENT_MODEL_COMPOSE = fromString("documentModelCompose");

    /**
     * Copy an existing document model to potentially a different resource, region, or
     * subscription.
     */
    @Generated
    public static final OperationKind DOCUMENT_MODEL_COPY_TO = fromString("documentModelCopyTo");

    /**
     * Copy an existing document classifier to potentially a different resource, region, or
     * subscription.
     */
    @Generated
    public static final OperationKind DOCUMENT_CLASSIFIER_COPY_TO = fromString("documentClassifierCopyTo");

    /**
     * Build a new custom classifier model.
     */
    @Generated
    public static final OperationKind DOCUMENT_CLASSIFIER_BUILD = fromString("documentClassifierBuild");

    /**
     * Creates a new instance of OperationKind value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public OperationKind() {
    }

    /**
     * Creates or finds a OperationKind from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding OperationKind.
     */
    @Generated
    public static OperationKind fromString(String name) {
        return fromString(name, OperationKind.class);
    }

    /**
     * Gets known OperationKind values.
     *
     * @return known OperationKind values.
     */
    @Generated
    public static Collection<OperationKind> values() {
        return values(OperationKind.class);
    }
}
