// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A selection mark object representing check boxes, radio buttons, and other
 * elements indicating a selection.
 */
@Immutable
public final class DocumentSelectionMark implements JsonSerializable<DocumentSelectionMark> {

    /*
     * State of the selection mark.
     */
    @Generated
    private final DocumentSelectionMarkState state;

    /*
     * Bounding polygon of the selection mark, with coordinates specified relative
     * to the top-left of the page. The numbers represent the x, y values of the
     * polygon vertices, clockwise from the left (-180 degrees inclusive) relative
     * to the element orientation.
     */
    @Generated
    private List<Double> polygon;

    /*
     * Location of the selection mark in the reading order concatenated content.
     */
    @Generated
    private final DocumentSpan span;

    /*
     * Confidence of correctly extracting the selection mark.
     */
    @Generated
    private final double confidence;

    /**
     * Creates an instance of DocumentSelectionMark class.
     *
     * @param state the state value to set.
     * @param span the span value to set.
     * @param confidence the confidence value to set.
     */
    @Generated
    private DocumentSelectionMark(DocumentSelectionMarkState state, DocumentSpan span, double confidence) {
        this.state = state;
        this.span = span;
        this.confidence = confidence;
    }

    /**
     * Get the state property: State of the selection mark.
     *
     * @return the state value.
     */
    @Generated
    public DocumentSelectionMarkState getState() {
        return this.state;
    }

    /**
     * Get the polygon property: Bounding polygon of the selection mark, with coordinates specified relative
     * to the top-left of the page. The numbers represent the x, y values of the
     * polygon vertices, clockwise from the left (-180 degrees inclusive) relative
     * to the element orientation.
     *
     * @return the polygon value.
     */
    @Generated
    public List<Double> getPolygon() {
        return this.polygon;
    }

    /**
     * Get the span property: Location of the selection mark in the reading order concatenated content.
     *
     * @return the span value.
     */
    @Generated
    public DocumentSpan getSpan() {
        return this.span;
    }

    /**
     * Get the confidence property: Confidence of correctly extracting the selection mark.
     *
     * @return the confidence value.
     */
    @Generated
    public double getConfidence() {
        return this.confidence;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeJsonField("span", this.span);
        jsonWriter.writeDoubleField("confidence", this.confidence);
        jsonWriter.writeArrayField("polygon", this.polygon, (writer, element) -> writer.writeDouble(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentSelectionMark from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentSelectionMark if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentSelectionMark.
     */
    @Generated
    public static DocumentSelectionMark fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DocumentSelectionMarkState state = null;
            DocumentSpan span = null;
            double confidence = 0.0;
            List<Double> polygon = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    state = DocumentSelectionMarkState.fromString(reader.getString());
                } else if ("span".equals(fieldName)) {
                    span = DocumentSpan.fromJson(reader);
                } else if ("confidence".equals(fieldName)) {
                    confidence = reader.getDouble();
                } else if ("polygon".equals(fieldName)) {
                    polygon = reader.readArray(reader1 -> reader1.getDouble());
                } else {
                    reader.skipChildren();
                }
            }
            DocumentSelectionMark deserializedDocumentSelectionMark
                = new DocumentSelectionMark(state, span, confidence);
            deserializedDocumentSelectionMark.polygon = polygon;
            return deserializedDocumentSelectionMark;
        });
    }
}
