// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A content line object consisting of an adjacent sequence of content elements,
 * such as words and selection marks.
 */
@Immutable
public final class DocumentLine implements JsonSerializable<DocumentLine> {

    /*
     * Concatenated content of the contained elements in reading order.
     */
    @Generated
    private final String content;

    /*
     * Bounding polygon of the line, with coordinates specified relative to the
     * top-left of the page. The numbers represent the x, y values of the polygon
     * vertices, clockwise from the left (-180 degrees inclusive) relative to the
     * element orientation.
     */
    @Generated
    private List<Double> polygon;

    /*
     * Location of the line in the reading order concatenated content.
     */
    @Generated
    private final List<DocumentSpan> spans;

    /**
     * Creates an instance of DocumentLine class.
     *
     * @param content the content value to set.
     * @param spans the spans value to set.
     */
    @Generated
    private DocumentLine(String content, List<DocumentSpan> spans) {
        this.content = content;
        this.spans = spans;
    }

    /**
     * Get the content property: Concatenated content of the contained elements in reading order.
     *
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Get the polygon property: Bounding polygon of the line, with coordinates specified relative to the
     * top-left of the page. The numbers represent the x, y values of the polygon
     * vertices, clockwise from the left (-180 degrees inclusive) relative to the
     * element orientation.
     *
     * @return the polygon value.
     */
    @Generated
    public List<Double> getPolygon() {
        return this.polygon;
    }

    /**
     * Get the spans property: Location of the line in the reading order concatenated content.
     *
     * @return the spans value.
     */
    @Generated
    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("polygon", this.polygon, (writer, element) -> writer.writeDouble(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentLine from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentLine if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentLine.
     */
    @Generated
    public static DocumentLine fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String content = null;
            List<DocumentSpan> spans = null;
            List<Double> polygon = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                } else if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                } else if ("polygon".equals(fieldName)) {
                    polygon = reader.readArray(reader1 -> reader1.getDouble());
                } else {
                    reader.skipChildren();
                }
            }
            DocumentLine deserializedDocumentLine = new DocumentLine(content, spans);
            deserializedDocumentLine.polygon = polygon;
            return deserializedDocumentLine;
        });
    }
}
