// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Font weight.
 */
public final class DocumentFontWeight extends ExpandableStringEnum<DocumentFontWeight> {

    /**
     * Characters are represented normally.
     */
    @Generated
    public static final DocumentFontWeight NORMAL = fromString("normal");

    /**
     * Characters are represented with thicker strokes.
     */
    @Generated
    public static final DocumentFontWeight BOLD = fromString("bold");

    /**
     * Creates a new instance of DocumentFontWeight value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public DocumentFontWeight() {
    }

    /**
     * Creates or finds a DocumentFontWeight from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding DocumentFontWeight.
     */
    @Generated
    public static DocumentFontWeight fromString(String name) {
        return fromString(name, DocumentFontWeight.class);
    }

    /**
     * Gets known DocumentFontWeight values.
     *
     * @return known DocumentFontWeight values.
     */
    @Generated
    public static Collection<DocumentFontWeight> values() {
        return values(DocumentFontWeight.class);
    }
}
