// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * An object representing the content and location of a field value.
 */
@Immutable
public final class DocumentField implements JsonSerializable<DocumentField> {

    /*
     * Data type of the field value.
     */
    @Generated
    private final DocumentFieldType type;

    /*
     * String value.
     */
    @Generated
    private String valueString;

    /*
     * Date value in YYYY-MM-DD format (ISO 8601).
     */
    @Generated
    private LocalDate valueDate;

    /*
     * Time value in hh:mm:ss format (ISO 8601).
     */
    @Generated
    private String valueTime;

    /*
     * Phone number value in E.164 format (ex. +19876543210).
     */
    @Generated
    private String valuePhoneNumber;

    /*
     * Floating point value.
     */
    @Generated
    private Double valueNumber;

    /*
     * Integer value.
     */
    @Generated
    private Long valueInteger;

    /*
     * Selection mark value.
     */
    @Generated
    private DocumentSelectionMarkState valueSelectionMark;

    /*
     * Presence of signature.
     */
    @Generated
    private DocumentSignatureType valueSignature;

    /*
     * 3-letter country code value (ISO 3166-1 alpha-3).
     */
    @Generated
    private String valueCountryRegion;

    /*
     * Currency value.
     */
    @Generated
    private CurrencyValue valueCurrency;

    /*
     * Address value.
     */
    @Generated
    private AddressValue valueAddress;

    /*
     * Boolean value.
     */
    @Generated
    private Boolean valueBoolean;

    /*
     * Selection group value.
     */
    @Generated
    private List<String> valueSelectionGroup;

    /*
     * Field content.
     */
    @Generated
    private String content;

    /*
     * Bounding regions covering the field.
     */
    @Generated
    private List<BoundingRegion> boundingRegions;

    /*
     * Location of the field in the reading order concatenated content.
     */
    @Generated
    private List<DocumentSpan> spans;

    /*
     * Confidence of correctly extracting the field.
     */
    @Generated
    private Double confidence;

    /**
     * Creates an instance of DocumentField class.
     *
     * @param type the type value to set.
     */
    @Generated
    private DocumentField(DocumentFieldType type) {
        this.type = type;
    }

    /**
     * Get the type property: Data type of the field value.
     *
     * @return the type value.
     */
    @Generated
    public DocumentFieldType getType() {
        return this.type;
    }

    /**
     * Get the valueString property: String value.
     *
     * @return the valueString value.
     */
    @Generated
    public String getValueString() {
        return this.valueString;
    }

    /**
     * Get the valueDate property: Date value in YYYY-MM-DD format (ISO 8601).
     *
     * @return the valueDate value.
     */
    @Generated
    public LocalDate getValueDate() {
        return this.valueDate;
    }

    /**
     * Get the valueTime property: Time value in hh:mm:ss format (ISO 8601).
     *
     * @return the valueTime value.
     */
    @Generated
    public String getValueTime() {
        return this.valueTime;
    }

    /**
     * Get the valuePhoneNumber property: Phone number value in E.164 format (ex. +19876543210).
     *
     * @return the valuePhoneNumber value.
     */
    @Generated
    public String getValuePhoneNumber() {
        return this.valuePhoneNumber;
    }

    /**
     * Get the valueNumber property: Floating point value.
     *
     * @return the valueNumber value.
     */
    @Generated
    public Double getValueNumber() {
        return this.valueNumber;
    }

    /**
     * Get the valueInteger property: Integer value.
     *
     * @return the valueInteger value.
     */
    @Generated
    public Long getValueInteger() {
        return this.valueInteger;
    }

    /**
     * Get the valueSelectionMark property: Selection mark value.
     *
     * @return the valueSelectionMark value.
     */
    @Generated
    public DocumentSelectionMarkState getValueSelectionMark() {
        return this.valueSelectionMark;
    }

    /**
     * Get the valueSignature property: Presence of signature.
     *
     * @return the valueSignature value.
     */
    @Generated
    public DocumentSignatureType getValueSignature() {
        return this.valueSignature;
    }

    /**
     * Get the valueCountryRegion property: 3-letter country code value (ISO 3166-1 alpha-3).
     *
     * @return the valueCountryRegion value.
     */
    @Generated
    public String getValueCountryRegion() {
        return this.valueCountryRegion;
    }

    /**
     * Get the valueCurrency property: Currency value.
     *
     * @return the valueCurrency value.
     */
    @Generated
    public CurrencyValue getValueCurrency() {
        return this.valueCurrency;
    }

    /**
     * Get the valueAddress property: Address value.
     *
     * @return the valueAddress value.
     */
    @Generated
    public AddressValue getValueAddress() {
        return this.valueAddress;
    }

    /**
     * Get the valueBoolean property: Boolean value.
     *
     * @return the valueBoolean value.
     */
    @Generated
    public Boolean isValueBoolean() {
        return this.valueBoolean;
    }

    /**
     * Get the valueSelectionGroup property: Selection group value.
     *
     * @return the valueSelectionGroup value.
     */
    @Generated
    public List<String> getValueSelectionGroup() {
        return this.valueSelectionGroup;
    }

    /**
     * Get the content property: Field content.
     *
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Get the boundingRegions property: Bounding regions covering the field.
     *
     * @return the boundingRegions value.
     */
    @Generated
    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    /**
     * Get the spans property: Location of the field in the reading order concatenated content.
     *
     * @return the spans value.
     */
    @Generated
    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    /**
     * Get the confidence property: Confidence of correctly extracting the field.
     *
     * @return the confidence value.
     */
    @Generated
    public Double getConfidence() {
        return this.confidence;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("valueString", this.valueString);
        jsonWriter.writeStringField("valueDate", Objects.toString(this.valueDate, null));
        jsonWriter.writeStringField("valueTime", this.valueTime);
        jsonWriter.writeStringField("valuePhoneNumber", this.valuePhoneNumber);
        jsonWriter.writeNumberField("valueNumber", this.valueNumber);
        jsonWriter.writeNumberField("valueInteger", this.valueInteger);
        jsonWriter.writeStringField("valueSelectionMark",
            this.valueSelectionMark == null ? null : this.valueSelectionMark.toString());
        jsonWriter.writeStringField("valueSignature",
            this.valueSignature == null ? null : this.valueSignature.toString());
        jsonWriter.writeStringField("valueCountryRegion", this.valueCountryRegion);
        jsonWriter.writeArrayField("valueArray", this.valueList, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeMapField("valueObject", this.valueMap, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("valueCurrency", this.valueCurrency);
        jsonWriter.writeJsonField("valueAddress", this.valueAddress);
        jsonWriter.writeBooleanField("valueBoolean", this.valueBoolean);
        jsonWriter.writeArrayField("valueSelectionGroup", this.valueSelectionGroup,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("boundingRegions", this.boundingRegions,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeNumberField("confidence", this.confidence);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentField from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentField if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentField.
     */
    @Generated
    public static DocumentField fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DocumentFieldType type = null;
            String valueString = null;
            LocalDate valueDate = null;
            String valueTime = null;
            String valuePhoneNumber = null;
            Double valueNumber = null;
            Long valueInteger = null;
            DocumentSelectionMarkState valueSelectionMark = null;
            DocumentSignatureType valueSignature = null;
            String valueCountryRegion = null;
            List<DocumentField> valueList = null;
            Map<String, DocumentField> valueMap = null;
            CurrencyValue valueCurrency = null;
            AddressValue valueAddress = null;
            Boolean valueBoolean = null;
            List<String> valueSelectionGroup = null;
            String content = null;
            List<BoundingRegion> boundingRegions = null;
            List<DocumentSpan> spans = null;
            Double confidence = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    type = DocumentFieldType.fromString(reader.getString());
                } else if ("valueString".equals(fieldName)) {
                    valueString = reader.getString();
                } else if ("valueDate".equals(fieldName)) {
                    valueDate = reader.getNullable(nonNullReader -> LocalDate.parse(nonNullReader.getString()));
                } else if ("valueTime".equals(fieldName)) {
                    valueTime = reader.getString();
                } else if ("valuePhoneNumber".equals(fieldName)) {
                    valuePhoneNumber = reader.getString();
                } else if ("valueNumber".equals(fieldName)) {
                    valueNumber = reader.getNullable(JsonReader::getDouble);
                } else if ("valueInteger".equals(fieldName)) {
                    valueInteger = reader.getNullable(JsonReader::getLong);
                } else if ("valueSelectionMark".equals(fieldName)) {
                    valueSelectionMark = DocumentSelectionMarkState.fromString(reader.getString());
                } else if ("valueSignature".equals(fieldName)) {
                    valueSignature = DocumentSignatureType.fromString(reader.getString());
                } else if ("valueCountryRegion".equals(fieldName)) {
                    valueCountryRegion = reader.getString();
                } else if ("valueArray".equals(fieldName)) {
                    valueList = reader.readArray(reader1 -> DocumentField.fromJson(reader1));
                } else if ("valueObject".equals(fieldName)) {
                    valueMap = reader.readMap(reader1 -> DocumentField.fromJson(reader1));
                } else if ("valueCurrency".equals(fieldName)) {
                    valueCurrency = CurrencyValue.fromJson(reader);
                } else if ("valueAddress".equals(fieldName)) {
                    valueAddress = AddressValue.fromJson(reader);
                } else if ("valueBoolean".equals(fieldName)) {
                    valueBoolean = reader.getNullable(JsonReader::getBoolean);
                } else if ("valueSelectionGroup".equals(fieldName)) {
                    valueSelectionGroup = reader.readArray(reader1 -> reader1.getString());
                } else if ("content".equals(fieldName)) {
                    content = reader.getString();
                } else if ("boundingRegions".equals(fieldName)) {
                    boundingRegions = reader.readArray(reader1 -> BoundingRegion.fromJson(reader1));
                } else if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                } else if ("confidence".equals(fieldName)) {
                    confidence = reader.getNullable(JsonReader::getDouble);
                } else {
                    reader.skipChildren();
                }
            }
            DocumentField deserializedDocumentField = new DocumentField(type);
            deserializedDocumentField.valueString = valueString;
            deserializedDocumentField.valueDate = valueDate;
            deserializedDocumentField.valueTime = valueTime;
            deserializedDocumentField.valuePhoneNumber = valuePhoneNumber;
            deserializedDocumentField.valueNumber = valueNumber;
            deserializedDocumentField.valueInteger = valueInteger;
            deserializedDocumentField.valueSelectionMark = valueSelectionMark;
            deserializedDocumentField.valueSignature = valueSignature;
            deserializedDocumentField.valueCountryRegion = valueCountryRegion;
            deserializedDocumentField.valueList = valueList;
            deserializedDocumentField.valueMap = valueMap;
            deserializedDocumentField.valueCurrency = valueCurrency;
            deserializedDocumentField.valueAddress = valueAddress;
            deserializedDocumentField.valueBoolean = valueBoolean;
            deserializedDocumentField.valueSelectionGroup = valueSelectionGroup;
            deserializedDocumentField.content = content;
            deserializedDocumentField.boundingRegions = boundingRegions;
            deserializedDocumentField.spans = spans;
            deserializedDocumentField.confidence = confidence;
            return deserializedDocumentField;
        });
    }

    /*
     * Array of field values.
     */
    @Generated
    private List<DocumentField> valueList;

    /*
     * Dictionary of named field values.
     */
    @Generated
    private Map<String, DocumentField> valueMap;

    /**
     * Get the valueList property: Array of field values.
     *
     * @return the valueList value.
     */
    @Generated
    public List<DocumentField> getValueList() {
        return this.valueList;
    }

    /**
     * Get the valueMap property: Dictionary of named field values.
     *
     * @return the valueMap value.
     */
    @Generated
    public Map<String, DocumentField> getValueMap() {
        return this.valueMap;
    }
}
