// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Request body to build a new custom document model.
 */
@Fluent
public final class BuildDocumentModelOptions implements JsonSerializable<BuildDocumentModelOptions> {

    /*
     * Unique document model name.
     */
    @Generated
    private final String modelId;

    /*
     * Document model description.
     */
    @Generated
    private String description;

    /*
     * Custom document model build mode.
     */
    @Generated
    private final DocumentBuildMode buildMode;

    /*
     * Azure Blob Storage location containing the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     */
    @Generated
    private AzureBlobContentSource azureBlobSource;

    /*
     * Azure Blob Storage file list specifying the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     */
    @Generated
    private AzureBlobFileListContentSource azureBlobFileListSource;

    /*
     * List of key-value tag attributes associated with the document model.
     */
    @Generated
    private Map<String, String> tags;

    /*
     * Max number of V100-equivalent GPU hours to use for model training. Default=0.5.
     */
    @Generated
    private Double maxTrainingHours;

    /*
     * Allow overwriting an existing model with the same name.
     */
    @Generated
    private Boolean allowOverwrite;

    /**
     * Creates an instance of BuildDocumentModelOptions class.
     *
     * @param modelId the modelId value to set.
     * @param buildMode the buildMode value to set.
     */
    @Generated
    public BuildDocumentModelOptions(String modelId, DocumentBuildMode buildMode) {
        this.modelId = modelId;
        this.buildMode = buildMode;
    }

    /**
     * Get the modelId property: Unique document model name.
     *
     * @return the modelId value.
     */
    @Generated
    public String getModelId() {
        return this.modelId;
    }

    /**
     * Get the description property: Document model description.
     *
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: Document model description.
     *
     * @param description the description value to set.
     * @return the BuildDocumentModelOptions object itself.
     */
    @Generated
    public BuildDocumentModelOptions setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the buildMode property: Custom document model build mode.
     *
     * @return the buildMode value.
     */
    @Generated
    public DocumentBuildMode getBuildMode() {
        return this.buildMode;
    }

    /**
     * Get the azureBlobSource property: Azure Blob Storage location containing the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     *
     * @return the azureBlobSource value.
     */
    @Generated
    public AzureBlobContentSource getAzureBlobSource() {
        return this.azureBlobSource;
    }

    /**
     * Set the azureBlobSource property: Azure Blob Storage location containing the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     *
     * @param azureBlobSource the azureBlobSource value to set.
     * @return the BuildDocumentModelOptions object itself.
     */
    @Generated
    public BuildDocumentModelOptions setAzureBlobSource(AzureBlobContentSource azureBlobSource) {
        this.azureBlobSource = azureBlobSource;
        return this;
    }

    /**
     * Get the azureBlobFileListSource property: Azure Blob Storage file list specifying the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     *
     * @return the azureBlobFileListSource value.
     */
    @Generated
    public AzureBlobFileListContentSource getAzureBlobFileListSource() {
        return this.azureBlobFileListSource;
    }

    /**
     * Set the azureBlobFileListSource property: Azure Blob Storage file list specifying the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     *
     * @param azureBlobFileListSource the azureBlobFileListSource value to set.
     * @return the BuildDocumentModelOptions object itself.
     */
    @Generated
    public BuildDocumentModelOptions
        setAzureBlobFileListSource(AzureBlobFileListContentSource azureBlobFileListSource) {
        this.azureBlobFileListSource = azureBlobFileListSource;
        return this;
    }

    /**
     * Get the tags property: List of key-value tag attributes associated with the document model.
     *
     * @return the tags value.
     */
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: List of key-value tag attributes associated with the document model.
     *
     * @param tags the tags value to set.
     * @return the BuildDocumentModelOptions object itself.
     */
    @Generated
    public BuildDocumentModelOptions setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the maxTrainingHours property: Max number of V100-equivalent GPU hours to use for model training.
     * Default=0.5.
     *
     * @return the maxTrainingHours value.
     */
    @Generated
    public Double getMaxTrainingHours() {
        return this.maxTrainingHours;
    }

    /**
     * Set the maxTrainingHours property: Max number of V100-equivalent GPU hours to use for model training.
     * Default=0.5.
     *
     * @param maxTrainingHours the maxTrainingHours value to set.
     * @return the BuildDocumentModelOptions object itself.
     */
    @Generated
    public BuildDocumentModelOptions setMaxTrainingHours(Double maxTrainingHours) {
        this.maxTrainingHours = maxTrainingHours;
        return this;
    }

    /**
     * Get the allowOverwrite property: Allow overwriting an existing model with the same name.
     *
     * @return the allowOverwrite value.
     */
    @Generated
    public Boolean isAllowOverwrite() {
        return this.allowOverwrite;
    }

    /**
     * Set the allowOverwrite property: Allow overwriting an existing model with the same name.
     *
     * @param allowOverwrite the allowOverwrite value to set.
     * @return the BuildDocumentModelOptions object itself.
     */
    @Generated
    public BuildDocumentModelOptions setAllowOverwrite(Boolean allowOverwrite) {
        this.allowOverwrite = allowOverwrite;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("modelId", this.modelId);
        jsonWriter.writeStringField("buildMode", this.buildMode == null ? null : this.buildMode.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("azureBlobSource", this.azureBlobSource);
        jsonWriter.writeJsonField("azureBlobFileListSource", this.azureBlobFileListSource);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("maxTrainingHours", this.maxTrainingHours);
        jsonWriter.writeBooleanField("allowOverwrite", this.allowOverwrite);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BuildDocumentModelOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of BuildDocumentModelOptions if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BuildDocumentModelOptions.
     */
    @Generated
    public static BuildDocumentModelOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String modelId = null;
            DocumentBuildMode buildMode = null;
            String description = null;
            AzureBlobContentSource azureBlobSource = null;
            AzureBlobFileListContentSource azureBlobFileListSource = null;
            Map<String, String> tags = null;
            Double maxTrainingHours = null;
            Boolean allowOverwrite = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modelId".equals(fieldName)) {
                    modelId = reader.getString();
                } else if ("buildMode".equals(fieldName)) {
                    buildMode = DocumentBuildMode.fromString(reader.getString());
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("azureBlobSource".equals(fieldName)) {
                    azureBlobSource = AzureBlobContentSource.fromJson(reader);
                } else if ("azureBlobFileListSource".equals(fieldName)) {
                    azureBlobFileListSource = AzureBlobFileListContentSource.fromJson(reader);
                } else if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                } else if ("maxTrainingHours".equals(fieldName)) {
                    maxTrainingHours = reader.getNullable(JsonReader::getDouble);
                } else if ("allowOverwrite".equals(fieldName)) {
                    allowOverwrite = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }
            BuildDocumentModelOptions deserializedBuildDocumentModelOptions
                = new BuildDocumentModelOptions(modelId, buildMode);
            deserializedBuildDocumentModelOptions.description = description;
            deserializedBuildDocumentModelOptions.azureBlobSource = azureBlobSource;
            deserializedBuildDocumentModelOptions.azureBlobFileListSource = azureBlobFileListSource;
            deserializedBuildDocumentModelOptions.tags = tags;
            deserializedBuildDocumentModelOptions.maxTrainingHours = maxTrainingHours;
            deserializedBuildDocumentModelOptions.allowOverwrite = allowOverwrite;
            return deserializedBuildDocumentModelOptions;
        });
    }
}
