// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Azure Blob Storage content.
 */
@Fluent
public final class AzureBlobContentSource implements JsonSerializable<AzureBlobContentSource> {

    /*
     * Azure Blob Storage container URL.
     */
    @Generated
    private final String containerUrl;

    /*
     * Blob name prefix.
     */
    @Generated
    private String prefix;

    /**
     * Creates an instance of AzureBlobContentSource class.
     *
     * @param containerUrl the containerUrl value to set.
     */
    @Generated
    public AzureBlobContentSource(String containerUrl) {
        this.containerUrl = containerUrl;
    }

    /**
     * Get the containerUrl property: Azure Blob Storage container URL.
     *
     * @return the containerUrl value.
     */
    @Generated
    public String getContainerUrl() {
        return this.containerUrl;
    }

    /**
     * Get the prefix property: Blob name prefix.
     *
     * @return the prefix value.
     */
    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    /**
     * Set the prefix property: Blob name prefix.
     *
     * @param prefix the prefix value to set.
     * @return the AzureBlobContentSource object itself.
     */
    @Generated
    public AzureBlobContentSource setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("containerUrl", this.containerUrl);
        jsonWriter.writeStringField("prefix", this.prefix);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureBlobContentSource from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureBlobContentSource if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureBlobContentSource.
     */
    @Generated
    public static AzureBlobContentSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String containerUrl = null;
            String prefix = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("containerUrl".equals(fieldName)) {
                    containerUrl = reader.getString();
                } else if ("prefix".equals(fieldName)) {
                    prefix = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            AzureBlobContentSource deserializedAzureBlobContentSource = new AzureBlobContentSource(containerUrl);
            deserializedAzureBlobContentSource.prefix = prefix;
            return deserializedAzureBlobContentSource;
        });
    }
}
