// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Request body to authorize document model copy.
 */
@Fluent
public final class AuthorizeModelCopyOptions implements JsonSerializable<AuthorizeModelCopyOptions> {

    /*
     * Unique document model name.
     */
    @Generated
    private final String modelId;

    /*
     * Document model description.
     */
    @Generated
    private String description;

    /*
     * List of key-value tag attributes associated with the document model.
     */
    @Generated
    private Map<String, String> tags;

    /**
     * Creates an instance of AuthorizeModelCopyOptions class.
     *
     * @param modelId the modelId value to set.
     */
    @Generated
    public AuthorizeModelCopyOptions(String modelId) {
        this.modelId = modelId;
    }

    /**
     * Get the modelId property: Unique document model name.
     *
     * @return the modelId value.
     */
    @Generated
    public String getModelId() {
        return this.modelId;
    }

    /**
     * Get the description property: Document model description.
     *
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: Document model description.
     *
     * @param description the description value to set.
     * @return the AuthorizeModelCopyOptions object itself.
     */
    @Generated
    public AuthorizeModelCopyOptions setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the tags property: List of key-value tag attributes associated with the document model.
     *
     * @return the tags value.
     */
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: List of key-value tag attributes associated with the document model.
     *
     * @param tags the tags value to set.
     * @return the AuthorizeModelCopyOptions object itself.
     */
    @Generated
    public AuthorizeModelCopyOptions setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("modelId", this.modelId);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AuthorizeModelCopyOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AuthorizeModelCopyOptions if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AuthorizeModelCopyOptions.
     */
    @Generated
    public static AuthorizeModelCopyOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String modelId = null;
            String description = null;
            Map<String, String> tags = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modelId".equals(fieldName)) {
                    modelId = reader.getString();
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                } else {
                    reader.skipChildren();
                }
            }
            AuthorizeModelCopyOptions deserializedAuthorizeModelCopyOptions = new AuthorizeModelCopyOptions(modelId);
            deserializedAuthorizeModelCopyOptions.description = description;
            deserializedAuthorizeModelCopyOptions.tags = tags;
            return deserializedAuthorizeModelCopyOptions;
        });
    }
}
