// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Document analysis result.
 */
@Immutable
public final class AnalyzeResult implements JsonSerializable<AnalyzeResult> {

    /*
     * API version used to produce this result.
     */
    @Generated
    private final String apiVersion;

    /*
     * Document model ID used to produce this result.
     */
    @Generated
    private final String modelId;

    /*
     * Method used to compute string offset and length.
     */
    @Generated
    private final StringIndexType stringIndexType;

    /*
     * Format of the analyze result top-level content.
     */
    @Generated
    private DocumentContentFormat contentFormat;

    /*
     * Concatenate string representation of all textual and visual elements in reading
     * order.
     */
    @Generated
    private final String content;

    /*
     * Analyzed pages.
     */
    @Generated
    private final List<DocumentPage> pages;

    /*
     * Extracted paragraphs.
     */
    @Generated
    private List<DocumentParagraph> paragraphs;

    /*
     * Extracted tables.
     */
    @Generated
    private List<DocumentTable> tables;

    /*
     * Extracted figures.
     */
    @Generated
    private List<DocumentFigure> figures;

    /*
     * Extracted sections.
     */
    @Generated
    private List<DocumentSection> sections;

    /*
     * Extracted key-value pairs.
     */
    @Generated
    private List<DocumentKeyValuePair> keyValuePairs;

    /*
     * Extracted font styles.
     */
    @Generated
    private List<DocumentStyle> styles;

    /*
     * Detected languages.
     */
    @Generated
    private List<DocumentLanguage> languages;

    /*
     * Extracted documents.
     */
    @Generated
    private List<AnalyzedDocument> documents;

    /*
     * List of warnings encountered.
     */
    @Generated
    private List<DocumentIntelligenceWarning> warnings;

    /**
     * Creates an instance of AnalyzeResult class.
     *
     * @param apiVersion the apiVersion value to set.
     * @param modelId the modelId value to set.
     * @param stringIndexType the stringIndexType value to set.
     * @param content the content value to set.
     * @param pages the pages value to set.
     */
    @Generated
    private AnalyzeResult(String apiVersion, String modelId, StringIndexType stringIndexType, String content,
        List<DocumentPage> pages) {
        this.apiVersion = apiVersion;
        this.modelId = modelId;
        this.stringIndexType = stringIndexType;
        this.content = content;
        this.pages = pages;
    }

    /**
     * Get the apiVersion property: API version used to produce this result.
     *
     * @return the apiVersion value.
     */
    @Generated
    public String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * Get the modelId property: Document model ID used to produce this result.
     *
     * @return the modelId value.
     */
    @Generated
    public String getModelId() {
        return this.modelId;
    }

    /**
     * Get the stringIndexType property: Method used to compute string offset and length.
     *
     * @return the stringIndexType value.
     */
    @Generated
    public StringIndexType getStringIndexType() {
        return this.stringIndexType;
    }

    /**
     * Get the contentFormat property: Format of the analyze result top-level content.
     *
     * @return the contentFormat value.
     */
    @Generated
    public DocumentContentFormat getContentFormat() {
        return this.contentFormat;
    }

    /**
     * Get the content property: Concatenate string representation of all textual and visual elements in reading
     * order.
     *
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Get the pages property: Analyzed pages.
     *
     * @return the pages value.
     */
    @Generated
    public List<DocumentPage> getPages() {
        return this.pages;
    }

    /**
     * Get the paragraphs property: Extracted paragraphs.
     *
     * @return the paragraphs value.
     */
    @Generated
    public List<DocumentParagraph> getParagraphs() {
        return this.paragraphs;
    }

    /**
     * Get the tables property: Extracted tables.
     *
     * @return the tables value.
     */
    @Generated
    public List<DocumentTable> getTables() {
        return this.tables;
    }

    /**
     * Get the figures property: Extracted figures.
     *
     * @return the figures value.
     */
    @Generated
    public List<DocumentFigure> getFigures() {
        return this.figures;
    }

    /**
     * Get the sections property: Extracted sections.
     *
     * @return the sections value.
     */
    @Generated
    public List<DocumentSection> getSections() {
        return this.sections;
    }

    /**
     * Get the keyValuePairs property: Extracted key-value pairs.
     *
     * @return the keyValuePairs value.
     */
    @Generated
    public List<DocumentKeyValuePair> getKeyValuePairs() {
        return this.keyValuePairs;
    }

    /**
     * Get the styles property: Extracted font styles.
     *
     * @return the styles value.
     */
    @Generated
    public List<DocumentStyle> getStyles() {
        return this.styles;
    }

    /**
     * Get the languages property: Detected languages.
     *
     * @return the languages value.
     */
    @Generated
    public List<DocumentLanguage> getLanguages() {
        return this.languages;
    }

    /**
     * Get the documents property: Extracted documents.
     *
     * @return the documents value.
     */
    @Generated
    public List<AnalyzedDocument> getDocuments() {
        return this.documents;
    }

    /**
     * Get the warnings property: List of warnings encountered.
     *
     * @return the warnings value.
     */
    @Generated
    public List<DocumentIntelligenceWarning> getWarnings() {
        return this.warnings;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("apiVersion", this.apiVersion);
        jsonWriter.writeStringField("modelId", this.modelId);
        jsonWriter.writeStringField("stringIndexType",
            this.stringIndexType == null ? null : this.stringIndexType.toString());
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("pages", this.pages, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("contentFormat", this.contentFormat == null ? null : this.contentFormat.toString());
        jsonWriter.writeArrayField("paragraphs", this.paragraphs, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("tables", this.tables, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("figures", this.figures, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("sections", this.sections, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("keyValuePairs", this.keyValuePairs, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("styles", this.styles, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("languages", this.languages, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("documents", this.documents, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("warnings", this.warnings, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AnalyzeResult from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AnalyzeResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AnalyzeResult.
     */
    @Generated
    public static AnalyzeResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String apiVersion = null;
            String modelId = null;
            StringIndexType stringIndexType = null;
            String content = null;
            List<DocumentPage> pages = null;
            DocumentContentFormat contentFormat = null;
            List<DocumentParagraph> paragraphs = null;
            List<DocumentTable> tables = null;
            List<DocumentFigure> figures = null;
            List<DocumentSection> sections = null;
            List<DocumentKeyValuePair> keyValuePairs = null;
            List<DocumentStyle> styles = null;
            List<DocumentLanguage> languages = null;
            List<AnalyzedDocument> documents = null;
            List<DocumentIntelligenceWarning> warnings = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("apiVersion".equals(fieldName)) {
                    apiVersion = reader.getString();
                } else if ("modelId".equals(fieldName)) {
                    modelId = reader.getString();
                } else if ("stringIndexType".equals(fieldName)) {
                    stringIndexType = StringIndexType.fromString(reader.getString());
                } else if ("content".equals(fieldName)) {
                    content = reader.getString();
                } else if ("pages".equals(fieldName)) {
                    pages = reader.readArray(reader1 -> DocumentPage.fromJson(reader1));
                } else if ("contentFormat".equals(fieldName)) {
                    contentFormat = DocumentContentFormat.fromString(reader.getString());
                } else if ("paragraphs".equals(fieldName)) {
                    paragraphs = reader.readArray(reader1 -> DocumentParagraph.fromJson(reader1));
                } else if ("tables".equals(fieldName)) {
                    tables = reader.readArray(reader1 -> DocumentTable.fromJson(reader1));
                } else if ("figures".equals(fieldName)) {
                    figures = reader.readArray(reader1 -> DocumentFigure.fromJson(reader1));
                } else if ("sections".equals(fieldName)) {
                    sections = reader.readArray(reader1 -> DocumentSection.fromJson(reader1));
                } else if ("keyValuePairs".equals(fieldName)) {
                    keyValuePairs = reader.readArray(reader1 -> DocumentKeyValuePair.fromJson(reader1));
                } else if ("styles".equals(fieldName)) {
                    styles = reader.readArray(reader1 -> DocumentStyle.fromJson(reader1));
                } else if ("languages".equals(fieldName)) {
                    languages = reader.readArray(reader1 -> DocumentLanguage.fromJson(reader1));
                } else if ("documents".equals(fieldName)) {
                    documents = reader.readArray(reader1 -> AnalyzedDocument.fromJson(reader1));
                } else if ("warnings".equals(fieldName)) {
                    warnings = reader.readArray(reader1 -> DocumentIntelligenceWarning.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            AnalyzeResult deserializedAnalyzeResult
                = new AnalyzeResult(apiVersion, modelId, stringIndexType, content, pages);
            deserializedAnalyzeResult.contentFormat = contentFormat;
            deserializedAnalyzeResult.paragraphs = paragraphs;
            deserializedAnalyzeResult.tables = tables;
            deserializedAnalyzeResult.figures = figures;
            deserializedAnalyzeResult.sections = sections;
            deserializedAnalyzeResult.keyValuePairs = keyValuePairs;
            deserializedAnalyzeResult.styles = styles;
            deserializedAnalyzeResult.languages = languages;
            deserializedAnalyzeResult.documents = documents;
            deserializedAnalyzeResult.warnings = warnings;
            return deserializedAnalyzeResult;
        });
    }
}
