// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.implementation;

import com.azure.ai.documentintelligence.DocumentIntelligenceServiceVersion;
import com.azure.ai.documentintelligence.models.AnalyzeBatchOperationDetails;
import com.azure.ai.documentintelligence.models.AnalyzeBatchResult;
import com.azure.ai.documentintelligence.models.AnalyzeOperationDetails;
import com.azure.ai.documentintelligence.models.AnalyzeResult;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingStrategyOptions;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.TypeReference;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

/**
 * Initializes a new instance of the DocumentIntelligenceClient type.
 */
public final class DocumentIntelligenceClientImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final DocumentIntelligenceClientService service;

    /**
     * The Document Intelligence service endpoint.
     */
    private final String endpoint;

    /**
     * Gets The Document Intelligence service endpoint.
     * 
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Service version.
     */
    private final DocumentIntelligenceServiceVersion serviceVersion;

    /**
     * Gets Service version.
     * 
     * @return the serviceVersion value.
     */
    public DocumentIntelligenceServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    /**
     * The HTTP pipeline to send requests through.
     */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /**
     * The serializer to serialize an object into a string.
     */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     * 
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * Initializes an instance of DocumentIntelligenceClient client.
     * 
     * @param endpoint The Document Intelligence service endpoint.
     * @param serviceVersion Service version.
     */
    public DocumentIntelligenceClientImpl(String endpoint, DocumentIntelligenceServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build(),
            JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    /**
     * Initializes an instance of DocumentIntelligenceClient client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param endpoint The Document Intelligence service endpoint.
     * @param serviceVersion Service version.
     */
    public DocumentIntelligenceClientImpl(HttpPipeline httpPipeline, String endpoint,
        DocumentIntelligenceServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    /**
     * Initializes an instance of DocumentIntelligenceClient client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param endpoint The Document Intelligence service endpoint.
     * @param serviceVersion Service version.
     */
    public DocumentIntelligenceClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter,
        String endpoint, DocumentIntelligenceServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service
            = RestProxy.create(DocumentIntelligenceClientService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    /**
     * The interface defining all the services for DocumentIntelligenceClient to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{endpoint}/documentintelligence")
    @ServiceInterface(name = "DocumentIntelligence")
    public interface DocumentIntelligenceClientService {
        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> analyzeDocument(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @HeaderParam("content-type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData analyzeRequest, RequestOptions requestOptions, Context context);

        @Post("/documentModels/{modelId}:analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> analyzeDocumentSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @HeaderParam("content-type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData analyzeRequest, RequestOptions requestOptions, Context context);

        @Get("/documentModels/{modelId}/analyzeResults/{resultId}/pdf")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getAnalyzeResultPdf(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @PathParam("resultId") String resultId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Get("/documentModels/{modelId}/analyzeResults/{resultId}/pdf")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getAnalyzeResultPdfSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @PathParam("resultId") String resultId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Get("/documentModels/{modelId}/analyzeResults/{resultId}/figures/{figureId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getAnalyzeResultFigure(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @PathParam("resultId") String resultId, @PathParam("figureId") String figureId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/documentModels/{modelId}/analyzeResults/{resultId}/figures/{figureId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getAnalyzeResultFigureSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @PathParam("resultId") String resultId, @PathParam("figureId") String figureId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Delete("/documentModels/{modelId}/analyzeResults/{resultId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> deleteAnalyzeResult(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @PathParam("resultId") String resultId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Delete("/documentModels/{modelId}/analyzeResults/{resultId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> deleteAnalyzeResultSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @PathParam("resultId") String resultId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Post("/documentModels/{modelId}:analyzeBatch")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> analyzeBatchDocuments(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @HeaderParam("content-type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData analyzeBatchRequest, RequestOptions requestOptions,
            Context context);

        @Post("/documentModels/{modelId}:analyzeBatch")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> analyzeBatchDocumentsSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @HeaderParam("content-type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData analyzeBatchRequest, RequestOptions requestOptions,
            Context context);

        @Get("/documentModels/{modelId}/analyzeBatchResults")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listAnalyzeBatchResults(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/documentModels/{modelId}/analyzeBatchResults")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> listAnalyzeBatchResultsSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Delete("/documentModels/{modelId}/analyzeBatchResults/{resultId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> deleteAnalyzeBatchResult(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @PathParam("resultId") String resultId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Delete("/documentModels/{modelId}/analyzeBatchResults/{resultId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> deleteAnalyzeBatchResultSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @PathParam("resultId") String resultId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Get("/documentModels/{modelId}/analyzeBatchResults/{resultId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getAnalyzeBatchResult(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @PathParam("resultId") String resultId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Get("/documentModels/{modelId}/analyzeBatchResults/{resultId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getAnalyzeBatchResultSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @PathParam("resultId") String resultId, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Post("/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> classifyDocument(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("classifierId") String classifierId,
            @HeaderParam("content-type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData classifyRequest, RequestOptions requestOptions, Context context);

        @Post("/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> classifyDocumentSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("classifierId") String classifierId,
            @HeaderParam("content-type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData classifyRequest, RequestOptions requestOptions, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listAnalyzeBatchResultsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> listAnalyzeBatchResultsNextSync(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);
    }

    /**
     * Analyzes document with document model.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * <tr><td>locale</td><td>String</td><td>No</td><td>Locale hint for text recognition and document analysis. Value
     * may contain only
     * the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").</td></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>features</td><td>List&lt;String&gt;</td><td>No</td><td>List of optional analysis features. In the form of
     * "," separated string.</td></tr>
     * <tr><td>queryFields</td><td>List&lt;String&gt;</td><td>No</td><td>List of additional fields to extract. Ex.
     * "NumberOfGuests,StoreNumber". In the form of "," separated string.</td></tr>
     * <tr><td>outputContentFormat</td><td>String</td><td>No</td><td>Format of the analyze result top-level content.
     * Allowed values: "text", "markdown".</td></tr>
     * <tr><td>output</td><td>List&lt;String&gt;</td><td>No</td><td>Additional outputs to generate during analysis. In
     * the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     urlSource: String (Optional)
     *     base64Source: byte[] (Optional)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param analyzeRequest Analyze request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> analyzeDocumentWithResponseAsync(String modelId, BinaryData analyzeRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.analyzeDocument(this.getEndpoint(), this.getServiceVersion().getVersion(),
                modelId, contentType, accept, analyzeRequest, requestOptions, context));
    }

    /**
     * Analyzes document with document model.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * <tr><td>locale</td><td>String</td><td>No</td><td>Locale hint for text recognition and document analysis. Value
     * may contain only
     * the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").</td></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>features</td><td>List&lt;String&gt;</td><td>No</td><td>List of optional analysis features. In the form of
     * "," separated string.</td></tr>
     * <tr><td>queryFields</td><td>List&lt;String&gt;</td><td>No</td><td>List of additional fields to extract. Ex.
     * "NumberOfGuests,StoreNumber". In the form of "," separated string.</td></tr>
     * <tr><td>outputContentFormat</td><td>String</td><td>No</td><td>Format of the analyze result top-level content.
     * Allowed values: "text", "markdown".</td></tr>
     * <tr><td>output</td><td>List&lt;String&gt;</td><td>No</td><td>Additional outputs to generate during analysis. In
     * the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     urlSource: String (Optional)
     *     base64Source: byte[] (Optional)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param analyzeRequest Analyze request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Response<Void> analyzeDocumentWithResponse(String modelId, BinaryData analyzeRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.analyzeDocumentSync(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId,
            contentType, accept, analyzeRequest, requestOptions, Context.NONE);
    }

    /**
     * Analyzes document with document model.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * <tr><td>locale</td><td>String</td><td>No</td><td>Locale hint for text recognition and document analysis. Value
     * may contain only
     * the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").</td></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>features</td><td>List&lt;String&gt;</td><td>No</td><td>List of optional analysis features. In the form of
     * "," separated string.</td></tr>
     * <tr><td>queryFields</td><td>List&lt;String&gt;</td><td>No</td><td>List of additional fields to extract. Ex.
     * "NumberOfGuests,StoreNumber". In the form of "," separated string.</td></tr>
     * <tr><td>outputContentFormat</td><td>String</td><td>No</td><td>Format of the analyze result top-level content.
     * Allowed values: "text", "markdown".</td></tr>
     * <tr><td>output</td><td>List&lt;String&gt;</td><td>No</td><td>Additional outputs to generate during analysis. In
     * the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     urlSource: String (Optional)
     *     base64Source: byte[] (Optional)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param analyzeRequest Analyze request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, BinaryData analyzeRequest,
        RequestOptions requestOptions) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeDocumentWithResponseAsync(modelId, analyzeRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.OperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "analyzeResult"),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * <tr><td>locale</td><td>String</td><td>No</td><td>Locale hint for text recognition and document analysis. Value
     * may contain only
     * the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").</td></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>features</td><td>List&lt;String&gt;</td><td>No</td><td>List of optional analysis features. In the form of
     * "," separated string.</td></tr>
     * <tr><td>queryFields</td><td>List&lt;String&gt;</td><td>No</td><td>List of additional fields to extract. Ex.
     * "NumberOfGuests,StoreNumber". In the form of "," separated string.</td></tr>
     * <tr><td>outputContentFormat</td><td>String</td><td>No</td><td>Format of the analyze result top-level content.
     * Allowed values: "text", "markdown".</td></tr>
     * <tr><td>output</td><td>List&lt;String&gt;</td><td>No</td><td>Additional outputs to generate during analysis. In
     * the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     urlSource: String (Optional)
     *     base64Source: byte[] (Optional)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param analyzeRequest Analyze request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, BinaryData analyzeRequest,
        RequestOptions requestOptions) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.analyzeDocumentWithResponse(modelId, analyzeRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.SyncOperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "analyzeResult"),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes document with document model.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * <tr><td>locale</td><td>String</td><td>No</td><td>Locale hint for text recognition and document analysis. Value
     * may contain only
     * the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").</td></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>features</td><td>List&lt;String&gt;</td><td>No</td><td>List of optional analysis features. In the form of
     * "," separated string.</td></tr>
     * <tr><td>queryFields</td><td>List&lt;String&gt;</td><td>No</td><td>List of additional fields to extract. Ex.
     * "NumberOfGuests,StoreNumber". In the form of "," separated string.</td></tr>
     * <tr><td>outputContentFormat</td><td>String</td><td>No</td><td>Format of the analyze result top-level content.
     * Allowed values: "text", "markdown".</td></tr>
     * <tr><td>output</td><td>List&lt;String&gt;</td><td>No</td><td>Additional outputs to generate during analysis. In
     * the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     urlSource: String (Optional)
     *     base64Source: byte[] (Optional)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param analyzeRequest Analyze request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<AnalyzeOperationDetails, AnalyzeResult> beginAnalyzeDocumentWithModelAsync(String modelId,
        BinaryData analyzeRequest, RequestOptions requestOptions) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeDocumentWithResponseAsync(modelId, analyzeRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.OperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "analyzeResult"),
            TypeReference.createInstance(AnalyzeOperationDetails.class),
            TypeReference.createInstance(AnalyzeResult.class));
    }

    /**
     * Analyzes document with document model.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * <tr><td>locale</td><td>String</td><td>No</td><td>Locale hint for text recognition and document analysis. Value
     * may contain only
     * the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").</td></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>features</td><td>List&lt;String&gt;</td><td>No</td><td>List of optional analysis features. In the form of
     * "," separated string.</td></tr>
     * <tr><td>queryFields</td><td>List&lt;String&gt;</td><td>No</td><td>List of additional fields to extract. Ex.
     * "NumberOfGuests,StoreNumber". In the form of "," separated string.</td></tr>
     * <tr><td>outputContentFormat</td><td>String</td><td>No</td><td>Format of the analyze result top-level content.
     * Allowed values: "text", "markdown".</td></tr>
     * <tr><td>output</td><td>List&lt;String&gt;</td><td>No</td><td>Additional outputs to generate during analysis. In
     * the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     urlSource: String (Optional)
     *     base64Source: byte[] (Optional)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param analyzeRequest Analyze request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<AnalyzeOperationDetails, AnalyzeResult> beginAnalyzeDocumentWithModel(String modelId,
        BinaryData analyzeRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.analyzeDocumentWithResponse(modelId, analyzeRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.SyncOperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "analyzeResult"),
            TypeReference.createInstance(AnalyzeOperationDetails.class),
            TypeReference.createInstance(AnalyzeResult.class));
    }

    /**
     * Gets the generated searchable PDF output from document analysis.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * BinaryData
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the generated searchable PDF output from document analysis along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAnalyzeResultPdfWithResponseAsync(String modelId, String resultId,
        RequestOptions requestOptions) {
        final String accept = "application/pdf";
        return FluxUtil.withContext(context -> service.getAnalyzeResultPdf(this.getEndpoint(),
            this.getServiceVersion().getVersion(), modelId, resultId, accept, requestOptions, context));
    }

    /**
     * Gets the generated searchable PDF output from document analysis.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * BinaryData
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the generated searchable PDF output from document analysis along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getAnalyzeResultPdfWithResponse(String modelId, String resultId,
        RequestOptions requestOptions) {
        final String accept = "application/pdf";
        return service.getAnalyzeResultPdfSync(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId,
            resultId, accept, requestOptions, Context.NONE);
    }

    /**
     * Gets the generated cropped image of specified figure from document analysis.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * BinaryData
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @param figureId Figure ID.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the generated cropped image of specified figure from document analysis along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAnalyzeResultFigureWithResponseAsync(String modelId, String resultId,
        String figureId, RequestOptions requestOptions) {
        final String accept = "image/png";
        return FluxUtil.withContext(context -> service.getAnalyzeResultFigure(this.getEndpoint(),
            this.getServiceVersion().getVersion(), modelId, resultId, figureId, accept, requestOptions, context));
    }

    /**
     * Gets the generated cropped image of specified figure from document analysis.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * BinaryData
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @param figureId Figure ID.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the generated cropped image of specified figure from document analysis along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getAnalyzeResultFigureWithResponse(String modelId, String resultId, String figureId,
        RequestOptions requestOptions) {
        final String accept = "image/png";
        return service.getAnalyzeResultFigureSync(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId,
            resultId, figureId, accept, requestOptions, Context.NONE);
    }

    /**
     * Mark the result of document analysis for deletion.
     * 
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAnalyzeResultWithResponseAsync(String modelId, String resultId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.deleteAnalyzeResult(this.getEndpoint(),
            this.getServiceVersion().getVersion(), modelId, resultId, accept, requestOptions, context));
    }

    /**
     * Mark the result of document analysis for deletion.
     * 
     * @param modelId Unique document model name.
     * @param resultId Analyze operation result ID.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteAnalyzeResultWithResponse(String modelId, String resultId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.deleteAnalyzeResultSync(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId,
            resultId, accept, requestOptions, Context.NONE);
    }

    /**
     * Analyzes batch documents with document model.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * <tr><td>locale</td><td>String</td><td>No</td><td>Locale hint for text recognition and document analysis. Value
     * may contain only
     * the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").</td></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>features</td><td>List&lt;String&gt;</td><td>No</td><td>List of optional analysis features. In the form of
     * "," separated string.</td></tr>
     * <tr><td>queryFields</td><td>List&lt;String&gt;</td><td>No</td><td>List of additional fields to extract. Ex.
     * "NumberOfGuests,StoreNumber". In the form of "," separated string.</td></tr>
     * <tr><td>outputContentFormat</td><td>String</td><td>No</td><td>Format of the analyze result top-level content.
     * Allowed values: "text", "markdown".</td></tr>
     * <tr><td>output</td><td>List&lt;String&gt;</td><td>No</td><td>Additional outputs to generate during analysis. In
     * the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     resultContainerUrl: String (Required)
     *     resultPrefix: String (Optional)
     *     overwriteExisting: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param analyzeBatchRequest Analyze batch request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> analyzeBatchDocumentsWithResponseAsync(String modelId, BinaryData analyzeBatchRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(
            context -> service.analyzeBatchDocuments(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId,
                contentType, accept, analyzeBatchRequest, requestOptions, context));
    }

    /**
     * Analyzes batch documents with document model.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * <tr><td>locale</td><td>String</td><td>No</td><td>Locale hint for text recognition and document analysis. Value
     * may contain only
     * the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").</td></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>features</td><td>List&lt;String&gt;</td><td>No</td><td>List of optional analysis features. In the form of
     * "," separated string.</td></tr>
     * <tr><td>queryFields</td><td>List&lt;String&gt;</td><td>No</td><td>List of additional fields to extract. Ex.
     * "NumberOfGuests,StoreNumber". In the form of "," separated string.</td></tr>
     * <tr><td>outputContentFormat</td><td>String</td><td>No</td><td>Format of the analyze result top-level content.
     * Allowed values: "text", "markdown".</td></tr>
     * <tr><td>output</td><td>List&lt;String&gt;</td><td>No</td><td>Additional outputs to generate during analysis. In
     * the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     resultContainerUrl: String (Required)
     *     resultPrefix: String (Optional)
     *     overwriteExisting: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param analyzeBatchRequest Analyze batch request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Response<Void> analyzeBatchDocumentsWithResponse(String modelId, BinaryData analyzeBatchRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.analyzeBatchDocumentsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId,
            contentType, accept, analyzeBatchRequest, requestOptions, Context.NONE);
    }

    /**
     * Analyzes batch documents with document model.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * <tr><td>locale</td><td>String</td><td>No</td><td>Locale hint for text recognition and document analysis. Value
     * may contain only
     * the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").</td></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>features</td><td>List&lt;String&gt;</td><td>No</td><td>List of optional analysis features. In the form of
     * "," separated string.</td></tr>
     * <tr><td>queryFields</td><td>List&lt;String&gt;</td><td>No</td><td>List of additional fields to extract. Ex.
     * "NumberOfGuests,StoreNumber". In the form of "," separated string.</td></tr>
     * <tr><td>outputContentFormat</td><td>String</td><td>No</td><td>Format of the analyze result top-level content.
     * Allowed values: "text", "markdown".</td></tr>
     * <tr><td>output</td><td>List&lt;String&gt;</td><td>No</td><td>Additional outputs to generate during analysis. In
     * the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     resultContainerUrl: String (Required)
     *     resultPrefix: String (Optional)
     *     overwriteExisting: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param analyzeBatchRequest Analyze batch request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeBatchDocumentsAsync(String modelId,
        BinaryData analyzeBatchRequest, RequestOptions requestOptions) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeBatchDocumentsWithResponseAsync(modelId, analyzeBatchRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.OperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes batch documents with document model.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * <tr><td>locale</td><td>String</td><td>No</td><td>Locale hint for text recognition and document analysis. Value
     * may contain only
     * the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").</td></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>features</td><td>List&lt;String&gt;</td><td>No</td><td>List of optional analysis features. In the form of
     * "," separated string.</td></tr>
     * <tr><td>queryFields</td><td>List&lt;String&gt;</td><td>No</td><td>List of additional fields to extract. Ex.
     * "NumberOfGuests,StoreNumber". In the form of "," separated string.</td></tr>
     * <tr><td>outputContentFormat</td><td>String</td><td>No</td><td>Format of the analyze result top-level content.
     * Allowed values: "text", "markdown".</td></tr>
     * <tr><td>output</td><td>List&lt;String&gt;</td><td>No</td><td>Additional outputs to generate during analysis. In
     * the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     resultContainerUrl: String (Required)
     *     resultPrefix: String (Optional)
     *     overwriteExisting: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param analyzeBatchRequest Analyze batch request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeBatchDocuments(String modelId, BinaryData analyzeBatchRequest,
        RequestOptions requestOptions) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.analyzeBatchDocumentsWithResponse(modelId, analyzeBatchRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.SyncOperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Analyzes batch documents with document model.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * <tr><td>locale</td><td>String</td><td>No</td><td>Locale hint for text recognition and document analysis. Value
     * may contain only
     * the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").</td></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>features</td><td>List&lt;String&gt;</td><td>No</td><td>List of optional analysis features. In the form of
     * "," separated string.</td></tr>
     * <tr><td>queryFields</td><td>List&lt;String&gt;</td><td>No</td><td>List of additional fields to extract. Ex.
     * "NumberOfGuests,StoreNumber". In the form of "," separated string.</td></tr>
     * <tr><td>outputContentFormat</td><td>String</td><td>No</td><td>Format of the analyze result top-level content.
     * Allowed values: "text", "markdown".</td></tr>
     * <tr><td>output</td><td>List&lt;String&gt;</td><td>No</td><td>Additional outputs to generate during analysis. In
     * the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     resultContainerUrl: String (Required)
     *     resultPrefix: String (Optional)
     *     overwriteExisting: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param analyzeBatchRequest Analyze batch request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<AnalyzeBatchOperationDetails, AnalyzeBatchResult> beginAnalyzeBatchDocumentsWithModelAsync(
        String modelId, BinaryData analyzeBatchRequest, RequestOptions requestOptions) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.analyzeBatchDocumentsWithResponseAsync(modelId, analyzeBatchRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.OperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(AnalyzeBatchOperationDetails.class),
            TypeReference.createInstance(AnalyzeBatchResult.class));
    }

    /**
     * Analyzes batch documents with document model.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * <tr><td>locale</td><td>String</td><td>No</td><td>Locale hint for text recognition and document analysis. Value
     * may contain only
     * the language code (ex. "en", "fr") or BCP 47 language tag (ex. "en-US").</td></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>features</td><td>List&lt;String&gt;</td><td>No</td><td>List of optional analysis features. In the form of
     * "," separated string.</td></tr>
     * <tr><td>queryFields</td><td>List&lt;String&gt;</td><td>No</td><td>List of additional fields to extract. Ex.
     * "NumberOfGuests,StoreNumber". In the form of "," separated string.</td></tr>
     * <tr><td>outputContentFormat</td><td>String</td><td>No</td><td>Format of the analyze result top-level content.
     * Allowed values: "text", "markdown".</td></tr>
     * <tr><td>output</td><td>List&lt;String&gt;</td><td>No</td><td>Additional outputs to generate during analysis. In
     * the form of "," separated string.</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     resultContainerUrl: String (Required)
     *     resultPrefix: String (Optional)
     *     overwriteExisting: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param analyzeBatchRequest Analyze batch request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<AnalyzeBatchOperationDetails, AnalyzeBatchResult> beginAnalyzeBatchDocumentsWithModel(
        String modelId, BinaryData analyzeBatchRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.analyzeBatchDocumentsWithResponse(modelId, analyzeBatchRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.SyncOperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(AnalyzeBatchOperationDetails.class),
            TypeReference.createInstance(AnalyzeBatchResult.class));
    }

    /**
     * List batch document analysis results.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     resultId: String (Optional)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     percentCompleted: Integer (Optional)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     *     result (Optional): {
     *         succeededCount: int (Required)
     *         failedCount: int (Required)
     *         skippedCount: int (Required)
     *         details (Optional): [
     *              (Optional){
     *                 status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *                 sourceUrl: String (Required)
     *                 resultUrl: String (Optional)
     *                 error (Optional): (recursive schema, see error above)
     *             }
     *         ]
     *     }
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of AnalyzeBatchOperation items along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listAnalyzeBatchResultsSinglePageAsync(String modelId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listAnalyzeBatchResults(this.getEndpoint(),
                this.getServiceVersion().getVersion(), modelId, accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * List batch document analysis results.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     resultId: String (Optional)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     percentCompleted: Integer (Optional)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     *     result (Optional): {
     *         succeededCount: int (Required)
     *         failedCount: int (Required)
     *         skippedCount: int (Required)
     *         details (Optional): [
     *              (Optional){
     *                 status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *                 sourceUrl: String (Required)
     *                 resultUrl: String (Optional)
     *                 error (Optional): (recursive schema, see error above)
     *             }
     *         ]
     *     }
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of AnalyzeBatchOperation items as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listAnalyzeBatchResultsAsync(String modelId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux<>(() -> listAnalyzeBatchResultsSinglePageAsync(modelId, requestOptions),
            nextLink -> listAnalyzeBatchResultsNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * List batch document analysis results.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     resultId: String (Optional)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     percentCompleted: Integer (Optional)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     *     result (Optional): {
     *         succeededCount: int (Required)
     *         failedCount: int (Required)
     *         skippedCount: int (Required)
     *         details (Optional): [
     *              (Optional){
     *                 status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *                 sourceUrl: String (Required)
     *                 resultUrl: String (Optional)
     *                 error (Optional): (recursive schema, see error above)
     *             }
     *         ]
     *     }
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of AnalyzeBatchOperation items along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> listAnalyzeBatchResultsSinglePage(String modelId, RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.listAnalyzeBatchResultsSync(this.getEndpoint(),
            this.getServiceVersion().getVersion(), modelId, accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    /**
     * List batch document analysis results.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     resultId: String (Optional)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     percentCompleted: Integer (Optional)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     *     result (Optional): {
     *         succeededCount: int (Required)
     *         failedCount: int (Required)
     *         skippedCount: int (Required)
     *         details (Optional): [
     *              (Optional){
     *                 status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *                 sourceUrl: String (Required)
     *                 resultUrl: String (Optional)
     *                 error (Optional): (recursive schema, see error above)
     *             }
     *         ]
     *     }
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of AnalyzeBatchOperation items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listAnalyzeBatchResults(String modelId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable<>(() -> listAnalyzeBatchResultsSinglePage(modelId, requestOptions),
            nextLink -> listAnalyzeBatchResultsNextSinglePage(nextLink, requestOptionsForNextPage));
    }

    /**
     * Mark the batch document analysis result for deletion.
     * 
     * @param modelId Unique document model name.
     * @param resultId Analyze batch operation result ID.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAnalyzeBatchResultWithResponseAsync(String modelId, String resultId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.deleteAnalyzeBatchResult(this.getEndpoint(),
            this.getServiceVersion().getVersion(), modelId, resultId, accept, requestOptions, context));
    }

    /**
     * Mark the batch document analysis result for deletion.
     * 
     * @param modelId Unique document model name.
     * @param resultId Analyze batch operation result ID.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteAnalyzeBatchResultWithResponse(String modelId, String resultId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.deleteAnalyzeBatchResultSync(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId,
            resultId, accept, requestOptions, Context.NONE);
    }

    /**
     * Gets the result of batch document analysis.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     resultId: String (Optional)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     percentCompleted: Integer (Optional)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     *     result (Optional): {
     *         succeededCount: int (Required)
     *         failedCount: int (Required)
     *         skippedCount: int (Required)
     *         details (Optional): [
     *              (Optional){
     *                 status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *                 sourceUrl: String (Required)
     *                 resultUrl: String (Optional)
     *                 error (Optional): (recursive schema, see error above)
     *             }
     *         ]
     *     }
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param resultId Analyze batch operation result ID.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the result of batch document analysis along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAnalyzeBatchResultWithResponseAsync(String modelId, String resultId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getAnalyzeBatchResult(this.getEndpoint(),
            this.getServiceVersion().getVersion(), modelId, resultId, accept, requestOptions, context));
    }

    /**
     * Gets the result of batch document analysis.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     resultId: String (Optional)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     percentCompleted: Integer (Optional)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     *     result (Optional): {
     *         succeededCount: int (Required)
     *         failedCount: int (Required)
     *         skippedCount: int (Required)
     *         details (Optional): [
     *              (Optional){
     *                 status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *                 sourceUrl: String (Required)
     *                 resultUrl: String (Optional)
     *                 error (Optional): (recursive schema, see error above)
     *             }
     *         ]
     *     }
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param resultId Analyze batch operation result ID.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the result of batch document analysis along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getAnalyzeBatchResultWithResponse(String modelId, String resultId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getAnalyzeBatchResultSync(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId,
            resultId, accept, requestOptions, Context.NONE);
    }

    /**
     * Classifies document with document classifier.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>split</td><td>String</td><td>No</td><td>Document splitting mode. Allowed values: "auto", "none",
     * "perPage".</td></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     urlSource: String (Optional)
     *     base64Source: byte[] (Optional)
     * }
     * }
     * </pre>
     * 
     * @param classifierId Unique document classifier name.
     * @param classifyRequest Classify request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> classifyDocumentWithResponseAsync(String classifierId, BinaryData classifyRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.classifyDocument(this.getEndpoint(), this.getServiceVersion().getVersion(),
                classifierId, contentType, accept, classifyRequest, requestOptions, context));
    }

    /**
     * Classifies document with document classifier.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>split</td><td>String</td><td>No</td><td>Document splitting mode. Allowed values: "auto", "none",
     * "perPage".</td></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     urlSource: String (Optional)
     *     base64Source: byte[] (Optional)
     * }
     * }
     * </pre>
     * 
     * @param classifierId Unique document classifier name.
     * @param classifyRequest Classify request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Response<Void> classifyDocumentWithResponse(String classifierId, BinaryData classifyRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.classifyDocumentSync(this.getEndpoint(), this.getServiceVersion().getVersion(), classifierId,
            contentType, accept, classifyRequest, requestOptions, Context.NONE);
    }

    /**
     * Classifies document with document classifier.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>split</td><td>String</td><td>No</td><td>Document splitting mode. Allowed values: "auto", "none",
     * "perPage".</td></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     urlSource: String (Optional)
     *     base64Source: byte[] (Optional)
     * }
     * }
     * </pre>
     * 
     * @param classifierId Unique document classifier name.
     * @param classifyRequest Classify request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocumentAsync(String classifierId,
        BinaryData classifyRequest, RequestOptions requestOptions) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.classifyDocumentWithResponseAsync(classifierId, classifyRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.OperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "analyzeResult"),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Classifies document with document classifier.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>split</td><td>String</td><td>No</td><td>Document splitting mode. Allowed values: "auto", "none",
     * "perPage".</td></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     urlSource: String (Optional)
     *     base64Source: byte[] (Optional)
     * }
     * }
     * </pre>
     * 
     * @param classifierId Unique document classifier name.
     * @param classifyRequest Classify request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginClassifyDocument(String classifierId, BinaryData classifyRequest,
        RequestOptions requestOptions) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.classifyDocumentWithResponse(classifierId, classifyRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.SyncOperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "analyzeResult"),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Classifies document with document classifier.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>split</td><td>String</td><td>No</td><td>Document splitting mode. Allowed values: "auto", "none",
     * "perPage".</td></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     urlSource: String (Optional)
     *     base64Source: byte[] (Optional)
     * }
     * }
     * </pre>
     * 
     * @param classifierId Unique document classifier name.
     * @param classifyRequest Classify request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<AnalyzeOperationDetails, AnalyzeResult> beginClassifyDocumentWithModelAsync(String classifierId,
        BinaryData classifyRequest, RequestOptions requestOptions) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.classifyDocumentWithResponseAsync(classifierId, classifyRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.OperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "analyzeResult"),
            TypeReference.createInstance(AnalyzeOperationDetails.class),
            TypeReference.createInstance(AnalyzeResult.class));
    }

    /**
     * Classifies document with document classifier.
     * <p><strong>Query Parameters</strong></p>
     * <table border="1">
     * <caption>Query Parameters</caption>
     * <tr><th>Name</th><th>Type</th><th>Required</th><th>Description</th></tr>
     * <tr><td>stringIndexType</td><td>String</td><td>No</td><td>Method used to compute string offset and length.
     * Allowed values: "textElements", "unicodeCodePoint", "utf16CodeUnit".</td></tr>
     * <tr><td>split</td><td>String</td><td>No</td><td>Document splitting mode. Allowed values: "auto", "none",
     * "perPage".</td></tr>
     * <tr><td>pages</td><td>String</td><td>No</td><td>1-based page numbers to analyze. Ex. "1-3,5,7-9"</td></tr>
     * </table>
     * You can add these to a request with {@link RequestOptions#addQueryParam}
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     urlSource: String (Optional)
     *     base64Source: byte[] (Optional)
     * }
     * }
     * </pre>
     * 
     * @param classifierId Unique document classifier name.
     * @param classifyRequest Classify request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<AnalyzeOperationDetails, AnalyzeResult> beginClassifyDocumentWithModel(String classifierId,
        BinaryData classifyRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.classifyDocumentWithResponse(classifierId, classifyRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.SyncOperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "analyzeResult"),
            TypeReference.createInstance(AnalyzeOperationDetails.class),
            TypeReference.createInstance(AnalyzeResult.class));
    }

    /**
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     resultId: String (Optional)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     percentCompleted: Integer (Optional)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     *     result (Optional): {
     *         succeededCount: int (Required)
     *         failedCount: int (Required)
     *         skippedCount: int (Required)
     *         details (Optional): [
     *              (Optional){
     *                 status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *                 sourceUrl: String (Required)
     *                 resultUrl: String (Optional)
     *                 error (Optional): (recursive schema, see error above)
     *             }
     *         ]
     *     }
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of AnalyzeBatchOperation items along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listAnalyzeBatchResultsNextSinglePageAsync(String nextLink,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listAnalyzeBatchResultsNext(nextLink, this.getEndpoint(), accept,
                requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     resultId: String (Optional)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     percentCompleted: Integer (Optional)
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     *     result (Optional): {
     *         succeededCount: int (Required)
     *         failedCount: int (Required)
     *         skippedCount: int (Required)
     *         details (Optional): [
     *              (Optional){
     *                 status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *                 sourceUrl: String (Required)
     *                 resultUrl: String (Optional)
     *                 error (Optional): (recursive schema, see error above)
     *             }
     *         ]
     *     }
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of AnalyzeBatchOperation items along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> listAnalyzeBatchResultsNextSinglePage(String nextLink,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.listAnalyzeBatchResultsNextSync(nextLink, this.getEndpoint(), accept,
            requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            List<?> values = (List<?>) obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        } catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            return (String) obj.get(path);
        } catch (RuntimeException e) {
            return null;
        }
    }
}
