// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.implementation;

import com.azure.ai.documentintelligence.DocumentIntelligenceServiceVersion;
import com.azure.ai.documentintelligence.models.DocumentClassifierBuildOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentClassifierCopyToOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentClassifierDetails;
import com.azure.ai.documentintelligence.models.DocumentModelBuildOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelComposeOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelCopyToOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelDetails;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingStrategyOptions;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.TypeReference;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

/**
 * Initializes a new instance of the DocumentIntelligenceAdministrationClient type.
 */
public final class DocumentIntelligenceAdministrationClientImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final DocumentIntelligenceAdministrationClientService service;

    /**
     * The Document Intelligence service endpoint.
     */
    private final String endpoint;

    /**
     * Gets The Document Intelligence service endpoint.
     * 
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Service version.
     */
    private final DocumentIntelligenceServiceVersion serviceVersion;

    /**
     * Gets Service version.
     * 
     * @return the serviceVersion value.
     */
    public DocumentIntelligenceServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    /**
     * The HTTP pipeline to send requests through.
     */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /**
     * The serializer to serialize an object into a string.
     */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     * 
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * Initializes an instance of DocumentIntelligenceAdministrationClient client.
     * 
     * @param endpoint The Document Intelligence service endpoint.
     * @param serviceVersion Service version.
     */
    public DocumentIntelligenceAdministrationClientImpl(String endpoint,
        DocumentIntelligenceServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build(),
            JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    /**
     * Initializes an instance of DocumentIntelligenceAdministrationClient client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param endpoint The Document Intelligence service endpoint.
     * @param serviceVersion Service version.
     */
    public DocumentIntelligenceAdministrationClientImpl(HttpPipeline httpPipeline, String endpoint,
        DocumentIntelligenceServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    /**
     * Initializes an instance of DocumentIntelligenceAdministrationClient client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param endpoint The Document Intelligence service endpoint.
     * @param serviceVersion Service version.
     */
    public DocumentIntelligenceAdministrationClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter,
        String endpoint, DocumentIntelligenceServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = RestProxy.create(DocumentIntelligenceAdministrationClientService.class, this.httpPipeline,
            this.getSerializerAdapter());
    }

    /**
     * The interface defining all the services for DocumentIntelligenceAdministrationClient to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{endpoint}/documentintelligence")
    @ServiceInterface(name = "DocumentIntelligence")
    public interface DocumentIntelligenceAdministrationClientService {
        @Post("/documentModels:build")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> buildDocumentModel(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData buildRequest,
            RequestOptions requestOptions, Context context);

        @Post("/documentModels:build")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> buildDocumentModelSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData buildRequest,
            RequestOptions requestOptions, Context context);

        @Post("/documentModels:compose")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> composeModel(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData composeRequest,
            RequestOptions requestOptions, Context context);

        @Post("/documentModels:compose")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> composeModelSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData composeRequest,
            RequestOptions requestOptions, Context context);

        @Post("/documentModels:authorizeCopy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> authorizeModelCopy(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData authorizeCopyRequest,
            RequestOptions requestOptions, Context context);

        @Post("/documentModels:authorizeCopy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> authorizeModelCopySync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData authorizeCopyRequest,
            RequestOptions requestOptions, Context context);

        @Post("/documentModels/{modelId}:copyTo")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> copyModelTo(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData copyToRequest, RequestOptions requestOptions, Context context);

        @Post("/documentModels/{modelId}:copyTo")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> copyModelToSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData copyToRequest, RequestOptions requestOptions, Context context);

        @Get("/documentModels/{modelId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getModel(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/documentModels/{modelId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getModelSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/documentModels")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listModels(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/documentModels")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> listModelsSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Delete("/documentModels/{modelId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> deleteModel(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Delete("/documentModels/{modelId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> deleteModelSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("modelId") String modelId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/info")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getResourceDetails(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/info")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getResourceDetailsSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/operations/{operationId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getOperation(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("operationId") String operationId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/operations/{operationId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getOperationSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("operationId") String operationId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/operations")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listOperations(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/operations")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> listOperationsSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Post("/documentClassifiers:build")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> buildClassifier(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData buildRequest,
            RequestOptions requestOptions, Context context);

        @Post("/documentClassifiers:build")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> buildClassifierSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData buildRequest,
            RequestOptions requestOptions, Context context);

        @Post("/documentClassifiers:authorizeCopy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> authorizeClassifierCopy(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData authorizeCopyRequest,
            RequestOptions requestOptions, Context context);

        @Post("/documentClassifiers:authorizeCopy")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> authorizeClassifierCopySync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Content-Type") String contentType,
            @HeaderParam("Accept") String accept, @BodyParam("application/json") BinaryData authorizeCopyRequest,
            RequestOptions requestOptions, Context context);

        @Post("/documentClassifiers/{classifierId}:copyTo")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> copyClassifierTo(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("classifierId") String classifierId,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData copyToRequest, RequestOptions requestOptions, Context context);

        @Post("/documentClassifiers/{classifierId}:copyTo")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> copyClassifierToSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("classifierId") String classifierId,
            @HeaderParam("Content-Type") String contentType, @HeaderParam("Accept") String accept,
            @BodyParam("application/json") BinaryData copyToRequest, RequestOptions requestOptions, Context context);

        @Get("/documentClassifiers/{classifierId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> getClassifier(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("classifierId") String classifierId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/documentClassifiers/{classifierId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> getClassifierSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("classifierId") String classifierId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("/documentClassifiers")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listClassifiers(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Get("/documentClassifiers")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> listClassifiersSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept,
            RequestOptions requestOptions, Context context);

        @Delete("/documentClassifiers/{classifierId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<Void>> deleteClassifier(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("classifierId") String classifierId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Delete("/documentClassifiers/{classifierId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<Void> deleteClassifierSync(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion, @PathParam("classifierId") String classifierId,
            @HeaderParam("Accept") String accept, RequestOptions requestOptions, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listModelsNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("endpoint") String endpoint, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> listModelsNextSync(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("endpoint") String endpoint, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listOperationsNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("endpoint") String endpoint, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> listOperationsNextSync(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("endpoint") String endpoint, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Mono<Response<BinaryData>> listClassifiersNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("endpoint") String endpoint, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(value = ClientAuthenticationException.class, code = { 401 })
        @UnexpectedResponseExceptionType(value = ResourceNotFoundException.class, code = { 404 })
        @UnexpectedResponseExceptionType(value = ResourceModifiedException.class, code = { 409 })
        @UnexpectedResponseExceptionType(HttpResponseException.class)
        Response<BinaryData> listClassifiersNextSync(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("endpoint") String endpoint, @HeaderParam("Accept") String accept, RequestOptions requestOptions,
            Context context);
    }

    /**
     * Builds a custom document analysis model.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     buildMode: String(template/neural) (Required)
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     maxTrainingHours: Double (Optional)
     *     allowOverwrite: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param buildRequest Build request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> buildDocumentModelWithResponseAsync(BinaryData buildRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.buildDocumentModel(this.getEndpoint(),
            this.getServiceVersion().getVersion(), contentType, accept, buildRequest, requestOptions, context));
    }

    /**
     * Builds a custom document analysis model.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     buildMode: String(template/neural) (Required)
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     maxTrainingHours: Double (Optional)
     *     allowOverwrite: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param buildRequest Build request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Response<Void> buildDocumentModelWithResponse(BinaryData buildRequest, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.buildDocumentModelSync(this.getEndpoint(), this.getServiceVersion().getVersion(), contentType,
            accept, buildRequest, requestOptions, Context.NONE);
    }

    /**
     * Builds a custom document analysis model.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     buildMode: String(template/neural) (Required)
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     maxTrainingHours: Double (Optional)
     *     allowOverwrite: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param buildRequest Build request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildDocumentModelAsync(BinaryData buildRequest,
        RequestOptions requestOptions) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.buildDocumentModelWithResponseAsync(buildRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.OperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Builds a custom document analysis model.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     buildMode: String(template/neural) (Required)
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     maxTrainingHours: Double (Optional)
     *     allowOverwrite: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param buildRequest Build request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildDocumentModel(BinaryData buildRequest,
        RequestOptions requestOptions) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.buildDocumentModelWithResponse(buildRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.SyncOperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Builds a custom document analysis model.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     buildMode: String(template/neural) (Required)
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     maxTrainingHours: Double (Optional)
     *     allowOverwrite: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param buildRequest Build request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentModelBuildOperationDetails, DocumentModelDetails>
        beginBuildDocumentModelWithModelAsync(BinaryData buildRequest, RequestOptions requestOptions) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.buildDocumentModelWithResponseAsync(buildRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.OperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(DocumentModelBuildOperationDetails.class),
            TypeReference.createInstance(DocumentModelDetails.class));
    }

    /**
     * Builds a custom document analysis model.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     buildMode: String(template/neural) (Required)
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     maxTrainingHours: Double (Optional)
     *     allowOverwrite: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param buildRequest Build request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentModelBuildOperationDetails, DocumentModelDetails>
        beginBuildDocumentModelWithModel(BinaryData buildRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.buildDocumentModelWithResponse(buildRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.SyncOperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(DocumentModelBuildOperationDetails.class),
            TypeReference.createInstance(DocumentModelDetails.class));
    }

    /**
     * Creates a new document model from document types of existing document models.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     classifierId: String (Required)
     *     split: String(auto/none/perPage) (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             description: String (Optional)
     *             buildMode: String(template/neural) (Optional)
     *             fieldSchema (Optional): {
     *                 String (Required): {
     *                     type: String(string/date/time/phoneNumber/number/integer/selectionMark/countryRegion/signature/array/object/currency/address/boolean/selectionGroup) (Required)
     *                     description: String (Optional)
     *                     example: String (Optional)
     *                     items (Optional): (recursive schema, see items above)
     *                     properties (Optional): {
     *                         String (Required): (recursive schema, see String above)
     *                     }
     *                 }
     *             }
     *             fieldConfidence (Optional): {
     *                 String: double (Required)
     *             }
     *             modelId: String (Optional)
     *             confidenceThreshold: Double (Optional)
     *             features (Optional): [
     *                 String(ocrHighResolution/languages/barcodes/formulas/keyValuePairs/styleFont/queryFields) (Optional)
     *             ]
     *             queryFields (Optional): [
     *                 String (Optional)
     *             ]
     *             maxDocumentsToAnalyze: Integer (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param composeRequest Compose request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> composeModelWithResponseAsync(BinaryData composeRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.composeModel(this.getEndpoint(),
            this.getServiceVersion().getVersion(), contentType, accept, composeRequest, requestOptions, context));
    }

    /**
     * Creates a new document model from document types of existing document models.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     classifierId: String (Required)
     *     split: String(auto/none/perPage) (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             description: String (Optional)
     *             buildMode: String(template/neural) (Optional)
     *             fieldSchema (Optional): {
     *                 String (Required): {
     *                     type: String(string/date/time/phoneNumber/number/integer/selectionMark/countryRegion/signature/array/object/currency/address/boolean/selectionGroup) (Required)
     *                     description: String (Optional)
     *                     example: String (Optional)
     *                     items (Optional): (recursive schema, see items above)
     *                     properties (Optional): {
     *                         String (Required): (recursive schema, see String above)
     *                     }
     *                 }
     *             }
     *             fieldConfidence (Optional): {
     *                 String: double (Required)
     *             }
     *             modelId: String (Optional)
     *             confidenceThreshold: Double (Optional)
     *             features (Optional): [
     *                 String(ocrHighResolution/languages/barcodes/formulas/keyValuePairs/styleFont/queryFields) (Optional)
     *             ]
     *             queryFields (Optional): [
     *                 String (Optional)
     *             ]
     *             maxDocumentsToAnalyze: Integer (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param composeRequest Compose request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Response<Void> composeModelWithResponse(BinaryData composeRequest, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.composeModelSync(this.getEndpoint(), this.getServiceVersion().getVersion(), contentType, accept,
            composeRequest, requestOptions, Context.NONE);
    }

    /**
     * Creates a new document model from document types of existing document models.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     classifierId: String (Required)
     *     split: String(auto/none/perPage) (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             description: String (Optional)
     *             buildMode: String(template/neural) (Optional)
     *             fieldSchema (Optional): {
     *                 String (Required): {
     *                     type: String(string/date/time/phoneNumber/number/integer/selectionMark/countryRegion/signature/array/object/currency/address/boolean/selectionGroup) (Required)
     *                     description: String (Optional)
     *                     example: String (Optional)
     *                     items (Optional): (recursive schema, see items above)
     *                     properties (Optional): {
     *                         String (Required): (recursive schema, see String above)
     *                     }
     *                 }
     *             }
     *             fieldConfidence (Optional): {
     *                 String: double (Required)
     *             }
     *             modelId: String (Optional)
     *             confidenceThreshold: Double (Optional)
     *             features (Optional): [
     *                 String(ocrHighResolution/languages/barcodes/formulas/keyValuePairs/styleFont/queryFields) (Optional)
     *             ]
     *             queryFields (Optional): [
     *                 String (Optional)
     *             ]
     *             maxDocumentsToAnalyze: Integer (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param composeRequest Compose request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginComposeModelAsync(BinaryData composeRequest,
        RequestOptions requestOptions) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.composeModelWithResponseAsync(composeRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.OperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Creates a new document model from document types of existing document models.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     classifierId: String (Required)
     *     split: String(auto/none/perPage) (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             description: String (Optional)
     *             buildMode: String(template/neural) (Optional)
     *             fieldSchema (Optional): {
     *                 String (Required): {
     *                     type: String(string/date/time/phoneNumber/number/integer/selectionMark/countryRegion/signature/array/object/currency/address/boolean/selectionGroup) (Required)
     *                     description: String (Optional)
     *                     example: String (Optional)
     *                     items (Optional): (recursive schema, see items above)
     *                     properties (Optional): {
     *                         String (Required): (recursive schema, see String above)
     *                     }
     *                 }
     *             }
     *             fieldConfidence (Optional): {
     *                 String: double (Required)
     *             }
     *             modelId: String (Optional)
     *             confidenceThreshold: Double (Optional)
     *             features (Optional): [
     *                 String(ocrHighResolution/languages/barcodes/formulas/keyValuePairs/styleFont/queryFields) (Optional)
     *             ]
     *             queryFields (Optional): [
     *                 String (Optional)
     *             ]
     *             maxDocumentsToAnalyze: Integer (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param composeRequest Compose request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginComposeModel(BinaryData composeRequest,
        RequestOptions requestOptions) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.composeModelWithResponse(composeRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.SyncOperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Creates a new document model from document types of existing document models.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     classifierId: String (Required)
     *     split: String(auto/none/perPage) (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             description: String (Optional)
     *             buildMode: String(template/neural) (Optional)
     *             fieldSchema (Optional): {
     *                 String (Required): {
     *                     type: String(string/date/time/phoneNumber/number/integer/selectionMark/countryRegion/signature/array/object/currency/address/boolean/selectionGroup) (Required)
     *                     description: String (Optional)
     *                     example: String (Optional)
     *                     items (Optional): (recursive schema, see items above)
     *                     properties (Optional): {
     *                         String (Required): (recursive schema, see String above)
     *                     }
     *                 }
     *             }
     *             fieldConfidence (Optional): {
     *                 String: double (Required)
     *             }
     *             modelId: String (Optional)
     *             confidenceThreshold: Double (Optional)
     *             features (Optional): [
     *                 String(ocrHighResolution/languages/barcodes/formulas/keyValuePairs/styleFont/queryFields) (Optional)
     *             ]
     *             queryFields (Optional): [
     *                 String (Optional)
     *             ]
     *             maxDocumentsToAnalyze: Integer (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param composeRequest Compose request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentModelComposeOperationDetails, DocumentModelDetails>
        beginComposeModelWithModelAsync(BinaryData composeRequest, RequestOptions requestOptions) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.composeModelWithResponseAsync(composeRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.OperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(DocumentModelComposeOperationDetails.class),
            TypeReference.createInstance(DocumentModelDetails.class));
    }

    /**
     * Creates a new document model from document types of existing document models.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     classifierId: String (Required)
     *     split: String(auto/none/perPage) (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             description: String (Optional)
     *             buildMode: String(template/neural) (Optional)
     *             fieldSchema (Optional): {
     *                 String (Required): {
     *                     type: String(string/date/time/phoneNumber/number/integer/selectionMark/countryRegion/signature/array/object/currency/address/boolean/selectionGroup) (Required)
     *                     description: String (Optional)
     *                     example: String (Optional)
     *                     items (Optional): (recursive schema, see items above)
     *                     properties (Optional): {
     *                         String (Required): (recursive schema, see String above)
     *                     }
     *                 }
     *             }
     *             fieldConfidence (Optional): {
     *                 String: double (Required)
     *             }
     *             modelId: String (Optional)
     *             confidenceThreshold: Double (Optional)
     *             features (Optional): [
     *                 String(ocrHighResolution/languages/barcodes/formulas/keyValuePairs/styleFont/queryFields) (Optional)
     *             ]
     *             queryFields (Optional): [
     *                 String (Optional)
     *             ]
     *             maxDocumentsToAnalyze: Integer (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param composeRequest Compose request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentModelComposeOperationDetails, DocumentModelDetails>
        beginComposeModelWithModel(BinaryData composeRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.composeModelWithResponse(composeRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.SyncOperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(DocumentModelComposeOperationDetails.class),
            TypeReference.createInstance(DocumentModelDetails.class));
    }

    /**
     * Generates authorization to copy a document model to this location with
     * specified modelId and optional description.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetModelId: String (Required)
     *     targetModelLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     * 
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return authorization to copy a document model to the specified target resource and
     * modelId along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> authorizeModelCopyWithResponseAsync(BinaryData authorizeCopyRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.authorizeModelCopy(this.getEndpoint(),
            this.getServiceVersion().getVersion(), contentType, accept, authorizeCopyRequest, requestOptions, context));
    }

    /**
     * Generates authorization to copy a document model to this location with
     * specified modelId and optional description.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetModelId: String (Required)
     *     targetModelLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     * 
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return authorization to copy a document model to the specified target resource and
     * modelId along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> authorizeModelCopyWithResponse(BinaryData authorizeCopyRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.authorizeModelCopySync(this.getEndpoint(), this.getServiceVersion().getVersion(), contentType,
            accept, authorizeCopyRequest, requestOptions, Context.NONE);
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetModelId: String (Required)
     *     targetModelLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> copyModelToWithResponseAsync(String modelId, BinaryData copyToRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.copyModelTo(this.getEndpoint(), this.getServiceVersion().getVersion(),
                modelId, contentType, accept, copyToRequest, requestOptions, context));
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetModelId: String (Required)
     *     targetModelLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Response<Void> copyModelToWithResponse(String modelId, BinaryData copyToRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.copyModelToSync(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, contentType,
            accept, copyToRequest, requestOptions, Context.NONE);
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetModelId: String (Required)
     *     targetModelLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyModelToAsync(String modelId, BinaryData copyToRequest,
        RequestOptions requestOptions) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.copyModelToWithResponseAsync(modelId, copyToRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.OperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetModelId: String (Required)
     *     targetModelLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyModelTo(String modelId, BinaryData copyToRequest,
        RequestOptions requestOptions) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.copyModelToWithResponse(modelId, copyToRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.SyncOperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetModelId: String (Required)
     *     targetModelLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentModelCopyToOperationDetails, DocumentModelDetails>
        beginCopyModelToWithModelAsync(String modelId, BinaryData copyToRequest, RequestOptions requestOptions) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.copyModelToWithResponseAsync(modelId, copyToRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.OperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(DocumentModelCopyToOperationDetails.class),
            TypeReference.createInstance(DocumentModelDetails.class));
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetModelId: String (Required)
     *     targetModelLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentModelCopyToOperationDetails, DocumentModelDetails>
        beginCopyModelToWithModel(String modelId, BinaryData copyToRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.copyModelToWithResponse(modelId, copyToRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.SyncOperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(DocumentModelCopyToOperationDetails.class),
            TypeReference.createInstance(DocumentModelDetails.class));
    }

    /**
     * Gets detailed document model information.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     buildMode: String(template/neural) (Optional)
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     classifierId: String (Optional)
     *     split: String(auto/none/perPage) (Optional)
     *     docTypes (Optional): {
     *         String (Required): {
     *             description: String (Optional)
     *             buildMode: String(template/neural) (Optional)
     *             fieldSchema (Optional): {
     *                 String (Required): {
     *                     type: String(string/date/time/phoneNumber/number/integer/selectionMark/countryRegion/signature/array/object/currency/address/boolean/selectionGroup) (Required)
     *                     description: String (Optional)
     *                     example: String (Optional)
     *                     items (Optional): (recursive schema, see items above)
     *                     properties (Optional): {
     *                         String (Required): (recursive schema, see String above)
     *                     }
     *                 }
     *             }
     *             fieldConfidence (Optional): {
     *                 String: double (Required)
     *             }
     *             modelId: String (Optional)
     *             confidenceThreshold: Double (Optional)
     *             features (Optional): [
     *                 String(ocrHighResolution/languages/barcodes/formulas/keyValuePairs/styleFont/queryFields) (Optional)
     *             ]
     *             queryFields (Optional): [
     *                 String (Optional)
     *             ]
     *             maxDocumentsToAnalyze: Integer (Optional)
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     *     trainingHours: Double (Optional)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return detailed document model information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getModelWithResponseAsync(String modelId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getModel(this.getEndpoint(),
            this.getServiceVersion().getVersion(), modelId, accept, requestOptions, context));
    }

    /**
     * Gets detailed document model information.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     buildMode: String(template/neural) (Optional)
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     classifierId: String (Optional)
     *     split: String(auto/none/perPage) (Optional)
     *     docTypes (Optional): {
     *         String (Required): {
     *             description: String (Optional)
     *             buildMode: String(template/neural) (Optional)
     *             fieldSchema (Optional): {
     *                 String (Required): {
     *                     type: String(string/date/time/phoneNumber/number/integer/selectionMark/countryRegion/signature/array/object/currency/address/boolean/selectionGroup) (Required)
     *                     description: String (Optional)
     *                     example: String (Optional)
     *                     items (Optional): (recursive schema, see items above)
     *                     properties (Optional): {
     *                         String (Required): (recursive schema, see String above)
     *                     }
     *                 }
     *             }
     *             fieldConfidence (Optional): {
     *                 String: double (Required)
     *             }
     *             modelId: String (Optional)
     *             confidenceThreshold: Double (Optional)
     *             features (Optional): [
     *                 String(ocrHighResolution/languages/barcodes/formulas/keyValuePairs/styleFont/queryFields) (Optional)
     *             ]
     *             queryFields (Optional): [
     *                 String (Optional)
     *             ]
     *             maxDocumentsToAnalyze: Integer (Optional)
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     *     trainingHours: Double (Optional)
     * }
     * }
     * </pre>
     * 
     * @param modelId Unique document model name.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return detailed document model information along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getModelWithResponse(String modelId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getModelSync(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, accept,
            requestOptions, Context.NONE);
    }

    /**
     * List all document models.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     buildMode: String(template/neural) (Optional)
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     classifierId: String (Optional)
     *     split: String(auto/none/perPage) (Optional)
     *     docTypes (Optional): {
     *         String (Required): {
     *             description: String (Optional)
     *             buildMode: String(template/neural) (Optional)
     *             fieldSchema (Optional): {
     *                 String (Required): {
     *                     type: String(string/date/time/phoneNumber/number/integer/selectionMark/countryRegion/signature/array/object/currency/address/boolean/selectionGroup) (Required)
     *                     description: String (Optional)
     *                     example: String (Optional)
     *                     items (Optional): (recursive schema, see items above)
     *                     properties (Optional): {
     *                         String (Required): (recursive schema, see String above)
     *                     }
     *                 }
     *             }
     *             fieldConfidence (Optional): {
     *                 String: double (Required)
     *             }
     *             modelId: String (Optional)
     *             confidenceThreshold: Double (Optional)
     *             features (Optional): [
     *                 String(ocrHighResolution/languages/barcodes/formulas/keyValuePairs/styleFont/queryFields) (Optional)
     *             ]
     *             queryFields (Optional): [
     *                 String (Optional)
     *             ]
     *             maxDocumentsToAnalyze: Integer (Optional)
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     *     trainingHours: Double (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentModelDetails items along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listModelsSinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listModels(this.getEndpoint(), this.getServiceVersion().getVersion(),
                accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * List all document models.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     buildMode: String(template/neural) (Optional)
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     classifierId: String (Optional)
     *     split: String(auto/none/perPage) (Optional)
     *     docTypes (Optional): {
     *         String (Required): {
     *             description: String (Optional)
     *             buildMode: String(template/neural) (Optional)
     *             fieldSchema (Optional): {
     *                 String (Required): {
     *                     type: String(string/date/time/phoneNumber/number/integer/selectionMark/countryRegion/signature/array/object/currency/address/boolean/selectionGroup) (Required)
     *                     description: String (Optional)
     *                     example: String (Optional)
     *                     items (Optional): (recursive schema, see items above)
     *                     properties (Optional): {
     *                         String (Required): (recursive schema, see String above)
     *                     }
     *                 }
     *             }
     *             fieldConfidence (Optional): {
     *                 String: double (Required)
     *             }
     *             modelId: String (Optional)
     *             confidenceThreshold: Double (Optional)
     *             features (Optional): [
     *                 String(ocrHighResolution/languages/barcodes/formulas/keyValuePairs/styleFont/queryFields) (Optional)
     *             ]
     *             queryFields (Optional): [
     *                 String (Optional)
     *             ]
     *             maxDocumentsToAnalyze: Integer (Optional)
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     *     trainingHours: Double (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentModelDetails items as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listModelsAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux<>(() -> listModelsSinglePageAsync(requestOptions),
            nextLink -> listModelsNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * List all document models.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     buildMode: String(template/neural) (Optional)
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     classifierId: String (Optional)
     *     split: String(auto/none/perPage) (Optional)
     *     docTypes (Optional): {
     *         String (Required): {
     *             description: String (Optional)
     *             buildMode: String(template/neural) (Optional)
     *             fieldSchema (Optional): {
     *                 String (Required): {
     *                     type: String(string/date/time/phoneNumber/number/integer/selectionMark/countryRegion/signature/array/object/currency/address/boolean/selectionGroup) (Required)
     *                     description: String (Optional)
     *                     example: String (Optional)
     *                     items (Optional): (recursive schema, see items above)
     *                     properties (Optional): {
     *                         String (Required): (recursive schema, see String above)
     *                     }
     *                 }
     *             }
     *             fieldConfidence (Optional): {
     *                 String: double (Required)
     *             }
     *             modelId: String (Optional)
     *             confidenceThreshold: Double (Optional)
     *             features (Optional): [
     *                 String(ocrHighResolution/languages/barcodes/formulas/keyValuePairs/styleFont/queryFields) (Optional)
     *             ]
     *             queryFields (Optional): [
     *                 String (Optional)
     *             ]
     *             maxDocumentsToAnalyze: Integer (Optional)
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     *     trainingHours: Double (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentModelDetails items along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> listModelsSinglePage(RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.listModelsSync(this.getEndpoint(), this.getServiceVersion().getVersion(),
            accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    /**
     * List all document models.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     buildMode: String(template/neural) (Optional)
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     classifierId: String (Optional)
     *     split: String(auto/none/perPage) (Optional)
     *     docTypes (Optional): {
     *         String (Required): {
     *             description: String (Optional)
     *             buildMode: String(template/neural) (Optional)
     *             fieldSchema (Optional): {
     *                 String (Required): {
     *                     type: String(string/date/time/phoneNumber/number/integer/selectionMark/countryRegion/signature/array/object/currency/address/boolean/selectionGroup) (Required)
     *                     description: String (Optional)
     *                     example: String (Optional)
     *                     items (Optional): (recursive schema, see items above)
     *                     properties (Optional): {
     *                         String (Required): (recursive schema, see String above)
     *                     }
     *                 }
     *             }
     *             fieldConfidence (Optional): {
     *                 String: double (Required)
     *             }
     *             modelId: String (Optional)
     *             confidenceThreshold: Double (Optional)
     *             features (Optional): [
     *                 String(ocrHighResolution/languages/barcodes/formulas/keyValuePairs/styleFont/queryFields) (Optional)
     *             ]
     *             queryFields (Optional): [
     *                 String (Optional)
     *             ]
     *             maxDocumentsToAnalyze: Integer (Optional)
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     *     trainingHours: Double (Optional)
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentModelDetails items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listModels(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable<>(() -> listModelsSinglePage(requestOptions),
            nextLink -> listModelsNextSinglePage(nextLink, requestOptionsForNextPage));
    }

    /**
     * Deletes document model.
     * 
     * @param modelId Unique document model name.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteModelWithResponseAsync(String modelId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.deleteModel(this.getEndpoint(),
            this.getServiceVersion().getVersion(), modelId, accept, requestOptions, context));
    }

    /**
     * Deletes document model.
     * 
     * @param modelId Unique document model name.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteModelWithResponse(String modelId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.deleteModelSync(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, accept,
            requestOptions, Context.NONE);
    }

    /**
     * Return information about the current resource.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     customDocumentModels (Required): {
     *         count: int (Required)
     *         limit: int (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return general information regarding the current resource along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getResourceDetailsWithResponseAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getResourceDetails(this.getEndpoint(),
            this.getServiceVersion().getVersion(), accept, requestOptions, context));
    }

    /**
     * Return information about the current resource.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     customDocumentModels (Required): {
     *         count: int (Required)
     *         limit: int (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return general information regarding the current resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getResourceDetailsWithResponse(RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getResourceDetailsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), accept,
            requestOptions, Context.NONE);
    }

    /**
     * Gets operation info.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kind: String(documentModelBuild/documentModelCompose/documentModelCopyTo/documentClassifierCopyTo/documentClassifierBuild) (Required)
     *     operationId: String (Required)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     percentCompleted: Integer (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     resourceLocation: String (Required)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     * }
     * }
     * </pre>
     * 
     * @param operationId Operation ID.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return operation info along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getOperationWithResponseAsync(String operationId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getOperation(this.getEndpoint(),
            this.getServiceVersion().getVersion(), operationId, accept, requestOptions, context));
    }

    /**
     * Gets operation info.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kind: String(documentModelBuild/documentModelCompose/documentModelCopyTo/documentClassifierCopyTo/documentClassifierBuild) (Required)
     *     operationId: String (Required)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     percentCompleted: Integer (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     resourceLocation: String (Required)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     * }
     * }
     * </pre>
     * 
     * @param operationId Operation ID.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return operation info along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getOperationWithResponse(String operationId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getOperationSync(this.getEndpoint(), this.getServiceVersion().getVersion(), operationId, accept,
            requestOptions, Context.NONE);
    }

    /**
     * Lists all operations.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kind: String(documentModelBuild/documentModelCompose/documentModelCopyTo/documentClassifierCopyTo/documentClassifierBuild) (Required)
     *     operationId: String (Required)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     percentCompleted: Integer (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     resourceLocation: String (Required)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentIntelligenceOperationDetails items along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listOperationsSinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listOperations(this.getEndpoint(), this.getServiceVersion().getVersion(),
                accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * Lists all operations.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kind: String(documentModelBuild/documentModelCompose/documentModelCopyTo/documentClassifierCopyTo/documentClassifierBuild) (Required)
     *     operationId: String (Required)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     percentCompleted: Integer (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     resourceLocation: String (Required)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentIntelligenceOperationDetails items as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listOperationsAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux<>(() -> listOperationsSinglePageAsync(requestOptions),
            nextLink -> listOperationsNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * Lists all operations.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kind: String(documentModelBuild/documentModelCompose/documentModelCopyTo/documentClassifierCopyTo/documentClassifierBuild) (Required)
     *     operationId: String (Required)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     percentCompleted: Integer (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     resourceLocation: String (Required)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentIntelligenceOperationDetails items along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> listOperationsSinglePage(RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.listOperationsSync(this.getEndpoint(), this.getServiceVersion().getVersion(),
            accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    /**
     * Lists all operations.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kind: String(documentModelBuild/documentModelCompose/documentModelCopyTo/documentClassifierCopyTo/documentClassifierBuild) (Required)
     *     operationId: String (Required)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     percentCompleted: Integer (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     resourceLocation: String (Required)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentIntelligenceOperationDetails items as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listOperations(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable<>(() -> listOperationsSinglePage(requestOptions),
            nextLink -> listOperationsNextSinglePage(nextLink, requestOptionsForNextPage));
    }

    /**
     * Builds a custom document classifier.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     baseClassifierId: String (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             sourceKind: String(url/base64/azureBlob/azureBlobFileList) (Optional)
     *             azureBlobSource (Optional): {
     *                 containerUrl: String (Required)
     *                 prefix: String (Optional)
     *             }
     *             azureBlobFileListSource (Optional): {
     *                 containerUrl: String (Required)
     *                 fileList: String (Required)
     *             }
     *         }
     *     }
     *     allowOverwrite: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param buildRequest Build request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> buildClassifierWithResponseAsync(BinaryData buildRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.buildClassifier(this.getEndpoint(),
            this.getServiceVersion().getVersion(), contentType, accept, buildRequest, requestOptions, context));
    }

    /**
     * Builds a custom document classifier.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     baseClassifierId: String (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             sourceKind: String(url/base64/azureBlob/azureBlobFileList) (Optional)
     *             azureBlobSource (Optional): {
     *                 containerUrl: String (Required)
     *                 prefix: String (Optional)
     *             }
     *             azureBlobFileListSource (Optional): {
     *                 containerUrl: String (Required)
     *                 fileList: String (Required)
     *             }
     *         }
     *     }
     *     allowOverwrite: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param buildRequest Build request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Response<Void> buildClassifierWithResponse(BinaryData buildRequest, RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.buildClassifierSync(this.getEndpoint(), this.getServiceVersion().getVersion(), contentType,
            accept, buildRequest, requestOptions, Context.NONE);
    }

    /**
     * Builds a custom document classifier.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     baseClassifierId: String (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             sourceKind: String(url/base64/azureBlob/azureBlobFileList) (Optional)
     *             azureBlobSource (Optional): {
     *                 containerUrl: String (Required)
     *                 prefix: String (Optional)
     *             }
     *             azureBlobFileListSource (Optional): {
     *                 containerUrl: String (Required)
     *                 fileList: String (Required)
     *             }
     *         }
     *     }
     *     allowOverwrite: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param buildRequest Build request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildClassifierAsync(BinaryData buildRequest,
        RequestOptions requestOptions) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.buildClassifierWithResponseAsync(buildRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.OperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Builds a custom document classifier.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     baseClassifierId: String (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             sourceKind: String(url/base64/azureBlob/azureBlobFileList) (Optional)
     *             azureBlobSource (Optional): {
     *                 containerUrl: String (Required)
     *                 prefix: String (Optional)
     *             }
     *             azureBlobFileListSource (Optional): {
     *                 containerUrl: String (Required)
     *                 fileList: String (Required)
     *             }
     *         }
     *     }
     *     allowOverwrite: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param buildRequest Build request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildClassifier(BinaryData buildRequest,
        RequestOptions requestOptions) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.buildClassifierWithResponse(buildRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.SyncOperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Builds a custom document classifier.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     baseClassifierId: String (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             sourceKind: String(url/base64/azureBlob/azureBlobFileList) (Optional)
     *             azureBlobSource (Optional): {
     *                 containerUrl: String (Required)
     *                 prefix: String (Optional)
     *             }
     *             azureBlobFileListSource (Optional): {
     *                 containerUrl: String (Required)
     *                 fileList: String (Required)
     *             }
     *         }
     *     }
     *     allowOverwrite: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param buildRequest Build request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentClassifierBuildOperationDetails, DocumentClassifierDetails>
        beginBuildClassifierWithModelAsync(BinaryData buildRequest, RequestOptions requestOptions) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.buildClassifierWithResponseAsync(buildRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.OperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(DocumentClassifierBuildOperationDetails.class),
            TypeReference.createInstance(DocumentClassifierDetails.class));
    }

    /**
     * Builds a custom document classifier.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     baseClassifierId: String (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             sourceKind: String(url/base64/azureBlob/azureBlobFileList) (Optional)
     *             azureBlobSource (Optional): {
     *                 containerUrl: String (Required)
     *                 prefix: String (Optional)
     *             }
     *             azureBlobFileListSource (Optional): {
     *                 containerUrl: String (Required)
     *                 fileList: String (Required)
     *             }
     *         }
     *     }
     *     allowOverwrite: Boolean (Optional)
     * }
     * }
     * </pre>
     * 
     * @param buildRequest Build request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentClassifierBuildOperationDetails, DocumentClassifierDetails>
        beginBuildClassifierWithModel(BinaryData buildRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.buildClassifierWithResponse(buildRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.SyncOperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(DocumentClassifierBuildOperationDetails.class),
            TypeReference.createInstance(DocumentClassifierDetails.class));
    }

    /**
     * Generates authorization to copy a document classifier to this location with
     * specified classifierId and optional description.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetClassifierId: String (Required)
     *     targetClassifierLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     * 
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return authorization to copy a document classifier to the specified target resource and
     * classifierId along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> authorizeClassifierCopyWithResponseAsync(BinaryData authorizeCopyRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.authorizeClassifierCopy(this.getEndpoint(),
            this.getServiceVersion().getVersion(), contentType, accept, authorizeCopyRequest, requestOptions, context));
    }

    /**
     * Generates authorization to copy a document classifier to this location with
     * specified classifierId and optional description.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetClassifierId: String (Required)
     *     targetClassifierLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     * 
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return authorization to copy a document classifier to the specified target resource and
     * classifierId along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> authorizeClassifierCopyWithResponse(BinaryData authorizeCopyRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.authorizeClassifierCopySync(this.getEndpoint(), this.getServiceVersion().getVersion(),
            contentType, accept, authorizeCopyRequest, requestOptions, Context.NONE);
    }

    /**
     * Copies document classifier to the target resource, region, and classifierId.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetClassifierId: String (Required)
     *     targetClassifierLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     * 
     * @param classifierId Unique document classifier name.
     * @param copyToRequest Copy to request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> copyClassifierToWithResponseAsync(String classifierId, BinaryData copyToRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.copyClassifierTo(this.getEndpoint(), this.getServiceVersion().getVersion(),
                classifierId, contentType, accept, copyToRequest, requestOptions, context));
    }

    /**
     * Copies document classifier to the target resource, region, and classifierId.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetClassifierId: String (Required)
     *     targetClassifierLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     * 
     * @param classifierId Unique document classifier name.
     * @param copyToRequest Copy to request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Response<Void> copyClassifierToWithResponse(String classifierId, BinaryData copyToRequest,
        RequestOptions requestOptions) {
        final String contentType = "application/json";
        final String accept = "application/json";
        return service.copyClassifierToSync(this.getEndpoint(), this.getServiceVersion().getVersion(), classifierId,
            contentType, accept, copyToRequest, requestOptions, Context.NONE);
    }

    /**
     * Copies document classifier to the target resource, region, and classifierId.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetClassifierId: String (Required)
     *     targetClassifierLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     * 
     * @param classifierId Unique document classifier name.
     * @param copyToRequest Copy to request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyClassifierToAsync(String classifierId, BinaryData copyToRequest,
        RequestOptions requestOptions) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.copyClassifierToWithResponseAsync(classifierId, copyToRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.OperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Copies document classifier to the target resource, region, and classifierId.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetClassifierId: String (Required)
     *     targetClassifierLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     * 
     * @param classifierId Unique document classifier name.
     * @param copyToRequest Copy to request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyClassifierTo(String classifierId, BinaryData copyToRequest,
        RequestOptions requestOptions) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.copyClassifierToWithResponse(classifierId, copyToRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.SyncOperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(BinaryData.class), TypeReference.createInstance(BinaryData.class));
    }

    /**
     * Copies document classifier to the target resource, region, and classifierId.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetClassifierId: String (Required)
     *     targetClassifierLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     * 
     * @param classifierId Unique document classifier name.
     * @param copyToRequest Copy to request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentClassifierCopyToOperationDetails, DocumentClassifierDetails>
        beginCopyClassifierToWithModelAsync(String classifierId, BinaryData copyToRequest,
            RequestOptions requestOptions) {
        return PollerFlux.create(Duration.ofSeconds(1),
            () -> this.copyClassifierToWithResponseAsync(classifierId, copyToRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.OperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(DocumentClassifierCopyToOperationDetails.class),
            TypeReference.createInstance(DocumentClassifierDetails.class));
    }

    /**
     * Copies document classifier to the target resource, region, and classifierId.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetClassifierId: String (Required)
     *     targetClassifierLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     * 
     * @param classifierId Unique document classifier name.
     * @param copyToRequest Copy to request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentClassifierCopyToOperationDetails, DocumentClassifierDetails>
        beginCopyClassifierToWithModel(String classifierId, BinaryData copyToRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller(Duration.ofSeconds(1),
            () -> this.copyClassifierToWithResponse(classifierId, copyToRequest, requestOptions),
            new com.azure.ai.documentintelligence.implementation.SyncOperationLocationPollingStrategy<>(
                new PollingStrategyOptions(this.getHttpPipeline())
                    .setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint()))
                    .setContext(requestOptions != null && requestOptions.getContext() != null
                        ? requestOptions.getContext()
                        : Context.NONE)
                    .setServiceVersion(this.getServiceVersion().getVersion()),
                "result"),
            TypeReference.createInstance(DocumentClassifierCopyToOperationDetails.class),
            TypeReference.createInstance(DocumentClassifierDetails.class));
    }

    /**
     * Gets detailed document classifier information.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Required)
     *     baseClassifierId: String (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             sourceKind: String(url/base64/azureBlob/azureBlobFileList) (Optional)
     *             azureBlobSource (Optional): {
     *                 containerUrl: String (Required)
     *                 prefix: String (Optional)
     *             }
     *             azureBlobFileListSource (Optional): {
     *                 containerUrl: String (Required)
     *                 fileList: String (Required)
     *             }
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     * }
     * }
     * </pre>
     * 
     * @param classifierId Unique document classifier name.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return detailed document classifier information along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getClassifierWithResponseAsync(String classifierId,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getClassifier(this.getEndpoint(),
            this.getServiceVersion().getVersion(), classifierId, accept, requestOptions, context));
    }

    /**
     * Gets detailed document classifier information.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Required)
     *     baseClassifierId: String (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             sourceKind: String(url/base64/azureBlob/azureBlobFileList) (Optional)
     *             azureBlobSource (Optional): {
     *                 containerUrl: String (Required)
     *                 prefix: String (Optional)
     *             }
     *             azureBlobFileListSource (Optional): {
     *                 containerUrl: String (Required)
     *                 fileList: String (Required)
     *             }
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     * }
     * }
     * </pre>
     * 
     * @param classifierId Unique document classifier name.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return detailed document classifier information along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getClassifierWithResponse(String classifierId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.getClassifierSync(this.getEndpoint(), this.getServiceVersion().getVersion(), classifierId,
            accept, requestOptions, Context.NONE);
    }

    /**
     * List all document classifiers.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Required)
     *     baseClassifierId: String (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             sourceKind: String(url/base64/azureBlob/azureBlobFileList) (Optional)
     *             azureBlobSource (Optional): {
     *                 containerUrl: String (Required)
     *                 prefix: String (Optional)
     *             }
     *             azureBlobFileListSource (Optional): {
     *                 containerUrl: String (Required)
     *                 fileList: String (Required)
     *             }
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentClassifierDetails items along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listClassifiersSinglePageAsync(RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listClassifiers(this.getEndpoint(), this.getServiceVersion().getVersion(),
                accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * List all document classifiers.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Required)
     *     baseClassifierId: String (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             sourceKind: String(url/base64/azureBlob/azureBlobFileList) (Optional)
     *             azureBlobSource (Optional): {
     *                 containerUrl: String (Required)
     *                 prefix: String (Optional)
     *             }
     *             azureBlobFileListSource (Optional): {
     *                 containerUrl: String (Required)
     *                 fileList: String (Required)
     *             }
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentClassifierDetails items as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listClassifiersAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux<>(() -> listClassifiersSinglePageAsync(requestOptions),
            nextLink -> listClassifiersNextSinglePageAsync(nextLink, requestOptionsForNextPage));
    }

    /**
     * List all document classifiers.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Required)
     *     baseClassifierId: String (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             sourceKind: String(url/base64/azureBlob/azureBlobFileList) (Optional)
     *             azureBlobSource (Optional): {
     *                 containerUrl: String (Required)
     *                 prefix: String (Optional)
     *             }
     *             azureBlobFileListSource (Optional): {
     *                 containerUrl: String (Required)
     *                 fileList: String (Required)
     *             }
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentClassifierDetails items along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> listClassifiersSinglePage(RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res = service.listClassifiersSync(this.getEndpoint(),
            this.getServiceVersion().getVersion(), accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    /**
     * List all document classifiers.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Required)
     *     baseClassifierId: String (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             sourceKind: String(url/base64/azureBlob/azureBlobFileList) (Optional)
     *             azureBlobSource (Optional): {
     *                 containerUrl: String (Required)
     *                 prefix: String (Optional)
     *             }
     *             azureBlobFileListSource (Optional): {
     *                 containerUrl: String (Required)
     *                 fileList: String (Required)
     *             }
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     * }
     * }
     * </pre>
     * 
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentClassifierDetails items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listClassifiers(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(
            requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable<>(() -> listClassifiersSinglePage(requestOptions),
            nextLink -> listClassifiersNextSinglePage(nextLink, requestOptionsForNextPage));
    }

    /**
     * Deletes document classifier.
     * 
     * @param classifierId Unique document classifier name.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteClassifierWithResponseAsync(String classifierId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.deleteClassifier(this.getEndpoint(),
            this.getServiceVersion().getVersion(), classifierId, accept, requestOptions, context));
    }

    /**
     * Deletes document classifier.
     * 
     * @param classifierId Unique document classifier name.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteClassifierWithResponse(String classifierId, RequestOptions requestOptions) {
        final String accept = "application/json";
        return service.deleteClassifierSync(this.getEndpoint(), this.getServiceVersion().getVersion(), classifierId,
            accept, requestOptions, Context.NONE);
    }

    /**
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     buildMode: String(template/neural) (Optional)
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     classifierId: String (Optional)
     *     split: String(auto/none/perPage) (Optional)
     *     docTypes (Optional): {
     *         String (Required): {
     *             description: String (Optional)
     *             buildMode: String(template/neural) (Optional)
     *             fieldSchema (Optional): {
     *                 String (Required): {
     *                     type: String(string/date/time/phoneNumber/number/integer/selectionMark/countryRegion/signature/array/object/currency/address/boolean/selectionGroup) (Required)
     *                     description: String (Optional)
     *                     example: String (Optional)
     *                     items (Optional): (recursive schema, see items above)
     *                     properties (Optional): {
     *                         String (Required): (recursive schema, see String above)
     *                     }
     *                 }
     *             }
     *             fieldConfidence (Optional): {
     *                 String: double (Required)
     *             }
     *             modelId: String (Optional)
     *             confidenceThreshold: Double (Optional)
     *             features (Optional): [
     *                 String(ocrHighResolution/languages/barcodes/formulas/keyValuePairs/styleFont/queryFields) (Optional)
     *             ]
     *             queryFields (Optional): [
     *                 String (Optional)
     *             ]
     *             maxDocumentsToAnalyze: Integer (Optional)
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     *     trainingHours: Double (Optional)
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentModelDetails items along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listModelsNextSinglePageAsync(String nextLink,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listModelsNext(nextLink, this.getEndpoint(), accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     buildMode: String(template/neural) (Optional)
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     classifierId: String (Optional)
     *     split: String(auto/none/perPage) (Optional)
     *     docTypes (Optional): {
     *         String (Required): {
     *             description: String (Optional)
     *             buildMode: String(template/neural) (Optional)
     *             fieldSchema (Optional): {
     *                 String (Required): {
     *                     type: String(string/date/time/phoneNumber/number/integer/selectionMark/countryRegion/signature/array/object/currency/address/boolean/selectionGroup) (Required)
     *                     description: String (Optional)
     *                     example: String (Optional)
     *                     items (Optional): (recursive schema, see items above)
     *                     properties (Optional): {
     *                         String (Required): (recursive schema, see String above)
     *                     }
     *                 }
     *             }
     *             fieldConfidence (Optional): {
     *                 String: double (Required)
     *             }
     *             modelId: String (Optional)
     *             confidenceThreshold: Double (Optional)
     *             features (Optional): [
     *                 String(ocrHighResolution/languages/barcodes/formulas/keyValuePairs/styleFont/queryFields) (Optional)
     *             ]
     *             queryFields (Optional): [
     *                 String (Optional)
     *             ]
     *             maxDocumentsToAnalyze: Integer (Optional)
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     *     trainingHours: Double (Optional)
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentModelDetails items along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> listModelsNextSinglePage(String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res
            = service.listModelsNextSync(nextLink, this.getEndpoint(), accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    /**
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kind: String(documentModelBuild/documentModelCompose/documentModelCopyTo/documentClassifierCopyTo/documentClassifierBuild) (Required)
     *     operationId: String (Required)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     percentCompleted: Integer (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     resourceLocation: String (Required)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentIntelligenceOperationDetails items along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listOperationsNextSinglePageAsync(String nextLink,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listOperationsNext(nextLink, this.getEndpoint(), accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kind: String(documentModelBuild/documentModelCompose/documentModelCopyTo/documentClassifierCopyTo/documentClassifierBuild) (Required)
     *     operationId: String (Required)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     percentCompleted: Integer (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     resourceLocation: String (Required)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentIntelligenceOperationDetails items along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> listOperationsNextSinglePage(String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res
            = service.listOperationsNextSync(nextLink, this.getEndpoint(), accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    /**
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Required)
     *     baseClassifierId: String (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             sourceKind: String(url/base64/azureBlob/azureBlobFileList) (Optional)
     *             azureBlobSource (Optional): {
     *                 containerUrl: String (Required)
     *                 prefix: String (Optional)
     *             }
     *             azureBlobFileListSource (Optional): {
     *                 containerUrl: String (Required)
     *                 fileList: String (Required)
     *             }
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentClassifierDetails items along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listClassifiersNextSinglePageAsync(String nextLink,
        RequestOptions requestOptions) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listClassifiersNext(nextLink, this.getEndpoint(), accept, requestOptions, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null));
    }

    /**
     * Get the next page of items.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Required)
     *     baseClassifierId: String (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             sourceKind: String(url/base64/azureBlob/azureBlobFileList) (Optional)
     *             azureBlobSource (Optional): {
     *                 containerUrl: String (Required)
     *                 prefix: String (Optional)
     *             }
     *             azureBlobFileListSource (Optional): {
     *                 containerUrl: String (Required)
     *                 fileList: String (Required)
     *             }
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     * }
     * }
     * </pre>
     * 
     * @param nextLink The URL to get the next list of items.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentClassifierDetails items along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PagedResponse<BinaryData> listClassifiersNextSinglePage(String nextLink, RequestOptions requestOptions) {
        final String accept = "application/json";
        Response<BinaryData> res
            = service.listClassifiersNextSync(nextLink, this.getEndpoint(), accept, requestOptions, Context.NONE);
        return new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
            getValues(res.getValue(), "value"), getNextLink(res.getValue(), "nextLink"), null);
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            List<?> values = (List<?>) obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        } catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map<?, ?> obj = binaryData.toObject(Map.class);
            return (String) obj.get(path);
        } catch (RuntimeException e) {
            return null;
        }
    }
}
