/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence;

import com.azure.ai.documentintelligence.DocumentIntelligenceAdministrationClientBuilder;
import com.azure.ai.documentintelligence.implementation.DocumentIntelligenceAdministrationClientImpl;
import com.azure.ai.documentintelligence.models.AuthorizeClassifierCopyOptions;
import com.azure.ai.documentintelligence.models.AuthorizeModelCopyOptions;
import com.azure.ai.documentintelligence.models.BuildDocumentClassifierOptions;
import com.azure.ai.documentintelligence.models.BuildDocumentModelOptions;
import com.azure.ai.documentintelligence.models.ClassifierCopyAuthorization;
import com.azure.ai.documentintelligence.models.ComposeDocumentModelOptions;
import com.azure.ai.documentintelligence.models.DocumentClassifierBuildOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentClassifierCopyToOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentClassifierDetails;
import com.azure.ai.documentintelligence.models.DocumentIntelligenceOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentIntelligenceResourceDetails;
import com.azure.ai.documentintelligence.models.DocumentModelBuildOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelComposeOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelCopyToOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelDetails;
import com.azure.ai.documentintelligence.models.ModelCopyAuthorization;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DocumentIntelligenceAdministrationClientBuilder.class, isAsync=true)
public final class DocumentIntelligenceAdministrationAsyncClient {
    private final DocumentIntelligenceAdministrationClientImpl serviceClient;

    DocumentIntelligenceAdministrationAsyncClient(DocumentIntelligenceAdministrationClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildDocumentModel(BinaryData buildRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginBuildDocumentModelAsync(buildRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginComposeModel(BinaryData composeRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginComposeModelAsync(composeRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> authorizeModelCopyWithResponse(BinaryData authorizeCopyRequest, RequestOptions requestOptions) {
        return this.serviceClient.authorizeModelCopyWithResponseAsync(authorizeCopyRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyModelTo(String modelId, BinaryData copyToRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginCopyModelToAsync(modelId, copyToRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getModelWithResponse(String modelId, RequestOptions requestOptions) {
        return this.serviceClient.getModelWithResponseAsync(modelId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listModels(RequestOptions requestOptions) {
        return this.serviceClient.listModelsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteModelWithResponse(String modelId, RequestOptions requestOptions) {
        return this.serviceClient.deleteModelWithResponseAsync(modelId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getResourceDetailsWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getResourceDetailsWithResponseAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getOperationWithResponse(String operationId, RequestOptions requestOptions) {
        return this.serviceClient.getOperationWithResponseAsync(operationId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listOperations(RequestOptions requestOptions) {
        return this.serviceClient.listOperationsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginBuildClassifier(BinaryData buildRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginBuildClassifierAsync(buildRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> authorizeClassifierCopyWithResponse(BinaryData authorizeCopyRequest, RequestOptions requestOptions) {
        return this.serviceClient.authorizeClassifierCopyWithResponseAsync(authorizeCopyRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCopyClassifierTo(String classifierId, BinaryData copyToRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginCopyClassifierToAsync(classifierId, copyToRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getClassifierWithResponse(String classifierId, RequestOptions requestOptions) {
        return this.serviceClient.getClassifierWithResponseAsync(classifierId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listClassifiers(RequestOptions requestOptions) {
        return this.serviceClient.listClassifiersAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteClassifierWithResponse(String classifierId, RequestOptions requestOptions) {
        return this.serviceClient.deleteClassifierWithResponseAsync(classifierId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentModelBuildOperationDetails, DocumentModelDetails> beginBuildDocumentModel(BuildDocumentModelOptions buildRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginBuildDocumentModelWithModelAsync(BinaryData.fromObject((Object)buildRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ModelCopyAuthorization> authorizeModelCopy(AuthorizeModelCopyOptions authorizeCopyRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.authorizeModelCopyWithResponse(BinaryData.fromObject((Object)authorizeCopyRequest), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ModelCopyAuthorization)protocolMethodData.toObject(ModelCopyAuthorization.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentModelCopyToOperationDetails, DocumentModelDetails> beginCopyModelTo(String modelId, ModelCopyAuthorization copyToRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginCopyModelToWithModelAsync(modelId, BinaryData.fromObject((Object)copyToRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentModelDetails> getModel(String modelId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getModelWithResponse(modelId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (DocumentModelDetails)protocolMethodData.toObject(DocumentModelDetails.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DocumentModelDetails> listModels() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listModels(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (DocumentModelDetails)protocolMethodData.toObject(DocumentModelDetails.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteModel(String modelId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteModelWithResponse(modelId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentIntelligenceResourceDetails> getResourceDetails() {
        RequestOptions requestOptions = new RequestOptions();
        return this.getResourceDetailsWithResponse(requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (DocumentIntelligenceResourceDetails)protocolMethodData.toObject(DocumentIntelligenceResourceDetails.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentIntelligenceOperationDetails> getOperation(String operationId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getOperationWithResponse(operationId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (DocumentIntelligenceOperationDetails)protocolMethodData.toObject(DocumentIntelligenceOperationDetails.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DocumentIntelligenceOperationDetails> listOperations() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listOperations(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (DocumentIntelligenceOperationDetails)protocolMethodData.toObject(DocumentIntelligenceOperationDetails.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentClassifierBuildOperationDetails, DocumentClassifierDetails> beginBuildClassifier(BuildDocumentClassifierOptions buildRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginBuildClassifierWithModelAsync(BinaryData.fromObject((Object)buildRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ClassifierCopyAuthorization> authorizeClassifierCopy(AuthorizeClassifierCopyOptions authorizeCopyRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.authorizeClassifierCopyWithResponse(BinaryData.fromObject((Object)authorizeCopyRequest), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ClassifierCopyAuthorization)protocolMethodData.toObject(ClassifierCopyAuthorization.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentClassifierCopyToOperationDetails, DocumentClassifierDetails> beginCopyClassifierTo(String classifierId, ClassifierCopyAuthorization copyToRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginCopyClassifierToWithModelAsync(classifierId, BinaryData.fromObject((Object)copyToRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DocumentClassifierDetails> getClassifier(String classifierId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getClassifierWithResponse(classifierId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (DocumentClassifierDetails)protocolMethodData.toObject(DocumentClassifierDetails.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DocumentClassifierDetails> listClassifiers() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listClassifiers(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (DocumentClassifierDetails)protocolMethodData.toObject(DocumentClassifierDetails.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteClassifier(String classifierId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteClassifierWithResponse(classifierId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DocumentModelComposeOperationDetails, DocumentModelDetails> beginComposeModel(ComposeDocumentModelOptions composeRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginComposeModelWithModelAsync(BinaryData.fromObject((Object)composeRequest), requestOptions);
    }
}

