/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.DocumentClassifierBuildOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentClassifierCopyToOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelBuildOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelComposeOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelCopyToOperationDetails;
import com.azure.ai.documentintelligence.models.Error;
import com.azure.ai.documentintelligence.models.OperationKind;
import com.azure.ai.documentintelligence.models.OperationStatus;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public class OperationDetails
implements JsonSerializable<OperationDetails> {
    private OperationKind kind = OperationKind.fromString("OperationDetails");
    private String operationId;
    private final OperationStatus status;
    private Integer percentCompleted;
    private final OffsetDateTime createdDateTime;
    private final OffsetDateTime lastUpdatedDateTime;
    private final String resourceLocation;
    private String apiVersion;
    private Map<String, String> tags;
    private Error error;

    protected OperationDetails(OperationStatus status, OffsetDateTime createdDateTime, OffsetDateTime lastUpdatedDateTime, String resourceLocation) {
        this.status = status;
        this.createdDateTime = createdDateTime;
        this.lastUpdatedDateTime = lastUpdatedDateTime;
        this.resourceLocation = resourceLocation;
    }

    public OperationKind getKind() {
        return this.kind;
    }

    public String getOperationId() {
        return this.operationId;
    }

    OperationDetails setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public Integer getPercentCompleted() {
        return this.percentCompleted;
    }

    OperationDetails setPercentCompleted(Integer percentCompleted) {
        this.percentCompleted = percentCompleted;
        return this;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public OffsetDateTime getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    OperationDetails setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    OperationDetails setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Error getError() {
        return this.error;
    }

    OperationDetails setError(Error error) {
        this.error = error;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("lastUpdatedDateTime", this.lastUpdatedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedDateTime));
        jsonWriter.writeStringField("resourceLocation", this.resourceLocation);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeNumberField("percentCompleted", (Number)this.percentCompleted);
        jsonWriter.writeStringField("apiVersion", this.apiVersion);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static OperationDetails fromJson(JsonReader jsonReader) throws IOException {
        return (OperationDetails)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                OperationDetails operationDetails;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("documentModelCompose".equals(discriminatorValue)) {
                    operationDetails = DocumentModelComposeOperationDetails.fromJson(readerToUse.reset());
                    return operationDetails;
                }
                if ("documentModelCopyTo".equals(discriminatorValue)) {
                    operationDetails = DocumentModelCopyToOperationDetails.fromJson(readerToUse.reset());
                    return operationDetails;
                }
                if ("documentClassifierCopyTo".equals(discriminatorValue)) {
                    operationDetails = DocumentClassifierCopyToOperationDetails.fromJson(readerToUse.reset());
                    return operationDetails;
                }
                if ("documentClassifierBuild".equals(discriminatorValue)) {
                    operationDetails = DocumentClassifierBuildOperationDetails.fromJson(readerToUse.reset());
                    return operationDetails;
                }
                if ("documentModelBuild".equals(discriminatorValue)) {
                    operationDetails = DocumentModelBuildOperationDetails.fromJson(readerToUse.reset());
                    return operationDetails;
                }
                operationDetails = OperationDetails.fromJsonKnownDiscriminator(readerToUse.reset());
                return operationDetails;
            }
        });
    }

    static OperationDetails fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (OperationDetails)jsonReader.readObject(reader -> {
            String operationId = null;
            OperationStatus status = null;
            OffsetDateTime createdDateTime = null;
            OffsetDateTime lastUpdatedDateTime = null;
            String resourceLocation = null;
            OperationKind kind = null;
            Integer percentCompleted = null;
            String apiVersion = null;
            Map tags = null;
            Error error = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operationId".equals(fieldName)) {
                    operationId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = OperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdatedDateTime".equals(fieldName)) {
                    lastUpdatedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("resourceLocation".equals(fieldName)) {
                    resourceLocation = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = OperationKind.fromString(reader.getString());
                    continue;
                }
                if ("percentCompleted".equals(fieldName)) {
                    percentCompleted = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    apiVersion = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = Error.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            OperationDetails deserializedOperationDetails = new OperationDetails(status, createdDateTime, lastUpdatedDateTime, resourceLocation);
            deserializedOperationDetails.operationId = operationId;
            deserializedOperationDetails.kind = kind;
            deserializedOperationDetails.percentCompleted = percentCompleted;
            deserializedOperationDetails.apiVersion = apiVersion;
            deserializedOperationDetails.tags = tags;
            deserializedOperationDetails.error = error;
            return deserializedOperationDetails;
        });
    }
}

