/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.BoundingRegion;
import com.azure.ai.documentintelligence.models.DocumentSpan;
import com.azure.ai.documentintelligence.models.DocumentTableCellKind;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DocumentTableCell
implements JsonSerializable<DocumentTableCell> {
    private DocumentTableCellKind kind;
    private final int rowIndex;
    private final int columnIndex;
    private Integer rowSpan;
    private Integer columnSpan;
    private final String content;
    private List<BoundingRegion> boundingRegions;
    private final List<DocumentSpan> spans;
    private List<String> elements;

    private DocumentTableCell(int rowIndex, int columnIndex, String content, List<DocumentSpan> spans) {
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.content = content;
        this.spans = spans;
    }

    public DocumentTableCellKind getKind() {
        return this.kind;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public Integer getRowSpan() {
        return this.rowSpan;
    }

    public Integer getColumnSpan() {
        return this.columnSpan;
    }

    public String getContent() {
        return this.content;
    }

    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("rowIndex", this.rowIndex);
        jsonWriter.writeIntField("columnIndex", this.columnIndex);
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeNumberField("rowSpan", (Number)this.rowSpan);
        jsonWriter.writeNumberField("columnSpan", (Number)this.columnSpan);
        jsonWriter.writeArrayField("boundingRegions", this.boundingRegions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("elements", this.elements, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentTableCell fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentTableCell)jsonReader.readObject(reader -> {
            int rowIndex = 0;
            int columnIndex = 0;
            String content = null;
            List spans = null;
            DocumentTableCellKind kind = null;
            Integer rowSpan = null;
            Integer columnSpan = null;
            List boundingRegions = null;
            List elements = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("rowIndex".equals(fieldName)) {
                    rowIndex = reader.getInt();
                    continue;
                }
                if ("columnIndex".equals(fieldName)) {
                    columnIndex = reader.getInt();
                    continue;
                }
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = DocumentTableCellKind.fromString(reader.getString());
                    continue;
                }
                if ("rowSpan".equals(fieldName)) {
                    rowSpan = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("columnSpan".equals(fieldName)) {
                    columnSpan = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("boundingRegions".equals(fieldName)) {
                    boundingRegions = reader.readArray(reader1 -> BoundingRegion.fromJson(reader1));
                    continue;
                }
                if ("elements".equals(fieldName)) {
                    elements = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            DocumentTableCell deserializedDocumentTableCell = new DocumentTableCell(rowIndex, columnIndex, content, spans);
            deserializedDocumentTableCell.kind = kind;
            deserializedDocumentTableCell.rowSpan = rowSpan;
            deserializedDocumentTableCell.columnSpan = columnSpan;
            deserializedDocumentTableCell.boundingRegions = boundingRegions;
            deserializedDocumentTableCell.elements = elements;
            return deserializedDocumentTableCell;
        });
    }
}

