/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.ClassifierDocumentTypeDetails;
import com.azure.ai.documentintelligence.models.Warning;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public final class DocumentClassifierDetails
implements JsonSerializable<DocumentClassifierDetails> {
    private String classifierId;
    private String description;
    private final OffsetDateTime createdDateTime;
    private OffsetDateTime expirationDateTime;
    private final String apiVersion;
    private String baseClassifierId;
    private final Map<String, ClassifierDocumentTypeDetails> docTypes;
    private List<Warning> warnings;

    private DocumentClassifierDetails(OffsetDateTime createdDateTime, String apiVersion, Map<String, ClassifierDocumentTypeDetails> docTypes) {
        this.createdDateTime = createdDateTime;
        this.apiVersion = apiVersion;
        this.docTypes = docTypes;
    }

    public String getClassifierId() {
        return this.classifierId;
    }

    public String getDescription() {
        return this.description;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public OffsetDateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getBaseClassifierId() {
        return this.baseClassifierId;
    }

    public Map<String, ClassifierDocumentTypeDetails> getDocTypes() {
        return this.docTypes;
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("apiVersion", this.apiVersion);
        jsonWriter.writeMapField("docTypes", this.docTypes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("expirationDateTime", this.expirationDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDateTime));
        jsonWriter.writeStringField("baseClassifierId", this.baseClassifierId);
        jsonWriter.writeArrayField("warnings", this.warnings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentClassifierDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentClassifierDetails)jsonReader.readObject(reader -> {
            String classifierId = null;
            OffsetDateTime createdDateTime = null;
            String apiVersion = null;
            Map docTypes = null;
            String description = null;
            OffsetDateTime expirationDateTime = null;
            String baseClassifierId = null;
            List warnings = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("classifierId".equals(fieldName)) {
                    classifierId = reader.getString();
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    apiVersion = reader.getString();
                    continue;
                }
                if ("docTypes".equals(fieldName)) {
                    docTypes = reader.readMap(reader1 -> ClassifierDocumentTypeDetails.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("expirationDateTime".equals(fieldName)) {
                    expirationDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("baseClassifierId".equals(fieldName)) {
                    baseClassifierId = reader.getString();
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    warnings = reader.readArray(reader1 -> Warning.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            DocumentClassifierDetails deserializedDocumentClassifierDetails = new DocumentClassifierDetails(createdDateTime, apiVersion, docTypes);
            deserializedDocumentClassifierDetails.classifierId = classifierId;
            deserializedDocumentClassifierDetails.description = description;
            deserializedDocumentClassifierDetails.expirationDateTime = expirationDateTime;
            deserializedDocumentClassifierDetails.baseClassifierId = baseClassifierId;
            deserializedDocumentClassifierDetails.warnings = warnings;
            return deserializedDocumentClassifierDetails;
        });
    }
}

