/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.Error;
import com.azure.ai.documentintelligence.models.OperationStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AnalyzeBatchOperationDetail
implements JsonSerializable<AnalyzeBatchOperationDetail> {
    private final OperationStatus status;
    private final String sourceUrl;
    private String resultUrl;
    private Error error;

    private AnalyzeBatchOperationDetail(OperationStatus status, String sourceUrl) {
        this.status = status;
        this.sourceUrl = sourceUrl;
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public String getResultUrl() {
        return this.resultUrl;
    }

    public Error getError() {
        return this.error;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("sourceUrl", this.sourceUrl);
        jsonWriter.writeStringField("resultUrl", this.resultUrl);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeBatchOperationDetail fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeBatchOperationDetail)jsonReader.readObject(reader -> {
            OperationStatus status = null;
            String sourceUrl = null;
            String resultUrl = null;
            Error error = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    status = OperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("sourceUrl".equals(fieldName)) {
                    sourceUrl = reader.getString();
                    continue;
                }
                if ("resultUrl".equals(fieldName)) {
                    resultUrl = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = Error.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            AnalyzeBatchOperationDetail deserializedAnalyzeBatchOperationDetail = new AnalyzeBatchOperationDetail(status, sourceUrl);
            deserializedAnalyzeBatchOperationDetail.resultUrl = resultUrl;
            deserializedAnalyzeBatchOperationDetail.error = error;
            return deserializedAnalyzeBatchOperationDetail;
        });
    }
}

