/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.CustomDocumentModelsDetails;
import com.azure.ai.documentintelligence.models.QuotaDetails;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResourceDetails
implements JsonSerializable<ResourceDetails> {
    private final CustomDocumentModelsDetails customDocumentModels;
    private final QuotaDetails customNeuralDocumentModelBuilds;

    private ResourceDetails(CustomDocumentModelsDetails customDocumentModels, QuotaDetails customNeuralDocumentModelBuilds) {
        this.customDocumentModels = customDocumentModels;
        this.customNeuralDocumentModelBuilds = customNeuralDocumentModelBuilds;
    }

    public CustomDocumentModelsDetails getCustomDocumentModels() {
        return this.customDocumentModels;
    }

    public QuotaDetails getCustomNeuralDocumentModelBuilds() {
        return this.customNeuralDocumentModelBuilds;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("customDocumentModels", (JsonSerializable)this.customDocumentModels);
        jsonWriter.writeJsonField("customNeuralDocumentModelBuilds", (JsonSerializable)this.customNeuralDocumentModelBuilds);
        return jsonWriter.writeEndObject();
    }

    public static ResourceDetails fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceDetails)jsonReader.readObject(reader -> {
            CustomDocumentModelsDetails customDocumentModels = null;
            QuotaDetails customNeuralDocumentModelBuilds = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("customDocumentModels".equals(fieldName)) {
                    customDocumentModels = CustomDocumentModelsDetails.fromJson(reader);
                    continue;
                }
                if ("customNeuralDocumentModelBuilds".equals(fieldName)) {
                    customNeuralDocumentModelBuilds = QuotaDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new ResourceDetails(customDocumentModels, customNeuralDocumentModelBuilds);
        });
    }
}

