/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.ComponentDocumentModelDetails;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ComposeDocumentModelRequest
implements JsonSerializable<ComposeDocumentModelRequest> {
    private final String modelId;
    private String description;
    private final List<ComponentDocumentModelDetails> componentModels;
    private Map<String, String> tags;

    public ComposeDocumentModelRequest(String modelId, List<ComponentDocumentModelDetails> componentModels) {
        this.modelId = modelId;
        this.componentModels = componentModels;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getDescription() {
        return this.description;
    }

    public ComposeDocumentModelRequest setDescription(String description) {
        this.description = description;
        return this;
    }

    public List<ComponentDocumentModelDetails> getComponentModels() {
        return this.componentModels;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public ComposeDocumentModelRequest setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("modelId", this.modelId);
        jsonWriter.writeArrayField("componentModels", this.componentModels, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ComposeDocumentModelRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ComposeDocumentModelRequest)jsonReader.readObject(reader -> {
            String modelId = null;
            List componentModels = null;
            String description = null;
            Map tags = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modelId".equals(fieldName)) {
                    modelId = reader.getString();
                    continue;
                }
                if ("componentModels".equals(fieldName)) {
                    componentModels = reader.readArray(reader1 -> ComponentDocumentModelDetails.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ComposeDocumentModelRequest deserializedComposeDocumentModelRequest = new ComposeDocumentModelRequest(modelId, componentModels);
            deserializedComposeDocumentModelRequest.description = description;
            deserializedComposeDocumentModelRequest.tags = tags;
            return deserializedComposeDocumentModelRequest;
        });
    }
}

