/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence;

import com.azure.ai.documentintelligence.DocumentIntelligenceClientBuilder;
import com.azure.ai.documentintelligence.implementation.DocumentAnalysisClientImpl;
import com.azure.ai.documentintelligence.models.AnalyzeDocumentRequest;
import com.azure.ai.documentintelligence.models.AnalyzeResultOperation;
import com.azure.ai.documentintelligence.models.ClassifyDocumentRequest;
import com.azure.ai.documentintelligence.models.ContentFormat;
import com.azure.ai.documentintelligence.models.DocumentAnalysisFeature;
import com.azure.ai.documentintelligence.models.SplitMode;
import com.azure.ai.documentintelligence.models.StringIndexType;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@ServiceClient(builder=DocumentIntelligenceClientBuilder.class, isAsync=true)
public final class DocumentIntelligenceAsyncClient {
    private final DocumentAnalysisClientImpl serviceClient;

    DocumentIntelligenceAsyncClient(DocumentAnalysisClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, RequestOptions requestOptions) {
        return this.serviceClient.beginAnalyzeDocumentAsync(modelId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocument(String classifierId, BinaryData classifyRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginClassifyDocumentAsync(classifierId, classifyRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<AnalyzeResultOperation, AnalyzeResultOperation> beginAnalyzeDocument(String modelId, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, List<String> queryFields, ContentFormat outputContentFormat, AnalyzeDocumentRequest analyzeRequest) {
        RequestOptions requestOptions = new RequestOptions();
        if (pages != null) {
            requestOptions.addQueryParam("pages", pages, false);
        }
        if (locale != null) {
            requestOptions.addQueryParam("locale", locale, false);
        }
        if (stringIndexType != null) {
            requestOptions.addQueryParam("stringIndexType", stringIndexType.toString(), false);
        }
        if (features != null) {
            requestOptions.addQueryParam("features", JacksonAdapter.createDefaultSerializerAdapter().serializeIterable(features, CollectionFormat.CSV), false);
        }
        if (queryFields != null) {
            requestOptions.addQueryParam("queryFields", queryFields.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (outputContentFormat != null) {
            requestOptions.addQueryParam("outputContentFormat", outputContentFormat.toString(), false);
        }
        if (analyzeRequest != null) {
            requestOptions.setBody(BinaryData.fromObject((Object)analyzeRequest));
        }
        return this.serviceClient.beginAnalyzeDocumentWithModelAsync(modelId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<AnalyzeResultOperation, AnalyzeResultOperation> beginAnalyzeDocument(String modelId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginAnalyzeDocumentWithModelAsync(modelId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<AnalyzeResultOperation, AnalyzeResultOperation> beginClassifyDocument(String classifierId, ClassifyDocumentRequest classifyRequest, StringIndexType stringIndexType, SplitMode split) {
        RequestOptions requestOptions = new RequestOptions();
        if (stringIndexType != null) {
            requestOptions.addQueryParam("stringIndexType", stringIndexType.toString(), false);
        }
        if (split != null) {
            requestOptions.addQueryParam("split", split.toString(), false);
        }
        return this.serviceClient.beginClassifyDocumentWithModelAsync(classifierId, BinaryData.fromObject((Object)classifyRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<AnalyzeResultOperation, AnalyzeResultOperation> beginClassifyDocument(String classifierId, ClassifyDocumentRequest classifyRequest) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginClassifyDocumentWithModelAsync(classifierId, BinaryData.fromObject((Object)classifyRequest), requestOptions);
    }
}

