// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * An object representing the location and content of a table cell.
 */
@Immutable
public final class DocumentTableCell {
    /*
     * Table cell kind.
     */
    @Generated
    @JsonProperty(value = "kind")
    private DocumentTableCellKind kind;

    /*
     * Row index of the cell.
     */
    @Generated
    @JsonProperty(value = "rowIndex")
    private int rowIndex;

    /*
     * Column index of the cell.
     */
    @Generated
    @JsonProperty(value = "columnIndex")
    private int columnIndex;

    /*
     * Number of rows spanned by this cell.
     */
    @Generated
    @JsonProperty(value = "rowSpan")
    private Integer rowSpan;

    /*
     * Number of columns spanned by this cell.
     */
    @Generated
    @JsonProperty(value = "columnSpan")
    private Integer columnSpan;

    /*
     * Concatenated content of the table cell in reading order.
     */
    @Generated
    @JsonProperty(value = "content")
    private String content;

    /*
     * Bounding regions covering the table cell.
     */
    @Generated
    @JsonProperty(value = "boundingRegions")
    private List<BoundingRegion> boundingRegions;

    /*
     * Location of the table cell in the reading order concatenated content.
     */
    @Generated
    @JsonProperty(value = "spans")
    private List<DocumentSpan> spans;

    /*
     * Child elements of the table cell.
     */
    @Generated
    @JsonProperty(value = "elements")
    private List<String> elements;

    /**
     * Creates an instance of DocumentTableCell class.
     * 
     * @param rowIndex the rowIndex value to set.
     * @param columnIndex the columnIndex value to set.
     * @param content the content value to set.
     * @param spans the spans value to set.
     */
    @Generated
    @JsonCreator
    private DocumentTableCell(@JsonProperty(value = "rowIndex") int rowIndex,
        @JsonProperty(value = "columnIndex") int columnIndex, @JsonProperty(value = "content") String content,
        @JsonProperty(value = "spans") List<DocumentSpan> spans) {
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.content = content;
        this.spans = spans;
    }

    /**
     * Get the kind property: Table cell kind.
     * 
     * @return the kind value.
     */
    @Generated
    public DocumentTableCellKind getKind() {
        return this.kind;
    }

    /**
     * Get the rowIndex property: Row index of the cell.
     * 
     * @return the rowIndex value.
     */
    @Generated
    public int getRowIndex() {
        return this.rowIndex;
    }

    /**
     * Get the columnIndex property: Column index of the cell.
     * 
     * @return the columnIndex value.
     */
    @Generated
    public int getColumnIndex() {
        return this.columnIndex;
    }

    /**
     * Get the rowSpan property: Number of rows spanned by this cell.
     * 
     * @return the rowSpan value.
     */
    @Generated
    public Integer getRowSpan() {
        return this.rowSpan;
    }

    /**
     * Get the columnSpan property: Number of columns spanned by this cell.
     * 
     * @return the columnSpan value.
     */
    @Generated
    public Integer getColumnSpan() {
        return this.columnSpan;
    }

    /**
     * Get the content property: Concatenated content of the table cell in reading order.
     * 
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Get the boundingRegions property: Bounding regions covering the table cell.
     * 
     * @return the boundingRegions value.
     */
    @Generated
    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    /**
     * Get the spans property: Location of the table cell in the reading order concatenated content.
     * 
     * @return the spans value.
     */
    @Generated
    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    /**
     * Get the elements property: Child elements of the table cell.
     * 
     * @return the elements value.
     */
    @Generated
    public List<String> getElements() {
        return this.elements;
    }
}
