// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A table object consisting table cells arranged in a rectangular layout.
 */
@Immutable
public final class DocumentTable {
    /*
     * Number of rows in the table.
     */
    @Generated
    @JsonProperty(value = "rowCount")
    private int rowCount;

    /*
     * Number of columns in the table.
     */
    @Generated
    @JsonProperty(value = "columnCount")
    private int columnCount;

    /*
     * Cells contained within the table.
     */
    @Generated
    @JsonProperty(value = "cells")
    private List<DocumentTableCell> cells;

    /*
     * Bounding regions covering the table.
     */
    @Generated
    @JsonProperty(value = "boundingRegions")
    private List<BoundingRegion> boundingRegions;

    /*
     * Location of the table in the reading order concatenated content.
     */
    @Generated
    @JsonProperty(value = "spans")
    private List<DocumentSpan> spans;

    /*
     * Caption associated with the table.
     */
    @Generated
    @JsonProperty(value = "caption")
    private DocumentCaption caption;

    /*
     * List of footnotes associated with the table.
     */
    @Generated
    @JsonProperty(value = "footnotes")
    private List<DocumentFootnote> footnotes;

    /**
     * Creates an instance of DocumentTable class.
     * 
     * @param rowCount the rowCount value to set.
     * @param columnCount the columnCount value to set.
     * @param cells the cells value to set.
     * @param spans the spans value to set.
     */
    @Generated
    @JsonCreator
    private DocumentTable(@JsonProperty(value = "rowCount") int rowCount,
        @JsonProperty(value = "columnCount") int columnCount,
        @JsonProperty(value = "cells") List<DocumentTableCell> cells,
        @JsonProperty(value = "spans") List<DocumentSpan> spans) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.cells = cells;
        this.spans = spans;
    }

    /**
     * Get the rowCount property: Number of rows in the table.
     * 
     * @return the rowCount value.
     */
    @Generated
    public int getRowCount() {
        return this.rowCount;
    }

    /**
     * Get the columnCount property: Number of columns in the table.
     * 
     * @return the columnCount value.
     */
    @Generated
    public int getColumnCount() {
        return this.columnCount;
    }

    /**
     * Get the cells property: Cells contained within the table.
     * 
     * @return the cells value.
     */
    @Generated
    public List<DocumentTableCell> getCells() {
        return this.cells;
    }

    /**
     * Get the boundingRegions property: Bounding regions covering the table.
     * 
     * @return the boundingRegions value.
     */
    @Generated
    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    /**
     * Get the spans property: Location of the table in the reading order concatenated content.
     * 
     * @return the spans value.
     */
    @Generated
    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    /**
     * Get the caption property: Caption associated with the table.
     * 
     * @return the caption value.
     */
    @Generated
    public DocumentCaption getCaption() {
        return this.caption;
    }

    /**
     * Get the footnotes property: List of footnotes associated with the table.
     * 
     * @return the footnotes value.
     */
    @Generated
    public List<DocumentFootnote> getFootnotes() {
        return this.footnotes;
    }
}
