// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * An object representing observed text styles.
 */
@Immutable
public final class DocumentStyle {
    /*
     * Is content handwritten?
     */
    @Generated
    @JsonProperty(value = "isHandwritten")
    private Boolean isHandwritten;

    /*
     * Visually most similar font from among the set of supported font families, with
     * fallback fonts following CSS convention (ex. 'Arial, sans-serif').
     */
    @Generated
    @JsonProperty(value = "similarFontFamily")
    private String similarFontFamily;

    /*
     * Font style.
     */
    @Generated
    @JsonProperty(value = "fontStyle")
    private FontStyle fontStyle;

    /*
     * Font weight.
     */
    @Generated
    @JsonProperty(value = "fontWeight")
    private FontWeight fontWeight;

    /*
     * Foreground color in #rrggbb hexadecimal format.
     */
    @Generated
    @JsonProperty(value = "color")
    private String color;

    /*
     * Background color in #rrggbb hexadecimal format..
     */
    @Generated
    @JsonProperty(value = "backgroundColor")
    private String backgroundColor;

    /*
     * Location of the text elements in the concatenated content the style applies to.
     */
    @Generated
    @JsonProperty(value = "spans")
    private List<DocumentSpan> spans;

    /*
     * Confidence of correctly identifying the style.
     */
    @Generated
    @JsonProperty(value = "confidence")
    private double confidence;

    /**
     * Creates an instance of DocumentStyle class.
     * 
     * @param spans the spans value to set.
     * @param confidence the confidence value to set.
     */
    @Generated
    @JsonCreator
    private DocumentStyle(@JsonProperty(value = "spans") List<DocumentSpan> spans,
        @JsonProperty(value = "confidence") double confidence) {
        this.spans = spans;
        this.confidence = confidence;
    }

    /**
     * Get the isHandwritten property: Is content handwritten?.
     * 
     * @return the isHandwritten value.
     */
    @Generated
    public Boolean isHandwritten() {
        return this.isHandwritten;
    }

    /**
     * Get the similarFontFamily property: Visually most similar font from among the set of supported font families,
     * with
     * fallback fonts following CSS convention (ex. 'Arial, sans-serif').
     * 
     * @return the similarFontFamily value.
     */
    @Generated
    public String getSimilarFontFamily() {
        return this.similarFontFamily;
    }

    /**
     * Get the fontStyle property: Font style.
     * 
     * @return the fontStyle value.
     */
    @Generated
    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    /**
     * Get the fontWeight property: Font weight.
     * 
     * @return the fontWeight value.
     */
    @Generated
    public FontWeight getFontWeight() {
        return this.fontWeight;
    }

    /**
     * Get the color property: Foreground color in #rrggbb hexadecimal format.
     * 
     * @return the color value.
     */
    @Generated
    public String getColor() {
        return this.color;
    }

    /**
     * Get the backgroundColor property: Background color in #rrggbb hexadecimal format..
     * 
     * @return the backgroundColor value.
     */
    @Generated
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    /**
     * Get the spans property: Location of the text elements in the concatenated content the style applies to.
     * 
     * @return the spans value.
     */
    @Generated
    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    /**
     * Get the confidence property: Confidence of correctly identifying the style.
     * 
     * @return the confidence value.
     */
    @Generated
    public double getConfidence() {
        return this.confidence;
    }
}
