// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Presence of signature.
 */
public final class DocumentSignatureType extends ExpandableStringEnum<DocumentSignatureType> {
    /**
     * A signature is detected.
     */
    @Generated
    public static final DocumentSignatureType SIGNED = fromString("signed");

    /**
     * No signatures are detected.
     */
    @Generated
    public static final DocumentSignatureType UNSIGNED = fromString("unsigned");

    /**
     * Creates a new instance of DocumentSignatureType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public DocumentSignatureType() {
    }

    /**
     * Creates or finds a DocumentSignatureType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DocumentSignatureType.
     */
    @Generated
    @JsonCreator
    public static DocumentSignatureType fromString(String name) {
        return fromString(name, DocumentSignatureType.class);
    }

    /**
     * Gets known DocumentSignatureType values.
     * 
     * @return known DocumentSignatureType values.
     */
    @Generated
    public static Collection<DocumentSignatureType> values() {
        return values(DocumentSignatureType.class);
    }
}
