// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * An object representing a list in the document.
 */
@Immutable
public final class DocumentList {
    /*
     * Location of the list in the reading order concatenated content.
     */
    @Generated
    @JsonProperty(value = "spans")
    private List<DocumentSpan> spans;

    /*
     * Items in the list.
     */
    @Generated
    @JsonProperty(value = "items")
    private List<DocumentListItem> items;

    /**
     * Creates an instance of DocumentList class.
     * 
     * @param spans the spans value to set.
     * @param items the items value to set.
     */
    @Generated
    @JsonCreator
    private DocumentList(@JsonProperty(value = "spans") List<DocumentSpan> spans,
        @JsonProperty(value = "items") List<DocumentListItem> items) {
        this.spans = spans;
        this.items = items;
    }

    /**
     * Get the spans property: Location of the list in the reading order concatenated content.
     * 
     * @return the spans value.
     */
    @Generated
    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    /**
     * Get the items property: Items in the list.
     * 
     * @return the items value.
     */
    @Generated
    public List<DocumentListItem> getItems() {
        return this.items;
    }
}
