// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * An object representing a form field with distinct field label (key) and field
 * value (may be empty).
 */
@Immutable
public final class DocumentKeyValuePair {
    /*
     * Field label of the key-value pair.
     */
    @Generated
    @JsonProperty(value = "key")
    private DocumentKeyValueElement key;

    /*
     * Field value of the key-value pair.
     */
    @Generated
    @JsonProperty(value = "value")
    private DocumentKeyValueElement value;

    /*
     * Confidence of correctly extracting the key-value pair.
     */
    @Generated
    @JsonProperty(value = "confidence")
    private double confidence;

    /**
     * Creates an instance of DocumentKeyValuePair class.
     * 
     * @param key the key value to set.
     * @param confidence the confidence value to set.
     */
    @Generated
    @JsonCreator
    private DocumentKeyValuePair(@JsonProperty(value = "key") DocumentKeyValueElement key,
        @JsonProperty(value = "confidence") double confidence) {
        this.key = key;
        this.confidence = confidence;
    }

    /**
     * Get the key property: Field label of the key-value pair.
     * 
     * @return the key value.
     */
    @Generated
    public DocumentKeyValueElement getKey() {
        return this.key;
    }

    /**
     * Get the value property: Field value of the key-value pair.
     * 
     * @return the value value.
     */
    @Generated
    public DocumentKeyValueElement getValue() {
        return this.value;
    }

    /**
     * Get the confidence property: Confidence of correctly extracting the key-value pair.
     * 
     * @return the confidence value.
     */
    @Generated
    public double getConfidence() {
        return this.confidence;
    }
}
