// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A formula object.
 */
@Immutable
public final class DocumentFormula {
    /*
     * Formula kind.
     */
    @Generated
    @JsonProperty(value = "kind")
    private DocumentFormulaKind kind;

    /*
     * LaTex expression describing the formula.
     */
    @Generated
    @JsonProperty(value = "value")
    private String value;

    /*
     * Bounding polygon of the formula, with coordinates specified relative to the
     * top-left of the page. The numbers represent the x, y values of the polygon
     * vertices, clockwise from the left (-180 degrees inclusive) relative to the
     * element orientation.
     */
    @Generated
    @JsonProperty(value = "polygon")
    private List<Double> polygon;

    /*
     * Location of the formula in the reading order concatenated content.
     */
    @Generated
    @JsonProperty(value = "span")
    private DocumentSpan span;

    /*
     * Confidence of correctly extracting the formula.
     */
    @Generated
    @JsonProperty(value = "confidence")
    private double confidence;

    /**
     * Creates an instance of DocumentFormula class.
     * 
     * @param kind the kind value to set.
     * @param value the value value to set.
     * @param span the span value to set.
     * @param confidence the confidence value to set.
     */
    @Generated
    @JsonCreator
    private DocumentFormula(@JsonProperty(value = "kind") DocumentFormulaKind kind,
        @JsonProperty(value = "value") String value, @JsonProperty(value = "span") DocumentSpan span,
        @JsonProperty(value = "confidence") double confidence) {
        this.kind = kind;
        this.value = value;
        this.span = span;
        this.confidence = confidence;
    }

    /**
     * Get the kind property: Formula kind.
     * 
     * @return the kind value.
     */
    @Generated
    public DocumentFormulaKind getKind() {
        return this.kind;
    }

    /**
     * Get the value property: LaTex expression describing the formula.
     * 
     * @return the value value.
     */
    @Generated
    public String getValue() {
        return this.value;
    }

    /**
     * Get the polygon property: Bounding polygon of the formula, with coordinates specified relative to the
     * top-left of the page. The numbers represent the x, y values of the polygon
     * vertices, clockwise from the left (-180 degrees inclusive) relative to the
     * element orientation.
     * 
     * @return the polygon value.
     */
    @Generated
    public List<Double> getPolygon() {
        return this.polygon;
    }

    /**
     * Get the span property: Location of the formula in the reading order concatenated content.
     * 
     * @return the span value.
     */
    @Generated
    public DocumentSpan getSpan() {
        return this.span;
    }

    /**
     * Get the confidence property: Confidence of correctly extracting the formula.
     * 
     * @return the confidence value.
     */
    @Generated
    public double getConfidence() {
        return this.confidence;
    }
}
