// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Details regarding custom document models.
 */
@Immutable
public final class CustomDocumentModelsDetails {
    /*
     * Number of custom document models in the current resource.
     */
    @Generated
    @JsonProperty(value = "count")
    private int count;

    /*
     * Maximum number of custom document models supported in the current resource.
     */
    @Generated
    @JsonProperty(value = "limit")
    private int limit;

    /**
     * Creates an instance of CustomDocumentModelsDetails class.
     * 
     * @param count the count value to set.
     * @param limit the limit value to set.
     */
    @Generated
    @JsonCreator
    private CustomDocumentModelsDetails(@JsonProperty(value = "count") int count,
        @JsonProperty(value = "limit") int limit) {
        this.count = count;
        this.limit = limit;
    }

    /**
     * Get the count property: Number of custom document models in the current resource.
     * 
     * @return the count value.
     */
    @Generated
    public int getCount() {
        return this.count;
    }

    /**
     * Get the limit property: Maximum number of custom document models supported in the current resource.
     * 
     * @return the limit value.
     */
    @Generated
    public int getLimit() {
        return this.limit;
    }
}
