// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * Request body to build a new custom document model.
 */
@Fluent
public final class BuildDocumentModelRequest {
    /*
     * Unique document model name.
     */
    @Generated
    @JsonProperty(value = "modelId")
    private String modelId;

    /*
     * Document model description.
     */
    @Generated
    @JsonProperty(value = "description")
    private String description;

    /*
     * Custom document model build mode.
     */
    @Generated
    @JsonProperty(value = "buildMode")
    private DocumentBuildMode buildMode;

    /*
     * Azure Blob Storage location containing the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     */
    @Generated
    @JsonProperty(value = "azureBlobSource")
    private AzureBlobContentSource azureBlobSource;

    /*
     * Azure Blob Storage file list specifying the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     */
    @Generated
    @JsonProperty(value = "azureBlobFileListSource")
    private AzureBlobFileListContentSource azureBlobFileListSource;

    /*
     * List of key-value tag attributes associated with the document model.
     */
    @Generated
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /**
     * Creates an instance of BuildDocumentModelRequest class.
     * 
     * @param modelId the modelId value to set.
     * @param buildMode the buildMode value to set.
     */
    @Generated
    @JsonCreator
    public BuildDocumentModelRequest(@JsonProperty(value = "modelId") String modelId,
        @JsonProperty(value = "buildMode") DocumentBuildMode buildMode) {
        this.modelId = modelId;
        this.buildMode = buildMode;
    }

    /**
     * Get the modelId property: Unique document model name.
     * 
     * @return the modelId value.
     */
    @Generated
    public String getModelId() {
        return this.modelId;
    }

    /**
     * Get the description property: Document model description.
     * 
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: Document model description.
     * 
     * @param description the description value to set.
     * @return the BuildDocumentModelRequest object itself.
     */
    @Generated
    public BuildDocumentModelRequest setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the buildMode property: Custom document model build mode.
     * 
     * @return the buildMode value.
     */
    @Generated
    public DocumentBuildMode getBuildMode() {
        return this.buildMode;
    }

    /**
     * Get the azureBlobSource property: Azure Blob Storage location containing the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     * 
     * @return the azureBlobSource value.
     */
    @Generated
    public AzureBlobContentSource getAzureBlobSource() {
        return this.azureBlobSource;
    }

    /**
     * Set the azureBlobSource property: Azure Blob Storage location containing the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     * 
     * @param azureBlobSource the azureBlobSource value to set.
     * @return the BuildDocumentModelRequest object itself.
     */
    @Generated
    public BuildDocumentModelRequest setAzureBlobSource(AzureBlobContentSource azureBlobSource) {
        this.azureBlobSource = azureBlobSource;
        return this;
    }

    /**
     * Get the azureBlobFileListSource property: Azure Blob Storage file list specifying the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     * 
     * @return the azureBlobFileListSource value.
     */
    @Generated
    public AzureBlobFileListContentSource getAzureBlobFileListSource() {
        return this.azureBlobFileListSource;
    }

    /**
     * Set the azureBlobFileListSource property: Azure Blob Storage file list specifying the training data. Either
     * azureBlobSource or azureBlobFileListSource must be specified.
     * 
     * @param azureBlobFileListSource the azureBlobFileListSource value to set.
     * @return the BuildDocumentModelRequest object itself.
     */
    @Generated
    public BuildDocumentModelRequest
        setAzureBlobFileListSource(AzureBlobFileListContentSource azureBlobFileListSource) {
        this.azureBlobFileListSource = azureBlobFileListSource;
        return this;
    }

    /**
     * Get the tags property: List of key-value tag attributes associated with the document model.
     * 
     * @return the tags value.
     */
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: List of key-value tag attributes associated with the document model.
     * 
     * @param tags the tags value to set.
     * @return the BuildDocumentModelRequest object itself.
     */
    @Generated
    public BuildDocumentModelRequest setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }
}
