// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Bounding polygon on a specific page of the input.
 */
@Immutable
public final class BoundingRegion {
    /*
     * 1-based page number of page containing the bounding region.
     */
    @Generated
    @JsonProperty(value = "pageNumber")
    private int pageNumber;

    /*
     * Bounding polygon on the page, or the entire page if not specified.
     * Coordinates specified relative to the top-left of the page. The numbers
     * represent the x, y values of the polygon vertices, clockwise from the left
     * (-180 degrees inclusive) relative to the element orientation.
     */
    @Generated
    @JsonProperty(value = "polygon")
    private List<Double> polygon;

    /**
     * Creates an instance of BoundingRegion class.
     * 
     * @param pageNumber the pageNumber value to set.
     * @param polygon the polygon value to set.
     */
    @Generated
    @JsonCreator
    private BoundingRegion(@JsonProperty(value = "pageNumber") int pageNumber,
        @JsonProperty(value = "polygon") List<Double> polygon) {
        this.pageNumber = pageNumber;
        this.polygon = polygon;
    }

    /**
     * Get the pageNumber property: 1-based page number of page containing the bounding region.
     * 
     * @return the pageNumber value.
     */
    @Generated
    public int getPageNumber() {
        return this.pageNumber;
    }

    /**
     * Get the polygon property: Bounding polygon on the page, or the entire page if not specified.
     * Coordinates specified relative to the top-left of the page. The numbers
     * represent the x, y values of the polygon vertices, clockwise from the left
     * (-180 degrees inclusive) relative to the element orientation.
     * 
     * @return the polygon value.
     */
    @Generated
    public List<Double> getPolygon() {
        return this.polygon;
    }
}
