// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/**
 * Status and result of the analyze operation.
 */
@Immutable
public final class AnalyzeResultOperation {
    /*
     * Operation status.
     */
    @Generated
    @JsonProperty(value = "status")
    private OperationStatus status;

    /*
     * Date and time (UTC) when the analyze operation was submitted.
     */
    @Generated
    @JsonProperty(value = "createdDateTime")
    private OffsetDateTime createdDateTime;

    /*
     * Date and time (UTC) when the status was last updated.
     */
    @Generated
    @JsonProperty(value = "lastUpdatedDateTime")
    private OffsetDateTime lastUpdatedDateTime;

    /*
     * Encountered error during document analysis.
     */
    @Generated
    @JsonProperty(value = "error")
    private Error error;

    /*
     * Document analysis result.
     */
    @Generated
    @JsonProperty(value = "analyzeResult")
    private AnalyzeResult analyzeResult;

    /**
     * Creates an instance of AnalyzeResultOperation class.
     * 
     * @param status the status value to set.
     * @param createdDateTime the createdDateTime value to set.
     * @param lastUpdatedDateTime the lastUpdatedDateTime value to set.
     */
    @Generated
    @JsonCreator
    private AnalyzeResultOperation(@JsonProperty(value = "status") OperationStatus status,
        @JsonProperty(value = "createdDateTime") OffsetDateTime createdDateTime,
        @JsonProperty(value = "lastUpdatedDateTime") OffsetDateTime lastUpdatedDateTime) {
        this.status = status;
        this.createdDateTime = createdDateTime;
        this.lastUpdatedDateTime = lastUpdatedDateTime;
    }

    /**
     * Get the status property: Operation status.
     * 
     * @return the status value.
     */
    @Generated
    public OperationStatus getStatus() {
        return this.status;
    }

    /**
     * Get the createdDateTime property: Date and time (UTC) when the analyze operation was submitted.
     * 
     * @return the createdDateTime value.
     */
    @Generated
    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    /**
     * Get the lastUpdatedDateTime property: Date and time (UTC) when the status was last updated.
     * 
     * @return the lastUpdatedDateTime value.
     */
    @Generated
    public OffsetDateTime getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    /**
     * Get the error property: Encountered error during document analysis.
     * 
     * @return the error value.
     */
    @Generated
    public Error getError() {
        return this.error;
    }

    /**
     * Get the analyzeResult property: Document analysis result.
     * 
     * @return the analyzeResult value.
     */
    @Generated
    public AnalyzeResult getAnalyzeResult() {
        return this.analyzeResult;
    }
}
