/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class VectorStoreFileCount
implements JsonSerializable<VectorStoreFileCount> {
    private final int inProgress;
    private final int completed;
    private final int failed;
    private final int cancelled;
    private final int total;

    private VectorStoreFileCount(int inProgress, int completed, int failed, int cancelled, int total) {
        this.inProgress = inProgress;
        this.completed = completed;
        this.failed = failed;
        this.cancelled = cancelled;
        this.total = total;
    }

    public int getInProgress() {
        return this.inProgress;
    }

    public int getCompleted() {
        return this.completed;
    }

    public int getFailed() {
        return this.failed;
    }

    public int getCancelled() {
        return this.cancelled;
    }

    public int getTotal() {
        return this.total;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("in_progress", this.inProgress);
        jsonWriter.writeIntField("completed", this.completed);
        jsonWriter.writeIntField("failed", this.failed);
        jsonWriter.writeIntField("cancelled", this.cancelled);
        jsonWriter.writeIntField("total", this.total);
        return jsonWriter.writeEndObject();
    }

    public static VectorStoreFileCount fromJson(JsonReader jsonReader) throws IOException {
        return (VectorStoreFileCount)jsonReader.readObject(reader -> {
            int inProgress = 0;
            int completed = 0;
            int failed = 0;
            int cancelled = 0;
            int total = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("in_progress".equals(fieldName)) {
                    inProgress = reader.getInt();
                    continue;
                }
                if ("completed".equals(fieldName)) {
                    completed = reader.getInt();
                    continue;
                }
                if ("failed".equals(fieldName)) {
                    failed = reader.getInt();
                    continue;
                }
                if ("cancelled".equals(fieldName)) {
                    cancelled = reader.getInt();
                    continue;
                }
                if ("total".equals(fieldName)) {
                    total = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new VectorStoreFileCount(inProgress, completed, failed, cancelled, total);
        });
    }
}

