/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.VectorStoreDataSourceAssetType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class VectorStoreDataSource
implements JsonSerializable<VectorStoreDataSource> {
    private final String assetIdentifier;
    private final VectorStoreDataSourceAssetType assetType;

    public VectorStoreDataSource(String assetIdentifier, VectorStoreDataSourceAssetType assetType) {
        this.assetIdentifier = assetIdentifier;
        this.assetType = assetType;
    }

    public String getAssetIdentifier() {
        return this.assetIdentifier;
    }

    public VectorStoreDataSourceAssetType getAssetType() {
        return this.assetType;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("uri", this.assetIdentifier);
        jsonWriter.writeStringField("type", this.assetType == null ? null : this.assetType.toString());
        return jsonWriter.writeEndObject();
    }

    public static VectorStoreDataSource fromJson(JsonReader jsonReader) throws IOException {
        return (VectorStoreDataSource)jsonReader.readObject(reader -> {
            String assetIdentifier = null;
            VectorStoreDataSourceAssetType assetType = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("uri".equals(fieldName)) {
                    assetIdentifier = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    assetType = VectorStoreDataSourceAssetType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return new VectorStoreDataSource(assetIdentifier, assetType);
        });
    }
}

