/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.VectorStoreConfiguration;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class VectorStoreConfigurations
implements JsonSerializable<VectorStoreConfigurations> {
    private final String storeName;
    private final VectorStoreConfiguration storeConfiguration;

    public VectorStoreConfigurations(String storeName, VectorStoreConfiguration storeConfiguration) {
        this.storeName = storeName;
        this.storeConfiguration = storeConfiguration;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public VectorStoreConfiguration getStoreConfiguration() {
        return this.storeConfiguration;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.storeName);
        jsonWriter.writeJsonField("configuration", (JsonSerializable)this.storeConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static VectorStoreConfigurations fromJson(JsonReader jsonReader) throws IOException {
        return (VectorStoreConfigurations)jsonReader.readObject(reader -> {
            String storeName = null;
            VectorStoreConfiguration storeConfiguration = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    storeName = reader.getString();
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    storeConfiguration = VectorStoreConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new VectorStoreConfigurations(storeName, storeConfiguration);
        });
    }
}

