/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.VectorStoreDataSource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class VectorStoreConfiguration
implements JsonSerializable<VectorStoreConfiguration> {
    private final List<VectorStoreDataSource> dataSources;

    public VectorStoreConfiguration(List<VectorStoreDataSource> dataSources) {
        this.dataSources = dataSources;
    }

    public List<VectorStoreDataSource> getDataSources() {
        return this.dataSources;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("data_sources", this.dataSources, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VectorStoreConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (VectorStoreConfiguration)jsonReader.readObject(reader -> {
            List dataSources = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("data_sources".equals(fieldName)) {
                    dataSources = reader.readArray(reader1 -> VectorStoreDataSource.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new VectorStoreConfiguration(dataSources);
        });
    }
}

