/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.TruncationStrategy;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class TruncationObject
implements JsonSerializable<TruncationObject> {
    private final TruncationStrategy type;
    private Integer lastMessages;

    public TruncationObject(TruncationStrategy type) {
        this.type = type;
    }

    public TruncationStrategy getType() {
        return this.type;
    }

    public Integer getLastMessages() {
        return this.lastMessages;
    }

    public TruncationObject setLastMessages(Integer lastMessages) {
        this.lastMessages = lastMessages;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeNumberField("last_messages", (Number)this.lastMessages);
        return jsonWriter.writeEndObject();
    }

    public static TruncationObject fromJson(JsonReader jsonReader) throws IOException {
        return (TruncationObject)jsonReader.readObject(reader -> {
            TruncationStrategy type = null;
            Integer lastMessages = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    type = TruncationStrategy.fromString(reader.getString());
                    continue;
                }
                if ("last_messages".equals(fieldName)) {
                    lastMessages = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            TruncationObject deserializedTruncationObject = new TruncationObject(type);
            deserializedTruncationObject.lastMessages = lastMessages;
            return deserializedTruncationObject;
        });
    }
}

