/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.RunStepDetails;
import com.azure.ai.agents.persistent.models.RunStepToolCall;
import com.azure.ai.agents.persistent.models.RunStepType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class RunStepToolCallDetails
extends RunStepDetails {
    private RunStepType type = RunStepType.TOOL_CALLS;
    private final List<RunStepToolCall> toolCalls;

    private RunStepToolCallDetails(List<RunStepToolCall> toolCalls) {
        this.toolCalls = toolCalls;
    }

    @Override
    public RunStepType getType() {
        return this.type;
    }

    public List<RunStepToolCall> getToolCalls() {
        return this.toolCalls;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tool_calls", this.toolCalls, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static RunStepToolCallDetails fromJson(JsonReader jsonReader) throws IOException {
        return (RunStepToolCallDetails)jsonReader.readObject(reader -> {
            List toolCalls = null;
            RunStepType type = RunStepType.TOOL_CALLS;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tool_calls".equals(fieldName)) {
                    toolCalls = reader.readArray(reader1 -> RunStepToolCall.fromJson(reader1));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = RunStepType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            RunStepToolCallDetails deserializedRunStepToolCallDetails = new RunStepToolCallDetails(toolCalls);
            deserializedRunStepToolCallDetails.type = type;
            return deserializedRunStepToolCallDetails;
        });
    }
}

