/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.RunStepToolCall;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class RunStepOpenApiToolCall
extends RunStepToolCall {
    private String type = "openapi";
    private final Map<String, String> openApi;

    private RunStepOpenApiToolCall(String id, Map<String, String> openApi) {
        super(id);
        this.openApi = openApi;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public Map<String, String> getOpenApi() {
        return this.openApi;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeMapField("openapi", this.openApi, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static RunStepOpenApiToolCall fromJson(JsonReader jsonReader) throws IOException {
        return (RunStepOpenApiToolCall)jsonReader.readObject(reader -> {
            String id = null;
            Map openApi = null;
            String type = "openapi";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("openapi".equals(fieldName)) {
                    openApi = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            RunStepOpenApiToolCall deserializedRunStepOpenApiToolCall = new RunStepOpenApiToolCall(id, openApi);
            deserializedRunStepOpenApiToolCall.type = type;
            return deserializedRunStepOpenApiToolCall;
        });
    }
}

