/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.RunStepDetails;
import com.azure.ai.agents.persistent.models.RunStepMessageCreationReference;
import com.azure.ai.agents.persistent.models.RunStepType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class RunStepMessageCreationDetails
extends RunStepDetails {
    private RunStepType type = RunStepType.MESSAGE_CREATION;
    private final RunStepMessageCreationReference messageCreation;

    private RunStepMessageCreationDetails(RunStepMessageCreationReference messageCreation) {
        this.messageCreation = messageCreation;
    }

    @Override
    public RunStepType getType() {
        return this.type;
    }

    public RunStepMessageCreationReference getMessageCreation() {
        return this.messageCreation;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("message_creation", (JsonSerializable)this.messageCreation);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static RunStepMessageCreationDetails fromJson(JsonReader jsonReader) throws IOException {
        return (RunStepMessageCreationDetails)jsonReader.readObject(reader -> {
            RunStepMessageCreationReference messageCreation = null;
            RunStepType type = RunStepType.MESSAGE_CREATION;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("message_creation".equals(fieldName)) {
                    messageCreation = RunStepMessageCreationReference.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = RunStepType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            RunStepMessageCreationDetails deserializedRunStepMessageCreationDetails = new RunStepMessageCreationDetails(messageCreation);
            deserializedRunStepMessageCreationDetails.type = type;
            return deserializedRunStepMessageCreationDetails;
        });
    }
}

