/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.RunStepFileSearchToolCallResults;
import com.azure.ai.agents.persistent.models.RunStepToolCall;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class RunStepFileSearchToolCall
extends RunStepToolCall {
    private String type = "file_search";
    private final RunStepFileSearchToolCallResults fileSearch;

    private RunStepFileSearchToolCall(String id, RunStepFileSearchToolCallResults fileSearch) {
        super(id);
        this.fileSearch = fileSearch;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public RunStepFileSearchToolCallResults getFileSearch() {
        return this.fileSearch;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeJsonField("file_search", (JsonSerializable)this.fileSearch);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static RunStepFileSearchToolCall fromJson(JsonReader jsonReader) throws IOException {
        return (RunStepFileSearchToolCall)jsonReader.readObject(reader -> {
            String id = null;
            RunStepFileSearchToolCallResults fileSearch = null;
            String type = "file_search";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("file_search".equals(fieldName)) {
                    fileSearch = RunStepFileSearchToolCallResults.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            RunStepFileSearchToolCall deserializedRunStepFileSearchToolCall = new RunStepFileSearchToolCall(id, fileSearch);
            deserializedRunStepFileSearchToolCall.type = type;
            return deserializedRunStepFileSearchToolCall;
        });
    }
}

