/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.RunStepDeltaToolCall;
import com.azure.ai.agents.persistent.models.RunStepFileSearchToolCallResults;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class RunStepDeltaFileSearchToolCall
extends RunStepDeltaToolCall {
    private String type = "file_search";
    private RunStepFileSearchToolCallResults fileSearch;

    private RunStepDeltaFileSearchToolCall(int index, String id) {
        super(index, id);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public RunStepFileSearchToolCallResults getFileSearch() {
        return this.fileSearch;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", this.getIndex());
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("file_search", (JsonSerializable)this.fileSearch);
        return jsonWriter.writeEndObject();
    }

    public static RunStepDeltaFileSearchToolCall fromJson(JsonReader jsonReader) throws IOException {
        return (RunStepDeltaFileSearchToolCall)jsonReader.readObject(reader -> {
            int index = 0;
            String id = null;
            String type = "file_search";
            RunStepFileSearchToolCallResults fileSearch = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("file_search".equals(fieldName)) {
                    fileSearch = RunStepFileSearchToolCallResults.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            RunStepDeltaFileSearchToolCall deserializedRunStepDeltaFileSearchToolCall = new RunStepDeltaFileSearchToolCall(index, id);
            deserializedRunStepDeltaFileSearchToolCall.type = type;
            deserializedRunStepDeltaFileSearchToolCall.fileSearch = fileSearch;
            return deserializedRunStepDeltaFileSearchToolCall;
        });
    }
}

