/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.RunStepToolCall;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class RunStepAzureAISearchToolCall
extends RunStepToolCall {
    private String type = "azure_ai_search";
    private final Map<String, String> azureAISearch;

    private RunStepAzureAISearchToolCall(String id, Map<String, String> azureAISearch) {
        super(id);
        this.azureAISearch = azureAISearch;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public Map<String, String> getAzureAISearch() {
        return this.azureAISearch;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeMapField("azure_ai_search", this.azureAISearch, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static RunStepAzureAISearchToolCall fromJson(JsonReader jsonReader) throws IOException {
        return (RunStepAzureAISearchToolCall)jsonReader.readObject(reader -> {
            String id = null;
            Map azureAISearch = null;
            String type = "azure_ai_search";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("azure_ai_search".equals(fieldName)) {
                    azureAISearch = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            RunStepAzureAISearchToolCall deserializedRunStepAzureAISearchToolCall = new RunStepAzureAISearchToolCall(id, azureAISearch);
            deserializedRunStepAzureAISearchToolCall.type = type;
            return deserializedRunStepAzureAISearchToolCall;
        });
    }
}

