/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.OpenApiAuthDetails;
import com.azure.ai.agents.persistent.models.OpenApiAuthType;
import com.azure.ai.agents.persistent.models.OpenApiManagedSecurityScheme;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OpenApiManagedAuthDetails
extends OpenApiAuthDetails {
    private OpenApiAuthType type = OpenApiAuthType.MANAGED_IDENTITY;
    private final OpenApiManagedSecurityScheme securityScheme;

    public OpenApiManagedAuthDetails(OpenApiManagedSecurityScheme securityScheme) {
        this.securityScheme = securityScheme;
    }

    @Override
    public OpenApiAuthType getType() {
        return this.type;
    }

    public OpenApiManagedSecurityScheme getSecurityScheme() {
        return this.securityScheme;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("security_scheme", (JsonSerializable)this.securityScheme);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static OpenApiManagedAuthDetails fromJson(JsonReader jsonReader) throws IOException {
        return (OpenApiManagedAuthDetails)jsonReader.readObject(reader -> {
            OpenApiManagedSecurityScheme securityScheme = null;
            OpenApiAuthType type = OpenApiAuthType.MANAGED_IDENTITY;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("security_scheme".equals(fieldName)) {
                    securityScheme = OpenApiManagedSecurityScheme.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = OpenApiAuthType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            OpenApiManagedAuthDetails deserializedOpenApiManagedAuthDetails = new OpenApiManagedAuthDetails(securityScheme);
            deserializedOpenApiManagedAuthDetails.type = type;
            return deserializedOpenApiManagedAuthDetails;
        });
    }
}

