/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.OpenApiAuthDetails;
import com.azure.ai.agents.persistent.models.OpenApiAuthType;
import com.azure.ai.agents.persistent.models.OpenApiConnectionSecurityScheme;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OpenApiConnectionAuthDetails
extends OpenApiAuthDetails {
    private OpenApiAuthType type = OpenApiAuthType.CONNECTION;
    private final OpenApiConnectionSecurityScheme securityScheme;

    public OpenApiConnectionAuthDetails(OpenApiConnectionSecurityScheme securityScheme) {
        this.securityScheme = securityScheme;
    }

    @Override
    public OpenApiAuthType getType() {
        return this.type;
    }

    public OpenApiConnectionSecurityScheme getSecurityScheme() {
        return this.securityScheme;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("security_scheme", (JsonSerializable)this.securityScheme);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static OpenApiConnectionAuthDetails fromJson(JsonReader jsonReader) throws IOException {
        return (OpenApiConnectionAuthDetails)jsonReader.readObject(reader -> {
            OpenApiConnectionSecurityScheme securityScheme = null;
            OpenApiAuthType type = OpenApiAuthType.CONNECTION;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("security_scheme".equals(fieldName)) {
                    securityScheme = OpenApiConnectionSecurityScheme.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = OpenApiAuthType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            OpenApiConnectionAuthDetails deserializedOpenApiConnectionAuthDetails = new OpenApiConnectionAuthDetails(securityScheme);
            deserializedOpenApiConnectionAuthDetails.type = type;
            return deserializedOpenApiConnectionAuthDetails;
        });
    }
}

