/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.MessageBlockType;
import com.azure.ai.agents.persistent.models.MessageInputContentBlock;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MessageInputTextBlock
extends MessageInputContentBlock {
    private MessageBlockType type = MessageBlockType.TEXT;
    private final String text;

    public MessageInputTextBlock(String text) {
        this.text = text;
    }

    @Override
    public MessageBlockType getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static MessageInputTextBlock fromJson(JsonReader jsonReader) throws IOException {
        return (MessageInputTextBlock)jsonReader.readObject(reader -> {
            String text = null;
            MessageBlockType type = MessageBlockType.TEXT;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = MessageBlockType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            MessageInputTextBlock deserializedMessageInputTextBlock = new MessageInputTextBlock(text);
            deserializedMessageInputTextBlock.type = type;
            return deserializedMessageInputTextBlock;
        });
    }
}

