/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.MessageBlockType;
import com.azure.ai.agents.persistent.models.MessageImageFileParam;
import com.azure.ai.agents.persistent.models.MessageInputContentBlock;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MessageInputImageFileBlock
extends MessageInputContentBlock {
    private MessageBlockType type = MessageBlockType.IMAGE_FILE;
    private final MessageImageFileParam imageFile;

    public MessageInputImageFileBlock(MessageImageFileParam imageFile) {
        this.imageFile = imageFile;
    }

    @Override
    public MessageBlockType getType() {
        return this.type;
    }

    public MessageImageFileParam getImageFile() {
        return this.imageFile;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("image_file", (JsonSerializable)this.imageFile);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static MessageInputImageFileBlock fromJson(JsonReader jsonReader) throws IOException {
        return (MessageInputImageFileBlock)jsonReader.readObject(reader -> {
            MessageImageFileParam imageFile = null;
            MessageBlockType type = MessageBlockType.IMAGE_FILE;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image_file".equals(fieldName)) {
                    imageFile = MessageImageFileParam.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = MessageBlockType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            MessageInputImageFileBlock deserializedMessageInputImageFileBlock = new MessageInputImageFileBlock(imageFile);
            deserializedMessageInputImageFileBlock.type = type;
            return deserializedMessageInputImageFileBlock;
        });
    }
}

